<div>
    <livewire:dashboard.page-title :page_title="$page_title"/>

    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h5>{{ $title }}</h5>
                    </div>
                    <div class="card-body">
                        <form enctype="multipart/form-data" x-data="{ isUploading: false }" wire:submit.prevent="save"
                              {{--x-on:submit="$dispatch('update-ckeditor-values')"--}}>
                            <nav class="nav nav-tabs">
                                @foreach(tab_langs() as $lang)
                                    <button class="nav-link {{ $lang->status == 'default' ? 'active' : '' }}"
                                            type="button"
                                            data-bs-toggle="tab"
                                            data-bs-target="#lang-{{ $lang->lang }}">
                                        {{ strtoupper($lang->lang) }}
                                    </button>
                                @endforeach
                            </nav>

                            <div class="tab-content p-3 border border-top-0">
                                @foreach(tab_langs() as $lang)
                                    @php
                                        $suffix = $lang->status == 'default' ? '' : '_' . $lang->lang;
                                        $dir = $lang->align;
                                        $field = "data.company_description{$suffix}";
                                        $uniqueKey = "company_description{$suffix}";
                                    @endphp
                                    <div class="tab-pane fade {{ $lang->status == 'default' ? 'show active' : '' }}"
                                         id="lang-{{ $lang->lang }}"
                                         style="direction: {{ $dir }}">
                                        <div class="mb-3">
                                            <label>
                                                {{ translateText('Company Name', lang_admin()) }}
                                                {!! $lang->status == 'default' ? "<span class='text-danger'>*</span>" : '' !!}
                                            </label>
                                            <input type="text"
                                                   wire:model.defer="data.company_name{{ $suffix }}"
                                                   class="form-control">
                                        </div>
                                        <div class="mb-3">
                                            <label>
                                                {{ translateText('Company CEO', lang_admin()) }}
                                            </label>
                                            <input type="text"
                                                   wire:model.defer="data.company_ceo{{ $suffix }}"
                                                   class="form-control">
                                        </div>
                                        <div class="mb-3">
                                            <label>
                                                {{ translateText('Company Introduction', lang_admin()) }}
                                                {!! $lang->status == 'default' ? "<span class='text-danger'>*</span>" : '' !!}
                                            </label>
                                            <textarea
                                                    wire:model.defer="data.company_introduction{{ $suffix }}"
                                                    class="form-control"></textarea>
                                        </div>
                                        <div class="mb-3">
                                            <livewire:components.editor
                                                    :value="$data['company_description' . $suffix] ?? ''"
                                                    field="company_description{{ $suffix }}"
                                                    :required="$lang->status == 'default'"
                                                    :label="translateText('Company Description', lang_admin())"
                                                    :uniqueKey="$uniqueKey"
                                                    :language="$lang->lang"
                                                    :contentsLangDirection="$dir"
                                                    :height="'300px'"
                                                    :toolbar="$tools"
                                                    wire:key="editor-{{ $uniqueKey }}" />
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                            <div class="row mt-3"
                                 x-on:livewire-upload-start="isUploading = true"
                                 x-on:livewire-upload-finish="isUploading = false"
                                 x-on:livewire-upload-error="isUploading = false"
                            >
                                <div class="col-md-6 mb-3">
                                    <livewire:components.tom-select
                                            :options="$countries"
                                            :value="$data['main_markets']"
                                            field="main_markets"
                                            :isMultiple="true"
                                            :immediateUpdate="false"
                                            :required="true"
                                            :label="translateText('Main Markets', lang_admin())"
                                            placeholder="{{ translateText('Select Main Markets', lang_admin()) }}"
                                            uniqueKey="main_markets"
                                            wire:key="tom-select-main_markets" />
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label>{{ translateText('Year Of Established', lang_admin()) }} <span
                                                class="text-danger">*</span></label>
                                    <input class="form-control digits" placeholder="2025" max="9999"
                                           wire:model.defer="data.year_of_established" type="number">
                                </div>

                                <div class="col-md-6 mb-3">
                                    <livewire:components.tom-select
                                            :options="$employeesRange"
                                            :value="$data['number_of_employees']"
                                            field="number_of_employees"
                                            :isMultiple="false"
                                            :immediateUpdate="false"
                                            :required="true"
                                            :label="translateText('Number Of Employees', lang_admin())"
                                            placeholder="{{ translateText('Select Number Of Employees', lang_admin()) }}"
                                            uniqueKey="number_of_employees"
                                            wire:key="tom-select-number_of_employees" />
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label>{{ translateText('Website', lang_admin()) }}</label>
                                    <input class="form-control" wire:model.defer="data.website" type="text">
                                </div>

                                <div class="col-md-6 mb-3">
                                    <livewire:components.tom-select
                                            :options="$currencies"
                                            :value="$data['accepted_currencies']"
                                            field="accepted_currencies"
                                            :isMultiple="true"
                                            :immediateUpdate="false"
                                            :required="true"
                                            :label="translateText('Accepted Currencies', lang_admin())"
                                            placeholder="{{ translateText('Select Accepted Currencies', lang_admin()) }}"
                                            uniqueKey="accepted_currencies"
                                            wire:key="tom-select-accepted_currencies" />
                                </div>

                                <div class="col-md-6 mb-3">
                                    <livewire:components.tom-select
                                            :options="$payments"
                                            :value="$data['payment_terms']"
                                            field="payment_terms"
                                            :isMultiple="true"
                                            :immediateUpdate="false"
                                            :required="true"
                                            :label="translateText('Payment Terms', lang_admin())"
                                            placeholder="{{ translateText('Select Payment Terms', lang_admin()) }}"
                                            uniqueKey="payment_terms"
                                            wire:key="tom-select-payment_terms" />
                                </div>

                                <div class="col-md-6 mb-3">
                                    <livewire:components.tom-select
                                            :options="$days"
                                            :value="$data['working_days']"
                                            field="working_days"
                                            :isMultiple="true"
                                            :immediateUpdate="false"
                                            :required="true"
                                            :label="translateText('Working Days', lang_admin())"
                                            placeholder="{{ translateText('Select Working Days', lang_admin()) }}"
                                            uniqueKey="working_days"
                                            wire:key="tom-select-working_days" />
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label>{{ translateText('Trademark', lang_admin()) }} <span class='text-danger'>*</span></label>
                                    <input class="form-control" wire:model.defer="data.trademark" type="text">
                                </div>


                                <div wire:ignore class="col-md-12 mb-3">
                                    <label>{{ translateText('OEM Services', lang_admin()) }}</label>
                                    <div class="form-check form-switch form-check-reverse" style="padding-left: 20px">
                                        <input wire:model.defer="data.oem_services"
                                               class="form-check-input badge-light-info ms-2"
                                               id="flexSwitchCheckReverse"
                                               type="checkbox" {{ $data['oem_services'] == 'yes' ? 'checked' : '' }}>
                                        <label class="form-check-label" for="flexSwitchCheckReverse">
                                            {{ translateText('Do you offer OEM Services?', lang_admin()) }}
                                        </label>
                                    </div>
                                </div>

                                <div class="col-md-4 mb-3">
                                    <livewire:components.file-upload
                                            type="logo"
                                            :isMultiple="false"
                                            :label="translateText('Logo', lang_admin())"
                                            acceptedFormats="jpeg,jpg,png,webp,gif"
                                            maxSize="1024"
                                            dimensions="500x500"
                                            :modelId="$item->id"
                                            modelClass="\App\Models\GeneralInformation"
                                            :data="$data['logo']"
                                            uniqueKey="file-upload-logo"
                                            wire:key="file-upload-logo"
                                            uploadDisk="livewire_file"
                                            pathPrefix="assets/admin/uploads/company" />
                                </div>

                                <div class="col-md-4 mb-3">
                                    <livewire:components.file-upload
                                            type="banner1"
                                            :isMultiple="false"
                                            :label="translateText('Banner 1', lang_admin())"
                                            acceptedFormats="jpeg,jpg,png,webp,gif"
                                            maxSize="2048"
                                            dimensions="1440x400"
                                            :modelId="$item->id"
                                            modelClass="\App\Models\GeneralInformation"
                                            :required="false"
                                            :data="$data['banner1']"
                                            uniqueKey="file-upload-banner1"
                                            wire:key="file-upload-banner1"
                                            uploadDisk="livewire_file"
                                            pathPrefix="assets/admin/uploads/company" />
                                </div>

                                <div class="col-md-4 mb-3">
                                    <livewire:components.file-upload
                                            type="banner2"
                                            :isMultiple="false"
                                            :label="translateText('Banner 2', lang_admin())"
                                            acceptedFormats="jpeg,jpg,png,webp,gif"
                                            maxSize="2048"
                                            dimensions="1440x200"
                                            :modelId="$item->id"
                                            modelClass="\App\Models\GeneralInformation"
                                            :required="false"
                                            :data="$data['banner2']"
                                            uniqueKey="file-upload-banner2"
                                            wire:key="file-upload-banner2"
                                            uploadDisk="livewire_file"
                                            pathPrefix="assets/admin/uploads/company" />
                                </div>

                                <div class="col-md-6 mb-3">
                                    <livewire:components.file-upload
                                            type="brochure"
                                            :isMultiple="false"
                                            :label="translateText('Brochure', lang_admin())"
                                            acceptedFormats="pdf"
                                            maxSize="15360"
                                            :modelId="$item->id"
                                            modelClass="\App\Models\GeneralInformation"
                                            :required="false"
                                            :data="$data['brochure']"
                                            uniqueKey="file-upload-brochure"
                                            wire:key="file-upload-brochure"
                                            uploadDisk="livewire_file"
                                            pathPrefix="assets/admin/uploads/company" />
                                </div>

                                <div class="col-md-6 mb-3">
                                    <livewire:components.file-upload
                                            type="video"
                                            :isMultiple="false"
                                            :label="translateText('Company Video', lang_admin())"
                                            acceptedFormats="mp4"
                                            maxSize="10240"
                                            :modelId="$item->id"
                                            modelClass="\App\Models\GeneralInformation"
                                            :required="false"
                                            :data="$data['video']"
                                            uniqueKey="file-upload-video"
                                            wire:key="file-upload-video"
                                            uploadDisk="livewire_file"
                                            pathPrefix="assets/admin/uploads/company" />
                                </div>

                                <div class="col-md-12 mb-3">
                                    <livewire:components.file-upload
                                            type="gallery"
                                            :isMultiple="true"
                                            :label="translateText('Gallery', lang_admin())"
                                            acceptedFormats="jpeg,jpg,png,webp"
                                            maxSize="5120"
                                            dimensions="1000x1000"
                                            :modelId="$item->id"
                                            modelClass="\App\Models\GeneralInformation"
                                            :required="false"
                                            :data="$data['gallery']"
                                            uniqueKey="file-upload-gallery"
                                            wire:key="file-upload-gallery"
                                            uploadDisk="livewire_file"
                                            pathPrefix="assets/admin/uploads/company"
                                            :maxFiles="6" />
                                </div>
                            </div>

                            <button x-show="!isUploading" wire:loading.attr="disabled"
                                    type="submit" class="btn btn-primary mt-3">
                                {{ translateText('Submit', lang_admin()) }}
                            </button>
                            <span x-show="isUploading" class="text-info">
                                Uploading...
                                <i class="fas fa-spinner fa-spin me-2"></i>
                            </span>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
   {{-- <script>
        document.addEventListener('livewire:updated', function () {
            Object.keys(window.ckeditorInstances || {}).forEach(key => {
                const editor = window.ckeditorInstances[key];
                if (editor && editor.status === 'ready') {
                    editor.destroy(true);
                }
            });
            window.ckeditorInstances = {};
            window.ckeditorValues = window.ckeditorValues || {};
            document.querySelectorAll('textarea[id^="ckeditor_"]').forEach(textarea => {
                if (!window.ckeditorInstances[textarea.id]) {
                    const alpineInstance = Alpine.$data(textarea);
                    if (alpineInstance) {
                        alpineInstance.__lifecycle.xInit();
                    }
                }
            });
        });

        document.addEventListener('DOMContentLoaded', function () {
            document.querySelectorAll('.nav-tabs .nav-link').forEach(tab => {
                tab.addEventListener('shown.bs.tab', function () {
                    Object.values(window.ckeditorInstances || {}).forEach(editor => {
                        editor.updateElement();
                        editor.resize();
                    });
                });
            });
        });
    </script>--}}
@endpush