<?php

use App\Http\Controllers\Front\HomeController;
use App\Http\Controllers\Auth\RegisterController;
use App\Http\Controllers\Auth\LoginController;
use Illuminate\Support\Facades\Route;
use Illuminate\Http\Request;


// index
Route::get('/', [HomeController::class, 'index'])->name('index');
Route::get('/set/user/chat/{sender_id}/{receiver_id}', [HomeController::class, 'set_chat'])->name('set.user.chat');

// about us
Route::get('/about-us', [HomeController::class, 'about'])->name('about.us');

// terms
Route::get('/terms', [HomeController::class, 'terms'])->name('terms');
Route::get('/hyperlink', [HomeController::class, 'hyperlink'])->name('hyperlink');

// about us
Route::get('/faqs', [HomeController::class, 'faq'])->name('faq');

Route::get('/signupnew', [HomeController::class, 'signupnew'])->name('signupnew');
Route::get('/loginnew', [HomeController::class, 'loginnew'])->name('loginnew');

/*Route::post('/verify-email', [HomeController::class, 'verify_email'])->name('verify.email');
Route::post('/verify-code', [HomeController::class, 'verify_code'])->name('verify.code');*/

// contact us
Route::get('/contact-us', [HomeController::class, 'contact'])->name('contact.us');
Route::post('/contact-us/post', [HomeController::class, 'contact_post'])->name('contact.us.post');

//blogs
Route::get('/blogs', [HomeController::class, 'blog_list'])->name('blog.list');
Route::get('/blogs/{slug}', [HomeController::class, 'blog_show'])->name('blog.show');
Route::get('/tags/{slug}', [HomeController::class, 'tag_show'])->name('tag.show');


//products
Route::get('/products/{cat_slug?}', [HomeController::class, 'product_list'])->name('product.list');
Route::get('/products/{slug}/show', [HomeController::class, 'product_show'])->name('product.show');

//supplier
Route::get('/supplier/{id}/show', [HomeController::class, 'supplier_show'])->name('supplier.show');
//services
Route::get('/services', [HomeController::class, 'service_list'])->name('service.list');

// gallery image&video
Route::get('/gallery', [HomeController::class, 'gallery'])->name('gallery');
// search
Route::get('/search', [HomeController::class, 'search'])->name('search');
Route::get('/search/suggest', [HomeController::class, 'suggest'])->name('search.suggest');
//register
/*Route::get('/register/send/mail', [RegisterController::class, 'send_mail'])->name('register.send.mail');
Route::get('/register/verify/mail', [RegisterController::class, 'verify_mail'])->name('register.verify.mail');
Route::get('/register/clear/mail', [RegisterController::class, 'clear_mail'])->name('register.clear.mail');
Route::get('/register/end', [RegisterController::class, 'register_end'])->name('register.end');*/
Route::post('/verify-email', [RegisterController::class, 'send_mail'])->name('verify.email');
Route::post('/verify-code', [RegisterController::class, 'verify_mail'])->name('verify.code');
Route::post('/register-end', [RegisterController::class, 'register_end'])->name('register.end');
Route::post('/clear-mail', [RegisterController::class, 'clear_mail'])->name('clear.mail');
//login with Google account
Route::get('/auth/google', [LoginController::class,'redirectToGoogle'])->name('redirectToGoogle');
Route::get('/google/callback', [LoginController::class,'handleGoogleCallback'])->name('handleGoogleCallback');
//login with facebook account
//Route::get('/auth/facebook', [LoginController::class, 'redirectToFacebook'])->name('redirectToFacebook');
//Route::get('/facebook/callback', [LoginController::class, 'handleFacebookCallback'])->name('handleFacebookCallback');

// landing
Route::get('/import/export/services', [HomeController::class, 'import_export_services'])->name('import.export.services');
Route::get('location/{latitude}/{longitude}', function ($latitude,$longitude) {
    if(blank($latitude) || blank($longitude))
    {
        abort(404);
    }
    return view('front.location',compact('latitude','longitude'));
})->name('location');

Route::get('/sell/your/products', [HomeController::class, 'sell_your_products'])->name('sell.your.products');
Route::post('/sell/your/products/post', [HomeController::class, 'sell_your_products_post'])->name('sell.your.products.post');

Route::get('/sourcing/e/magazine', [HomeController::class, 'sourcing_magazine'])->name('sourcing.magazine');
// landing
Route::get('/{slug}', [HomeController::class, 'landing'])->name('landing');

Route::post('/feedback', [HomeController::class, 'feedback_store'])
    ->name('feedback.submit');

Route::post('/feedback_video', [HomeController::class, 'feedback_video_store'])
    ->name('feedback.video.submit');

/////////////////////////////////

