<div>
    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('dashboard.page-title', ['pageTitle' => $page_title,'page_title' => $page_title]);

$__html = app('livewire')->mount($__name, $__params, 'lw-3329334198-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <h5><?php echo e($title); ?></h5>
                        <a class="btn btn-danger" href="<?php echo e(route('company-faq.manage',auth()->id())); ?>">Back</a>
                    </div>
                    <div class="card-body">
                        <form wire:submit.prevent="save">
                            <div class="row mt-3">
                                <nav class="nav nav-tabs">
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = tab_langs(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <button class="nav-link <?php echo e($lang->status == 'default' ? 'active' : ''); ?>"
                                                type="button"
                                                data-bs-toggle="tab"
                                                data-bs-target="#lang-<?php echo e($lang->lang); ?>">
                                            <?php echo e(strtoupper($lang->lang)); ?>

                                        </button>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                </nav>

                                <div class="tab-content p-3 border border-top-0">
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = tab_langs(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $suffix = $lang->status == 'default' ? '' : '_' . $lang->lang;
                                            $dir = $lang->align;
                                        ?>
                                        <div class="tab-pane fade <?php echo e($lang->status == 'default' ? 'show active' : ''); ?>"
                                             id="lang-<?php echo e($lang->lang); ?>" style="direction: <?php echo e($dir); ?>">
                                            <div wire:ignore class="col-md-12 mb-3" style="direction:ltr">
                                                <label><?php echo e(translateText('Status', lang_admin())); ?></label>
                                                <div class="form-check form-switch form-check-reverse"
                                                     style="padding-left: 20px">
                                                    <input wire:model="data.status<?php echo e($suffix); ?>"
                                                           class="form-check-input badge-light-info ms-2"
                                                           id="flexSwitchCheckReverse<?php echo e($suffix); ?>" type="checkbox" <?php echo e($data['status'.$suffix] == 'active' ? 'checked' : ''); ?>>
                                                    <label class="form-check-label"
                                                           for="flexSwitchCheckReverse<?php echo e($suffix); ?>">
                                                        <?php echo e(translateText('Will it be published?', lang_admin())); ?>

                                                    </label>
                                                </div>
                                            </div>
                                            <div class="mb-3">
                                                <label>
                                                    <?php echo e(translateText('Question', lang_admin())); ?>

                                                    <?php echo $lang->status == 'default' ? "<span class='text-danger'>*</span>" : ''; ?>

                                                </label>
                                                <textarea <?php echo e($lang->status == 'default' ? "required" : ''); ?>  type="text"
                                                          wire:model="data.question<?php echo e($suffix); ?>"
                                                          class="form-control"></textarea>
                                            </div>
                                            <div class="mb-3">
                                                <label>
                                                    <?php echo e(translateText('Answer', lang_admin())); ?>

                                                    <?php echo $lang->status == 'default' ? "<span class='text-danger'>*</span>" : ''; ?>

                                                </label>
                                                <textarea <?php echo e($lang->status == 'default' ? "required" : ''); ?>  type="text"
                                                          wire:model="data.answer<?php echo e($suffix); ?>"
                                                          class="form-control"></textarea>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>
                            <button wire:loading.attr="disabled" type="submit" class="btn btn-primary mt-3">
                                <?php echo e(translateText('Submit', lang_admin())); ?>

                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div><?php /**PATH /home/nexpo/public_html/new/source/resources/views/livewire/dashboard/company/company-faq/edit.blade.php ENDPATH**/ ?>