<?php $__env->startSection('content'); ?>
    <style>
        .box-sh
        {
            box-shadow: 0 0 2px 0 #666;
            border-radius: 10px;
            padding: 15px 15px;

        }
    </style>
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="w-100">
                        <?php echo e($title); ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product_category_create')): ?>
                            <a href="<?php echo e(route('admin.product-category.create')); ?>" class="btn btn-primary float-left"><?php echo e(translateText('افزودن',lang_admin())); ?></a>
                        <?php endif; ?>
                    </h4>
                </div>

                <div class="card-body">














                    <div class="table-responsive">
                        <table class="table  table-vcenter text-wrap table-bordered border-bottom" id="tbl_1">
                            <thead>
                            <tr>
                                <th class="border-bottom-0">#</th>
                                <th class="border-bottom-0"><?php echo e(translateText('عنوان/نام محصول',lang_admin())); ?></th>
                                <th class="border-bottom-0"><?php echo e(translateText('تصویر',lang_admin())); ?></th>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product_category_sort')): ?>
                                    <th class="border-bottom-0"><?php echo e(translateText('Sort',lang_admin())); ?></th>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['product_category_edit','product_category_delete'])): ?>
                                    <th class="border-bottom-0"><?php echo e(translateText('عملیات',lang_admin())); ?></th>
                                <?php endif; ?>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td dir="ltr"><?php echo e($key+1 < 10 ? "0".$key+1 : $key+1); ?></td>
                                    <td><?php echo e($item->title); ?></td>
                                    <td>
                                        <?php if($item->photo && is_file($item->photo->path)): ?>
                                            <img src="<?php echo e(url($item->photo->path)); ?>" height="100px">
                                        <?php else: ?>
                                            <?php echo e(translateText('ثبت نشده',lang_admin())); ?>

                                        <?php endif; ?>
                                    </td>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product_category_sort')): ?>
                                        <td>
                                            <?php echo Form::open(['method' => 'POST', 'route' => ['admin.product-category.sort', $item->id] ]); ?>

                                            <input type="number" name="sort" class="form-control w-60px"
                                                   value="<?php echo e($item->sort); ?>" onchange="return this.form.submit()">
                                            <?php echo Form::close(); ?>

                                        </td>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['product_category_edit','product_category_delete'])): ?>
                                        <td>
                                            <div class="d-flex">
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product_category_edit')): ?>
                                                    <a href="<?php echo e(route('admin.product-category.edit',$item->id)); ?>"
                                                       class="action-btns1">
                                                        <i class="feather feather-edit-2  text-success"
                                                           data-toggle="tooltip" data-placement="top"
                                                           title="<?php echo e(translateText('ویرایش',lang_admin())); ?>"></i>
                                                    </a>
                                                <?php endif; ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product_category_delete')): ?>
                                                    <?php echo Form::open(['method' => 'DELETE', 'route' => ['admin.product-category.destroy', $item->id] ]); ?>

                                                    <button class="action-btns1" data-toggle="tooltip"
                                                            data-placement="top" title="<?php echo e(translateText('حذف',lang_admin())); ?>"
                                                            onclick="return confirm('<?php echo e(translateText('برای حذف مطمئن هستید؟',lang_admin())); ?>')">
                                                        <i class="feather feather-trash-2 text-danger"></i>
                                                    </button>
                                                    <?php echo Form::close(); ?>

                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    <?php endif; ?>
                                </tr>
                                <?php if(count($item->children)): ?>
                                    <?php echo $__env->make('admin.product.category.each', [
                                        'items' => $item->children,
                                        'level' => 1,
                                        'parent_number' => $key+1 < 10 ? "0".$key+1 : $key+1
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php endif; ?>
                                
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app',['tbl'=>true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nexpo/public_html/new/source/resources/views/admin/product/category/index.blade.php ENDPATH**/ ?>