<div x-data="{
    showModal : false,
    categoryTab: 1,
    categories: <?php echo \Illuminate\Support\Js::from($this->categories)->toHtml() ?>,
    selectedLevel1: null,
    selectedLevel2: null,
    selectedLevel3: null,
    searchLevel1: '',
    searchLevel2: '',
    searchLevel3: '',
    searchGeneral: '',
    generalSearchResults: [],
    filteredLevel2: [],
    filteredLevel3: [],
    init() {
        Livewire.on('open-category-selector', (event) => {
            this.showModal = true;
        });
        this.updateFilteredCategories();
    },
    updateFilteredCategories() {
        this.filteredLevel2 = this.selectedLevel1
            ? this.categories.find(cat => cat.id == this.selectedLevel1)?.children || []
            : [];
        this.filteredLevel3 = this.selectedLevel2
            ? this.filteredLevel2.find(cat => cat.id == this.selectedLevel2)?.children || []
            : [];
    },
    searchCategories(level) {
        if (level === 'level1') {
            return this.categories.filter(cat =>
                cat.title.toLowerCase().includes(this.searchLevel1.toLowerCase())
            );
        } else if (level === 'level2') {
            return this.filteredLevel2.filter(cat =>
                cat.title.toLowerCase().includes(this.searchLevel2.toLowerCase())
            );
        } else if (level === 'level3') {
            return this.filteredLevel3.filter(cat =>
                cat.title.toLowerCase().includes(this.searchLevel3.toLowerCase())
            );
        }
    },
    generalSearch() {
        if (this.searchGeneral) {
            const allCategories = [];
            this.categories.forEach(cat => {
                allCategories.push(cat);
                cat.children.forEach(child => {
                    allCategories.push(child);
                    child.children.forEach(grandchild => {
                        allCategories.push(grandchild);
                    });
                });
            });
            this.generalSearchResults = allCategories.filter(cat =>
                cat.title.toLowerCase().includes(this.searchGeneral.toLowerCase())
            );
        } else {
            this.generalSearchResults = [];
        }
    },
    selectFromGeneralSearch(category) {
        this.selectedLevel1 = null;
        this.selectedLevel2 = null;
        this.selectedLevel3 = null;
        if (!category.parent_id) {
            this.selectedLevel1 = category.id;
        } else {
            const level2Parent = this.categories.find(cat => cat.children.some(child => child.id === category.id));
            if (level2Parent) {
                this.selectedLevel1 = level2Parent.id;
                this.selectedLevel2 = category.id;
            } else {
                const level3Parent = this.categories.flatMap(cat => cat.children).find(cat => cat.children.some(child => child.id === category.id));
                if (level3Parent) {
                    this.selectedLevel1 = this.categories.find(cat => cat.children.some(child => child.id === level3Parent.id)).id;
                    this.selectedLevel2 = level3Parent.id;
                    this.selectedLevel3 = category.id;
                }
            }
        }
        this.updateFilteredCategories();
        this.searchGeneral = '';
        this.generalSearchResults = [];
        if (this.selectedLevel3) {
            window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('category_id', this.selectedLevel3);
        }
    },
    saveCategories() {
        if (this.selectedLevel3) {
            const selectedCategory = this.filteredLevel3.find(cat => cat.id == this.selectedLevel3);
            if (selectedCategory) {
                window.Livewire.find('<?php echo e($_instance->getId()); ?>').dispatch('set-category-id', {
                    category_id: this.selectedLevel3,
                    category_title: selectedCategory.title
                });
            }
        }
    }
}">

    <div
            class="modal fade"
            :class="{ 'show d-block': showModal }"
            x-show="showModal"
            @click.away="showModal = false"
            role="dialog"
            aria-modal="true"
    >

        <div class="modal-dialog mt-5 my-style-modal">
            <div class="btn-group btn-group-sm mb-2 d-table" role="group" style=";pointer-events: auto;">
                <button :class="{'btn-primary text-white': categoryTab == 1}" @click="categoryTab = 1"
                        class="btn btn-outline-primary bg-light"><?php echo e(translateText('All Categories', lang_admin())); ?></button>
                <button :class="{'btn-primary text-white': categoryTab == 2}" @click="categoryTab = 2"
                        class="btn btn-outline-primary bg-light"><?php echo e(translateText('Your Frequently Used Categories', lang_admin())); ?></button>
            </div>
            <div x-show="categoryTab == 1" class="modal-content h-75">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(translateText('Selected Category', lang_admin())); ?></h5>
                    <button type="button" class="btn-close" @click="showModal = false"
                            aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label"><?php echo e(translateText('Search All Categories', lang_admin())); ?></label>
                        <input
                                type="text"
                                class="form-control"
                                x-model="searchGeneral"
                                @input="generalSearch()"
                                placeholder="Search all categories"
                        >
                    </div>
                    <div class="row h-75">
                        <div class="col-4">
                            <div class="mb-3 h-75">
                                <label class="form-label" for="Level1">
                                    <?php echo e(translateText('Main Categories', lang_admin())); ?>

                                    <span class="text-danger">*</span>
                                </label>
                                <input
                                        type="text"
                                        class="form-control mb-2"
                                        x-model.debounce.500="searchLevel1"
                                        placeholder="Search Main Categories"
                                >
                                <select
                                        class="form-select input-air-primary digits custom-scrollbar h-100"
                                        id="Level1"
                                        x-model="selectedLevel1"
                                        @change="updateFilteredCategories(); selectedLevel2 = null; selectedLevel3 = null;"
                                        multiple
                                >
                                    <template x-for="category in searchCategories('level1')" :key="category.id">
                                        <option :value="category.id" x-text="category.title"></option>
                                    </template>
                                </select>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="mb-3 h-75">
                                <label class="form-label" for="Level2">
                                    <?php echo e(translateText('Sub Categories - Level 1', lang_admin())); ?>

                                    <span class="text-danger">*</span>
                                </label>
                                <input
                                        type="text"
                                        class="form-control mb-2"
                                        x-model.debounce.500="searchLevel2"
                                        placeholder="Search Sub Categories - Level 1"
                                >
                                <select
                                        class="form-select input-air-primary digits custom-scrollbar h-100"
                                        id="Level2"
                                        x-model="selectedLevel2"
                                        @change="updateFilteredCategories(); selectedLevel3 = null;"
                                        multiple
                                >
                                    <template x-for="category in searchCategories('level2')" :key="category.id">
                                        <option :value="category.id" x-text="category.title"></option>
                                    </template>
                                </select>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="mb-3 h-75">
                                <label class="form-label" for="Level3">
                                    <?php echo e(translateText('Sub Categories - Level 2', lang_admin())); ?>

                                    <span class="text-danger">*</span>
                                </label>
                                <input
                                        type="text"
                                        class="form-control mb-2"
                                        x-model.debounce.500="searchLevel3"
                                        placeholder="Search Sub Categories - Level 2"
                                >
                                <select
                                        class="form-select input-air-primary digits custom-scrollbar h-100"
                                        id="Level3"
                                        x-model="selectedLevel3"
                                        @change="if (selectedLevel3) { window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('category_id', selectedLevel3); }"
                                        multiple
                                >
                                    <template x-for="category in searchCategories('level3')" :key="category.id">
                                        <option :value="category.id" x-text="category.title"></option>
                                    </template>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" @click="showModal = false">
                        <?php echo e(translateText('Close', lang_admin())); ?>

                    </button>
                    <button type="submit" class="btn btn-primary" @click="saveCategories(), setTimeout(() => { showModal = false }, 500)"
                            :disabled="!selectedLevel3">
                        <?php echo e(translateText('Save', lang_admin())); ?>

                    </button>
                </div>
            </div>
            <div x-show="categoryTab == 2" class="modal-content h-75">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(translateText('Selected Category', lang_admin())); ?></h5>
                    <button type="button" class="btn-close" @click="showModal = false"
                            aria-label="Close"></button>
                </div>
                <div class="modal-body">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" @click="showModal = false">
                        <?php echo e(translateText('Close', lang_admin())); ?>

                    </button>
                    <button type="submit" class="btn btn-primary" @click="saveCategories(), setTimeout(() => { showModal = false }, 500)"
                            :disabled="!selectedLevel3">
                        <?php echo e(translateText('Save', lang_admin())); ?>

                    </button>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-backdrop fade" :class="{ 'show': showModal }" x-show="showModal"></div>

    <div
            class="modal fade"
            :class="{ 'show d-block': searchGeneral.length > 0 }"
            x-show="searchGeneral.length > 0"
            role="dialog"
            aria-modal="true"
    >
        <div class="modal-dialog mt-5">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(translateText('Search Categories', lang_admin())); ?></h5>
                    <button type="button" class="btn-close" @click="searchGeneral = ''; generalSearchResults = []"
                            aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <ul class="list-group">
                        <template x-for="category in generalSearchResults" :key="category.id">
                            <li
                                    class="list-group-item pointer"
                                    @click="selectFromGeneralSearch(category)"
                                    x-text="category.title"
                            ></li>
                        </template>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/nexpo/public_html/new/source/resources/views/livewire/dashboard/items-and-services/product/category-selector.blade.php ENDPATH**/ ?>