<div style="<?php echo e($style != null ? $style['at'] : ''); ?>:<?php echo e($style != null ? $style['val'] : ''); ?>" wire:ignore x-data="{ value: <?php echo \Illuminate\Support\Js::from($value ?? ($isMultiple ? [] : null))->toHtml() ?> }" x-init="
    const select = new TomSelect($refs.select, {
        plugins: <?php echo e($isMultiple ? "['remove_button']" : '[]'); ?>,
        valueField: 'value',
        labelField: 'text',
        searchField: 'text',
        options: <?php echo \Illuminate\Support\Js::from(array_map(function($value, $text) {
            return ['value' => $value, 'text' => $text];
        }, array_keys($options), array_values($options)))->toHtml() ?>,
        items: value,
        <?php if($keyword): ?>
        create: true,
        <?php endif; ?>
        maxItems: <?php echo e($isMultiple ? 'null' : '1'); ?>,
        placeholder: <?php echo \Illuminate\Support\Js::from($placeholder . ($isMultiple ? ' (multiple choice)' : ''))->toHtml() ?>,
        onChange: (val) => {
            value = val;
            console.log('TomSelect onChange:', { field: '<?php echo e($field); ?>', value: val });
            <?php if($immediateUpdate): ?>
                window.Livewire.find('<?php echo e($_instance->getId()); ?>').dispatch('tomselect-updated', { field: '<?php echo e($field); ?>', value: val });
            <?php else: ?>
                window.tomSelectValues = window.tomSelectValues || {};
                window.tomSelectValues['<?php echo e($uniqueKey); ?>'] = val;
                console.log('TomSelect stored value:', { key: '<?php echo e($uniqueKey); ?>', value: window.tomSelectValues['<?php echo e($uniqueKey); ?>'] });
            <?php endif; ?>
        },
        onItemRemove: (val) => {
            console.log('TomSelect onItemRemove:', { field: '<?php echo e($field); ?>', removed: val });
            <?php if($isMultiple && !$immediateUpdate): ?>
                window.tomSelectValues = window.tomSelectValues || {};
                window.tomSelectValues['<?php echo e($uniqueKey); ?>'] = select.getValue();
                console.log('TomSelect updated value after remove:', { key: '<?php echo e($uniqueKey); ?>', value: window.tomSelectValues['<?php echo e($uniqueKey); ?>'] });
            <?php endif; ?>
        },
        onBlur: () => {
            <?php if(!$immediateUpdate): ?>
                if (window.tomSelectValues && window.tomSelectValues['<?php echo e($uniqueKey); ?>'] !== undefined) {
                    console.log('TomSelect onBlur:', { field: '<?php echo e($field); ?>', value: window.tomSelectValues['<?php echo e($uniqueKey); ?>'] });
                    window.Livewire.find('<?php echo e($_instance->getId()); ?>').dispatch('tomselect-updated', { field: '<?php echo e($field); ?>', value: window.tomSelectValues['<?php echo e($uniqueKey); ?>'] });
                }
            <?php endif; ?>
        }
    });

    window.tomSelectInstances = window.tomSelectInstances || {};
    window.tomSelectInstances['<?php echo e($uniqueKey); ?>'] = select;
">
    <!--[if BLOCK]><![endif]--><?php if($label): ?>
        <label class="form-label"><?php echo e($label); ?><?php echo $required ? " <span class='text-danger'>*</span>" : ''; ?></label>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    <select <?php echo e($required ? ' required ' : ''); ?> x-ref="select" <?php echo e($isMultiple ? 'multiple' : ''); ?> <?php echo e($disabled ? 'disabled' : ''); ?>></select>
</div>
<?php $__env->startPush('styles'); ?>
    <style>
        .ts-control .item .remove{
            opacity: 0;
            visibility: hidden;
            max-width: 0;
            overflow: hidden;
            padding-inline:0 !important;
        }
        .ts-control:has(input:focus) .item .remove {
            opacity: 1;
            visibility: visible;
            max-width: 100px;
            padding-inline:6px !important;
        }
        .ts-control {
            position: relative;
            padding-right: 30px;
            height: 37.6px;
        }
        .ts-control::after {
            content: '';
            position: absolute;
            right: 10px;
            top: 50%;
            transform: translateY(-50%);
            border: 6px solid transparent;
            border-top-color: #333;
            pointer-events: none;
        }
    </style>
<?php $__env->stopPush(); ?><?php /**PATH /home/nexpo/public_html/new/source/resources/views/livewire/components/tom-select.blade.php ENDPATH**/ ?>