<?php $__env->startPush('styles'); ?>
    <script defer src="<?php echo e(url('assets/front/new/js/alpine.min.js')); ?>"></script>

    <!-- TomSelect -->
    <link href="<?php echo e(url('assets/front/new/css/tom_select.css')); ?>" rel="stylesheet">
    <script src="<?php echo e(url('assets/front/new/js/tom_select.min.js')); ?>"></script>
    <style>
        .ts-control,
        .ts-wrapper.single.input-active .ts-control {
            background: #ffffff;
            transition: background-color 0.5s ease, border 0.5s ease;
        }

        .ts-control:hover,
        .ts-wrapper.single.input-active:hover .ts-control {
            background-color: white;
            border: black solid 1px;
        }

        .ts-wrapper.multi .ts-control>div {
            background-color: var(--grayBack);
        }

        .ts-dropdown,
        .ts-control,
        .ts-control input {
            font-size: 14px;
        }

        .form-check-input:hover {
            border-color: rgb(229, 69, 68);
            transition: 0.5s;
            cursor: pointer;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        const Toast = Swal.mixin({
            toast: true,
            position: "top-end",
            showConfirmButton: false,
            timer: 3000,
            timerProgressBar: true,
            didOpen: (toast) => {
                toast.onmouseenter = Swal.stopTimer;
                toast.onmouseleave = Swal.resumeTimer;
            }
        });
        document.addEventListener('livewire:init', () => {
            Livewire.on('alert', (value) => {
                Toast.fire({
                    icon: value['icon'],
                    title: value['title']
                });
            });

            Livewire.on('resetPage', () => {
                location.reload();
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<div>
    <a href="<?php echo e($banner->link); ?>" class="banner-box h-auto">
        <img src="<?php echo e(url($banner->photo->path)); ?>" alt="<?php echo e(photo_alt($banner, 'photo', 'banner')); ?>">
    </a>
    <div class="container-xxl">
        <div class="breadcrumb">
            <ul class="breadcrumb-links">
                <li>
                    <a href="<?php echo e(route('front.index')); ?>"><?php echo e(read_lang_word('home')); ?></a>
                </li>
                <li>
                    <span class="end-item"><?php echo e(read_lang_word('title-rfq')); ?></span>
                </li>
            </ul>
        </div>
    </div>
    <div class="bg-white py-4">
        <div class="container-xxl" style="max-width: 70vw">
            <div class="section-heading ps-2">
                <div class="section-heading-right-side">
                    <div class="section-heading-title-box start">
                        <h6 class="section-heading-title"><?php echo e(read_lang_word('tell-us-what-you-need-find-the-best-matching-suppliers')); ?></h6>
                        <p><?php echo e(read_lang_word('more-details-better-matches-faster-responses')); ?></p>
                    </div>
                </div>
            </div>
            <div class="rfq-form">
                <form enctype="multipart/form-data" wire:submit.prevent="submit" class="row g-2" onkeydown="if(event.key === 'Enter') event.preventDefault();">
                    <?php echo csrf_field(); ?>
                    <div class="col-12" wire:ignore x-data="{
                        keywordOptions: <?php echo \Illuminate\Support\Js::from($initialKeywords)->toHtml() ?>,
                        init() {
                            new TomSelect(this.$refs.keywordsInput, {
                                plugins: ['remove_button'],
                                create: true,
                                persist: false,
                                maxItems: 10,
                                delimiter: ',',
                                valueField: 'value',
                                labelField: 'text',
                                searchField: 'text',
                                placeholder: '<?php echo e(read_lang_word('enter-a-keyword')); ?> (eg. Toy, Car, ...)',
                                options: this.keywordOptions.map(item => ({ value: item, text: item })),
                                onChange: (value) => {
                                    window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('product_name', value.join(' , '));
                                },
                                onInitialize: function() {
                                    this.setValue(window.Livewire.find('<?php echo e($_instance->getId()); ?>').product_name.split(' , '));
                                }
                            });
                        }
                    }">
                        <label for="productName" class="form-label fw-bold "><?php echo e(read_lang_word('product-name')); ?>: <span class="text-danger">*</span></label>
                        <select x-ref="keywordsInput" multiple></select>
                    </div>
                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['product_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger small"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                    <div class="col-12 col-xl-12">
                        <label for="productCategory" class="form-label fw-bold"><?php echo e(read_lang_word('product-category')); ?>

                            :</label>
                        <div class="select-container <?php $__errorArgs = ['product_category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>border-danger border-1 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                            <select id="productCategory" wire:model.defer="product_category" class="form-select " onchange="toggleCustomInput()">
                                <option value="" selected=""><?php echo e(read_lang_word('select-category')); ?></option>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $this->grandchildren; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($cat->id); ?>"><?php echo e(read_lang($cat, 'title')); ?></option>
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $cat->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($child->id); ?>">└─ <?php echo e(read_lang($child, 'title')); ?></option>
                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $child->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $grandchild): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($grandchild->id); ?>">
                                                ─└─ <?php echo e(read_lang($grandchild, 'title')); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                <option value="other"><?php echo e(read_lang_word('other')); ?></option>
                            </select>
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['product_category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="text-danger small"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                        <input type="text" id="customCategory" class="form-control mt-2 <?php $__errorArgs = ['product_category_custom'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" wire:model.defer="product_category_custom"
                            placeholder="<?php echo e(read_lang_word('dont-find-write-your-category')); ?>" style="display: none;">
                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['product_category_custom'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger small"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>


                    <div class="col-md-6 col-xl-6">
                        <label for="requiredQuantity" class="form-label fw-bold"><?php echo e(read_lang_word('required-quantity')); ?>:
                            <span class="text-danger">*</span></label>
                        <input type="number" class="form-control <?php $__errorArgs = ['required_quantity'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> " id="requiredQuantity" wire:model.defer="required_quantity" required>
                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['required_quantity'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger small"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>

                    <div class="col-md-6 col-xl-6">
                        <label for="selectUnit" class="form-label fw-bold"><?php echo e(read_lang_word('select-unit')); ?>: <span class="text-danger">*</span></label>
                        <div class="select-container">
                            <select id="selectUnit" wire:model.defer="select_unit" class="form-select" required>
                                <option value="" disabled="" selected=""><?php echo e(read_lang_word('unit')); ?></option>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $this->rfqForm; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <!--[if BLOCK]><![endif]--><?php if($unit->type == 'units'): ?>
                                        <option value="<?php echo e(read_lang($unit, 'title1')); ?>"><?php echo e(read_lang($unit, 'title1')); ?></option>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </select>
                        </div>
                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['select_unit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger small"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>

                    <div class="col-12">
                        <label for="productDetails" class="form-label fw-bold"><?php echo e(read_lang_word('product-details')); ?>:
                            <span class="text-danger">*</span></label>
                        <textarea class="form-control <?php $__errorArgs = ['product_category_custom'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="productDetails" wire:model.defer="product_details" rows="4" required placeholder="<?php echo e(read_lang_word('detailed-description-of-the-product')); ?>"></textarea>
                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['product_details'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger small"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>

                    <div class="col-12" x-data="{
                            fileInputs: [],
                            fileNames: {},
                            nextId: 1,
                            addFileInput() {
                                const id = this.nextId++;
                                this.fileInputs.push(id);
                                this.fileNames[id] = '<?php echo e(read_lang_word('no-file-chosen')); ?>';
                                return id;
                            },
                            removeFileInput(id) {
                                const index = this.fileInputs.indexOf(id);
                                if (index !== -1) {
                                    this.fileInputs.splice(index, 1);
                                    delete this.fileNames[id];
                                    const livewireIndex = this.$wire.product_images.findIndex((_, i) => i === index);
                                    if (livewireIndex !== -1) {
                                        this.$wire.product_images.splice(livewireIndex, 1);
                                    }
                                }
                            }
                        }">
                        <label for="productImages" class="form-label fw-bold"><?php echo e(read_lang_word('product-images-files')); ?>:
                            <span class="text-danger">*</span></label>
                        <div class="d-flex align-items-center mb-2">
                            <div class="custom-file-upload flex-grow-1 me-2">
                                <input type="file" id="product_images_initial" class="<?php $__errorArgs = ['product_images'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" wire:model="product_images"
                                       x-on:change="fileNames['initial'] = $event.target.files[0]?.name || '<?php echo e(read_lang_word('no-file-chosen')); ?>'">
                                <label for="product_images_initial"><?php echo e(read_lang_word('product-images-files')); ?></label>
                                <span class="file-name" x-text="fileNames['initial']"></span>
                            </div>
                        </div>

                        <template x-for="(id, index) in fileInputs" :key="id">
                            <div class="d-flex align-items-center mb-2">
                                <div class="custom-file-upload flex-grow-1 me-2">
                                    <input type="file" :id="'product_images_' + id" class="<?php $__errorArgs = ['product_images'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                           wire:model.defer="product_images"
                                           x-on:change="fileNames[id] = $event.target.files[0]?.name || '<?php echo e(read_lang_word('no-file-chosen')); ?>'">
                                    <label :for="'product_images_' + id"><?php echo e(read_lang_word('product-images-files')); ?></label>
                                    <span class="file-name" x-text="fileNames[id]"></span>
                                </div>
                                <button type="button" class="btn btn-sm btn-danger" x-on:click="removeFileInput(id)">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </div>
                        </template>

                        <div class="d-flex justify-content-between">
                            <label class="form-label">No of Files: 5 - Max Size: 5 MB - Format: .jpg, .png, .docx, .xlsx, .pdf, rar, zip</label>
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['product_images.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger small"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            <button type="button" class="btn btn-sm btn-primary mt-2" x-on:click="addFileInput()" x-show="fileInputs.length < 4">
                                <i class="fa fa-plus"></i>
                            </button>
                        </div>
                    </div>

                    <div class="col-12">
                        <label class="form-label fw-bold"><?php echo e(read_lang_word('trade-terms')); ?>: <span class="text-danger">*</span></label>
                        <div>
                            <div class="row g-2">
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $this->rfqForm; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tradeTerm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <!--[if BLOCK]><![endif]--><?php if($tradeTerm->type == 'trade_terms'): ?>
                                        <div class="col-xl-1 col-lg-2 col-md-3 col-sm-4 col-6">
                                            <div class="form-check-inline" data-bs-toggle="tooltip" data-bs-title="<?php echo e(read_lang($tradeTerm, 'title2')); ?>">
                                                <input class="form-check-input" type="checkbox" value="<?php echo e($tradeTerm->title1); ?>" id="trade<?php echo e($tradeTerm->title1); ?>" wire:model.defer="trade_terms">
                                                <label class="form-check-label" for="trade<?php echo e($tradeTerm->title1); ?>"><?php echo e($tradeTerm->title1); ?></label>
                                            </div>
                                        </div>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['trade_terms'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger small"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>

                    <div class="col-md-6 col-xl-4">
                        <label for="budgetLimit" class="form-label fw-bold"><?php echo e(read_lang_word('budget-limit')); ?>: <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <div class="select-container">
                                <select id="" wire:model.defer="budget_limit" required>
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $this->rfqForm; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $budget_limit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <!--[if BLOCK]><![endif]--><?php if($budget_limit->type == 'budget_limit'): ?>
                                            <option value="<?php echo e(read_lang($budget_limit, 'title1')); ?>">
                                                <?php echo e(read_lang($budget_limit, 'title1')); ?>

                                            </option>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                </select>
                            </div>
                            <span class="input-group-text">USD</span>
                        </div>
                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['budget_limit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger small"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>

                    <div class="col-md-6 col-xl-4">
                        <label for="expectedUnitPrice" class="form-label fw-bold"><?php echo e(read_lang_word('expected-unit-price')); ?>

                            :</label>
                        <div class="input-group">
                            <input type="number" class="form-control" id="expectedUnitPrice" wire:model.defer="expected_unit_price">
                            <div class="input-group-select select-container">
                                <select id="expected_unit_price_currency" wire:model.defer="expected_unit_price_currency" required>
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $this->rfqForm; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expected_unit_price): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <!--[if BLOCK]><![endif]--><?php if($expected_unit_price->type == 'expected_unit_price'): ?>
                                            <option value="<?php echo e(read_lang($expected_unit_price, 'title1')); ?>">
                                                <?php echo e(read_lang($expected_unit_price, 'title1')); ?>

                                            </option>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                </select>
                            </div>
                        </div>
                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['expected_unit_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger small"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['expected_unit_price_currency'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger small"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>

                    <div class="col-12 col-xl-4">
                        <label for="buyingFrequency" class="form-label fw-bold"><?php echo e(read_lang_word('buying-frequency')); ?>

                            :</label>
                        <div class="select-container">
                            <select id="buyingFrequency" wire:model.defer="buying_frequency" class="form-select">
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $this->rfqForm; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bying_frequency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <!--[if BLOCK]><![endif]--><?php if($bying_frequency->type == 'bying_frequency'): ?>
                                        <option value="<?php echo e(read_lang($bying_frequency, 'title1')); ?>">
                                            <?php echo e(read_lang($bying_frequency, 'title1')); ?>

                                        </option>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </select>
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['buying_frequency'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="text-danger small"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    </div>


                    <div class="col-12">
                        <label class="form-label fw-bold">Shipping Method: <span class="text-danger">*</span></label>
                        <div class="row g-2">
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $this->rfqForm; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shipping_method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <!--[if BLOCK]><![endif]--><?php if($shipping_method->type == 'shipping_method'): ?>
                                    <div class="col-lg-3 col-sm-6">
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="checkbox" id="ship<?php echo e(str_replace(' ', '_', $shipping_method->title1)); ?>" value="<?php echo e($shipping_method->title1); ?>" wire:model.defer="shipping_method">
                                            <label class="form-check-label" for="ship<?php echo e(str_replace(' ', '_', $shipping_method->title1)); ?>"><?php echo e(read_lang($shipping_method, 'title1')); ?></label>
                                        </div>
                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['shipping_method'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger small"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                    <div class="col-md-6">
                        <label for="destination" class="form-label fw-bold"><?php echo e(read_lang_word('destination')); ?>: <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="destination" wire:model.defer="destination" required>
                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['destination'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger small"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                    <div class="col-md-6">
                        <label for="paymentTerms" class="form-label fw-bold"><?php echo e(read_lang_word('payment-terms')); ?>:
                            <span class="text-danger">*</span></label>
                        <div class="select-container">
                            <select id="paymentTerms" wire:model.defer="payment_terms" class="form-select" required>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $this->rfqForm; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment_terms): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <!--[if BLOCK]><![endif]--><?php if($payment_terms->type == 'payment_terms'): ?>
                                        <option value="<?php echo e($payment_terms->title1); ?>">
                                            <?php echo e(read_lang($payment_terms, 'title1')); ?>

                                        </option>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </select>
                        </div>
                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['payment_terms'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger small"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                    <div class="col-md-6">
                        <label for="deliveryTime" class="form-label fw-bold"><?php echo e(read_lang_word('delivery-time')); ?>

                            :</label>
                        <div class="input-group">
                            <input type="number" class="form-control" id="deliveryTime" wire:model.defer="delivery_time" placeholder="eg: 10">
                            <span class="input-group-text"><?php echo e(read_lang_word('days')); ?></span>
                        </div>
                        <div class="form-text" style="font-size: 0.8em;">
                            <?php echo e(read_lang_word('delivery-time-starts-after-supplier-receives-the-initial-payments')); ?>

                        </div>
                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['delivery_time'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger small"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                    <div class="col-md-6">
                        <label for="rfqExpiry" class="form-label fw-bold"><?php echo e(read_lang_word('rfq-expiry')); ?>:</label>
                        <div class="input-group">
                            <input type="number" class="form-control" id="rfqExpiry" wire:model.defer="rfq_expiry" placeholder="eg: 5">
                            <div class="input-group-select select-container">
                                <select id="" wire:model.defer="rfq_expiry_type" required>
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $this->rfqForm; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rfq_expiry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <!--[if BLOCK]><![endif]--><?php if($rfq_expiry->type == 'rfq_expiry'): ?>
                                            <option value="<?php echo e($rfq_expiry->title1); ?>">
                                                <?php echo e(read_lang($rfq_expiry, 'title1')); ?>

                                            </option>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                </select>
                            </div>
                        </div>
                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['rfq_expiry'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger small"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['rfq_expiry_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger small"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>

                    <div class="col-12">
                        <!--[if BLOCK]><![endif]--><?php if(auth()->user()): ?>
                            <button type="submit" class="submit-btn">
                                SUBMIT YOUR REQUEST
                            </button>
                        <?php else: ?>
                            <a href="<?php echo e(route('front.loginnew')); ?>" class="btn btn-warning">
                                <?php echo e(read_lang_word('product-alert')); ?>

                            </a>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                    </div>
                </form>
            </div>
        </div>
    </div>


</div>
<?php /**PATH /home/nexpo/public_html/new/source/resources/views/livewire/front/rfq/rfq-form-user.blade.php ENDPATH**/ ?>