
<?php $__env->startSection('styles'); ?>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0/dist/fancybox/fancybox.css"/>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('body'); ?>
    <!-- Hero Section -->
    <div class="container-xxl mt-3">
        <div class="row g-3 align-items-stretch">
            <div class="col-xl-3 col-lg-4 col-sm-6 order-sm-1 order-2">
                <div class="categories-widget">
                    <h3 class="widget-title">
                        <i class="fa-solid fa-list"></i>
                        <span><?php echo e(read_lang_word('slider-title-1')); ?></span>
                    </h3>
                    <ul class="category-list">
                        <?php $__currentLoopData = $cats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <a href="<?php echo e(route('front.product.list', $cat->slug)); ?>">
                                    <span><?php echo e(read_lang($cat, 'title')); ?></span>

                                    <?php if($cat->children->count()): ?>
                                        <i class="fa-regular fa-chevron-right"></i>
                                    <?php endif; ?>
                                </a>
                                <?php if($cat->children->count()): ?>
                                    <div class="category-list-dropdown">
                                        <div class="category-list-dropdown-content four-column">
                                            <?php $__currentLoopData = $cat->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <ul class="sub-category-section">
                                                    <li>
                                                        <span class="sub-category-title"><?php echo e(read_lang($child, 'title')); ?></span>
                                                    </li>
                                                    <?php $__currentLoopData = $child->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $grandchild): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li>
                                                            <a class="sub-category-item"
                                                               href="<?php echo e(route('front.product.list', $grandchild->slug)); ?>">
                                                                <?php echo e(read_lang($grandchild, 'title')); ?>

                                                            </a>
                                                        </li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                        <?php if($cat->products_active->take(7)->count() > 0): ?>
                                            <div class="carousel-section">
                                                <div class="swiper header-product-slider">
                                                    <div class="swiper-wrapper">
                                                        <?php $__currentLoopData = $cat->products_active->take(7); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <div class="swiper-slide">
                                                                <a href="<?php echo e(route('front.product.show', $product->slug)); ?>"
                                                                   class="header-product-item">
                                                                    <img src="<?php echo e($product->photo && is_file($product->photo->path) ? url($product->photo->path) : url('assets/front/product_default.webp')); ?>"
                                                                         alt="<?php echo e(photo_alt($product, 'photo', read_lang($product, 'title'))); ?>">
                                                                    <span><?php echo e(read_lang($product, 'title')); ?></span>
                                                                </a>
                                                            </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </div>
                                                </div>
                                                <!-- Carousel Buttons -->
                                                <div class="swiper-button-next header-product-slider-next"></div>
                                                <div class="swiper-button-prev header-product-slider-prev"></div>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <li class="all-categories">
                            <a href="<?php echo e(route('list.categories')); ?>">
                                <?php echo e(read_lang_word('all-categories')); ?>

                            </a>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="col-xl-6 col-lg-4 order-lg-2 order-0">
                <div class="swiper hero-slider">
                    <div class="swiper-wrapper">
                        <?php if(count($sliders)): ?>
                            <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="swiper-slide">
                                    <img class="lazyload"
                                         data-src="<?php echo e($slider->photo && is_file($slider->photo->path) ? url($slider->photo->path) : url('source/Slıder1.jpg')); ?>"
                                         <?php if($slider->link != '#' || !blank($slider->link)): ?> onclick="document.location = '<?php echo e($slider->link); ?>'"
                                         <?php endif; ?> alt="<?php echo e(photo_alt($slider, 'photo', 'slider')); ?>"/>
                                    <?php if($slider->type == 'ad'): ?>
                                    <span class="hero-slider-badge">AD</span>
                                    <?php endif; ?>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                    <div class="swiper-pagination hero-slider-pagination"></div>
                </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-sm-6 order-sm-3 order-3">
                <div class="form-widget-container">
                    <ul class="nav nav-tabs" id="filterTabs" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="suppliers-tab" data-bs-toggle="tab"
                                    data-bs-target="#form-content" type="button" role="tab" aria-controls="suppliers"
                                    aria-selected="true">
                                Suppliers
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="buyers-tab" data-bs-toggle="tab" data-bs-target="#form-content"
                                    type="button" role="tab" aria-controls="buyers" aria-selected="false">
                                Buyers
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="products-tab" data-bs-toggle="tab"
                                    data-bs-target="#form-content" type="button" role="tab" aria-controls="products"
                                    aria-selected="false">
                                Products
                            </button>
                        </li>
                    </ul>

                    <div class="tab-content" id="filterTabsContent">
                        <div class="tab-pane fade show active" id="form-content" role="tabpanel">
                            <form>
                                <div class="mb-2">
                                    <label for="companyType" class="form-label">Company Type</label>
                                    <div class="select-container">
                                        <select id="companyType">
                                            <option selected disabled></option>
                                            <option value="1">Manufacturer</option>
                                            <option value="2">Wholesaler</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="mb-2">
                                    <label for="industry" class="form-label">Industry</label>
                                    <div class="select-container">
                                        <select id="industry">
                                            <option selected disabled></option>
                                            <option value="1">Food & Beverage</option>
                                            <option value="2">Chemical</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="mb-2">
                                    <label for="subIndustry" class="form-label">Sub Industry</label>
                                    <div class="select-container">
                                        <select id="subIndustry">
                                            <option selected disabled></option>
                                            <option value="1">Dairy Products</option>
                                            <option value="2">Personal Care</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="mb-2">
                                    <label for="tradeTerms" class="form-label">Trade Terms</label>
                                    <div class="select-container">
                                        <select id="tradeTerms">
                                            <option selected disabled></option>
                                            <option value="1">FOB</option>
                                            <option value="2">CIF</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-check mb-4">
                                    <input class="form-check-input" type="checkbox" value="" id="verifiedSuppliers">
                                    <label class="form-check-label" for="verifiedSuppliers">
                                        Verified Suppliers
                                    </label>
                                </div>

                                <div class="form-buttons">
                                    <button type="submit" class="default-button">SUBMIT</button>
                                    <button type="reset" class="default-button">RESET</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Of Hero Section -->

    <!-- Cta Section -->
    <div class="container-xxl">
        <div class="row g-3">
            <?php $__currentLoopData = $banner1; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-6">
                    <div class="banner-box">
                        
                        <?php if($banner->status == 'active'): ?>
                            <img src="<?php echo e(url($banner->photo->path)); ?>"
                                 alt="<?php echo e(photo_alt($banner, 'photo', 'banner')); ?>">
                        <?php else: ?>
                            <img src="<?php echo e(url($banner->photo_default->path)); ?>"
                                 alt="<?php echo e(photo_alt($banner, 'photo_default', 'banner')); ?>">
                        <?php endif; ?>
                        
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>

    <!-- End Of Cta Section -->

    <!-- Products Section -->
    <div class="container-xxl">
        <div class="tab-rotate">
            <ul class="nav nav-tabs flex-column" id="productsTabs" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="new-products-tab" data-bs-toggle="pill"
                            data-bs-target="#new-products" type="button" role="tab" aria-controls="new-products"
                            aria-selected="false">
                        <span><?php echo e(read_lang_word('products-new')); ?></span>
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="trend-products-tab" data-bs-toggle="pill"
                            data-bs-target="#trend-products" type="button" role="tab" aria-controls="trend-products"
                            aria-selected="true">
                        <span><?php echo e(read_lang_word('trend-products')); ?></span>
                    </button>
                </li>
            </ul>

            <div class="tab-content" id="productsTabsContent">
                <div class="tab-pane fade show active" id="new-products" role="tabpanel"
                     aria-labelledby="new-products-tab">
                    <div class="row g-3">
                        <?php if(count($products)): ?>
                            <!--service section start-->
                            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-3 col-6 col-lg-2 col-sm-4">
                                    <?php echo $__env->make('front.product.includes.card', ['item' => $product], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <div class="col">
                                <a href="#" class="product-square-card more">
                                    <span><?php echo e(read_lang_word('more')); ?></span>
                                    <i class="fa-solid fa-arrow-right"></i>
                                </a>
                            </div>
                            <!--service section end-->
                        <?php endif; ?>

                    </div>
                </div>

                <div class="tab-pane fade" id="trend-products" role="tabpanel" aria-labelledby="trend-products-tab">
                    <div class="row g-3">
                        <?php if(count($products_top)): ?>
                            <!--service section start-->
                            <?php $__currentLoopData = $products_top; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-3 col-6 col-lg-2 col-sm-4">
                                    <?php echo $__env->make('front.product.includes.card', ['item' => $product], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <div class="col">
                                <a href="#" class="product-square-card more">
                                    <span><?php echo e(read_lang_word('more')); ?></span>
                                    <i class="fa-solid fa-arrow-right"></i>
                                </a>
                            </div>
                            <!--service section end-->
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- End Of Products Section -->

    <!-- Cta Section -->
    
    <div class="container-xxl">
        <div class="row g-3">
            <div class="col-lg-6">
                <div class="banner-box h-100">
                    <img src="<?php echo e(url($banner3->first()->photo->path)); ?>"
                         alt="<?php echo e(photo_alt($banner2->first(), 'photo', 'banner')); ?>">
                </div>
            </div>
            <div class="col-lg-6">
                <form class="section-card flex-column justify-content-between h-100">
                    <div class="section-heading">
                        <div class="section-heading-right-side flex-1">
                            <div class="section-heading-title-box flex-1">
                                <h6 class="section-heading-title flex-1">What Are You Looking For?</h6>
                            </div>
                        </div>

                        <div class="section-heading-left-side">
                            <button class="default-button">
                                Send Request
                            </button>
                        </div>
                    </div>

                    <div class="row g-2">
                        <?php echo csrf_field(); ?>

                        <div class="col-6">
                            <input type="text" class="form-control error" id="productName" name="product_name"
                                   required="" placeholder="Product Name Or keyword">
                        </div>
                        <div class="col-3">
                            <input type="number" class="form-control" id="requiredQuantity" name="required_quantity"
                                   required="" placeholder="Purchase Quantity">
                        </div>

                        <div class="col-3">
                            <div class="select-container">
                                <select id="selectUnit" name="select_unit" class="form-select" required="">
                                    <option value="" disabled="" selected="">Unit</option>
                                    <option value="American Gallon(s)">American Gallon(s)</option>
                                    <option value="Bag(s)">Bag(s)</option>
                                    <option value="Bale(s)">Bale(s)</option>
                                    <option value="Barrel(s)">Barrel(s)</option>
                                    <option value="Basket(s)">Basket(s)</option>
                                    <option value="Blade(s)">Blade(s)</option>
                                    <option value="Block(s)">Block(s)</option>
                                    <option value="Bolt(s)">Bolt(s)</option>
                                    <option value="Bottle(s)">Bottle(s)</option>
                                    <option value="Box(s)">Box(s)</option>
                                    <option value="British Gallon(s)">British Gallon(s)</option>
                                    <option value="British Horsepower(s)">British Horsepower(s)</option>
                                    <option value="Bullet(s)">Bullet(s)</option>
                                    <option value="Foot(Feet)">Foot(Feet)</option>
                                    <option value="Piece(s)">Piece(s)</option>
                                    <option value="Meter(s)">Meter(s)</option>
                                    <option value="20' Container(s)">20' Container(s)</option>
                                    <option value="40' Container(s)">40' Container(s)</option>
                                    <option value="40' HQ Container(s)">40' HQ Container(s)</option>
                                    <option value="Ream(s)">Ream(s)</option>
                                    <option value="Roll(s)">Roll(s)</option>
                                    <option value="Set(s)">Set(s)</option>
                                    <option value="Square Meter(s)">Square Meter(s)</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-12">
                            <textarea class="form-control" id="productDetails" name="product_details" rows="3"
                                      required="" placeholder="Product Description"></textarea>
                        </div>
                    </div>
                </form>


            </div>
        </div>
    </div>
    <!-- End Of Cta Section -->

    <!-- Service Section -->
    <div class="container-xxl">
        <div class="row g-3">
            <div class="col-lg-9 flex-column">
                <div class="showcase-header">
                    <ul class="nav nav-tabs" id="servicesTab" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="top-services-tab" data-bs-toggle="tab"
                                    data-bs-target="#top-services" type="button" role="tab" aria-controls="top-services"
                                    aria-selected="true"><?php echo e(read_lang_word('top-services')); ?>

                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="top-providers-tab" data-bs-toggle="tab"
                                    data-bs-target="#top-providers" type="button" role="tab"
                                    aria-controls="top-providers" aria-selected="false">
                                <?php echo e(read_lang_word('top-service-providers')); ?>

                            </button>
                        </li>
                    </ul>
                    <a href="#" class="default-button btn-view-more"><?php echo e(read_lang_word('view-more')); ?></a>
                </div>

                <div class="tab-content" id="servicesTabContent">
                    <div class="tab-pane fade show active" id="top-services" role="tabpanel">
                        <div class="row g-3 h-100">
                            <?php $__currentLoopData = $top_product_service; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-lg-4 col-md-6">
                                    <div class="service-card">
                                        <div class="service-card-header">
                                            <h5 class="service-card-title"><?php echo e(read_lang($service, 'title')); ?></h5>
                                            <img src="<?php echo e(url($service->icon->path ?? 'assets/front/new/icon/default.png')); ?>">
                                        </div>
                                        <div class="service-card-body">
                                            <div class="service-card-default-content">
                                                <ul>
                                                    <?php if($service->c1): ?>
                                                        <li><?php echo e(read_lang($service->c1, 'title')); ?></li>
                                                    <?php endif; ?>
                                                    <?php if($service->c2): ?>
                                                        <li><?php echo e(read_lang($service->c2, 'title')); ?></li>
                                                    <?php endif; ?>
                                                    <?php if($service->c3): ?>
                                                        <li><?php echo e(read_lang($service->c3, 'title')); ?></li>
                                                    <?php endif; ?>
                                                    <?php if($service->c4): ?>
                                                        <li><?php echo e(read_lang($service->c4, 'title')); ?></li>
                                                    <?php endif; ?>
                                                </ul>
                                            </div>
                                            <div class="service-card-hover-content">
                                                <?php echo e(Str::limit(strip_tags(read_lang($service, 'text') ?? ''), 250, '...')); ?>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    <div class="tab-pane fade" id="top-providers" role="tabpanel">
                        <div class="row g-3">
                            <?php $__currentLoopData = $topProviders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $provider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($provider->services->count() > 0): ?>
                                    <div class="col-lg-4 col-md-6">
                                        <div class="provider-card">
                                            <div class="provider-card-logo">
                                                <img style="width: 100px"
                                                     src="<?php echo e($provider->photo && is_file($provider->photo->path) ? url($provider->photo->path) : url('assets/front/new/images/sup.webp')); ?>"
                                                     alt="<?php echo e($provider->name); ?> Logo">
                                            </div>
                                            <div class="provider-card-image-wrapper">
                                                <?php if($provider->services->count() > 0): ?>
                                                    <img style="height:250px; "
                                                         src="<?php echo e($provider->services[0]->photo && is_file($provider->services[0]->photo->path) ? url($provider->services[0]->photo->path) : url($provider->photo->path)); ?>"
                                                         class="provider-card-main-image"
                                                         alt="<?php echo e(read_lang($provider->services[0], 'title')); ?>">
                                                <?php else: ?>
                                                    <img style="height:250px; " src="<?php echo e(url($provider->photo->path)); ?>"
                                                         class="provider-card-main-image" alt="No Service">
                                                <?php endif; ?>

                                                <div class="provider-card-overlay">
                                                    <p><strong><?php echo e(read_lang_word('company-name')); ?>

                                                            :</strong> <?php echo e($provider->name); ?></p>

                                                    <?php if($provider->services->count() > 0): ?>
                                                        <p class="provider-card-main-service">
                                                            <strong><?php echo e(read_lang_word('service-sig')); ?>:</strong>
                                                            <?php echo e(read_lang($provider->services[0], 'title')); ?>

                                                        </p>
                                                    <?php endif; ?>

                                                    <div class="provider-card-hover-details">
                                                        <h6 class="base-title"><?php echo e(read_lang_word('service')); ?>:</h6>
                                                        <ul>
                                                            <?php $__currentLoopData = $provider->services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <li><?php echo e(read_lang($service, 'title')); ?></li>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 flex-column gap-3">
                <div class="form-widget-container p-3">

                    <h3 class="base-title"><?php echo e(read_lang_word('what-service-do-you-need')); ?></h3>
                    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('front.service.service-form', ['wire:lazy' => true]);

$__html = app('livewire')->mount($__name, $__params, 'lw-2774780197-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>

                </div>

                <div class="banner-box h-auto">
                    <img src="<?php echo e(url($banner3->first()->photo->path)); ?>"
                         alt="<?php echo e(photo_alt($banner3->first(), 'photo', 'banner')); ?>">
                </div>
            </div>
        </div>
    </div>
    <!-- End OF Service Section -->

    <!-- Top Suppliers Section -->
    <?php if(count($suppliers)): ?>
        <div class="container-xxl">
            <div class="section-card">
                <div class="section-heading">
                    <div class="section-heading-right-side">
                        <div class="section-heading-title-box">
                            <h6 class="section-heading-title"><?php echo e(read_lang_word('top-suppliers2')); ?></h6>
                        </div>
                    </div>

                    <div class="section-heading-left-side">
                        <a href="" class="default-button">
                            <?php echo e(read_lang_word('view-more')); ?>

                        </a>
                    </div>
                </div>

                <div class="row g-3">
                    <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($index < 2): ?>
                            <?php if($item->products->first()): ?>
                                <div class="col-lg-6">
                                    <a href="<?php echo e(route('front.supplier.show', $item->u_id)); ?>" class="supplier-card">
                                        <div class="card-details-section">
                                            <div class="card-logo">
                                                <img src="<?php echo e($item->photo && is_file($item->photo->path) ? url($item->photo->path) : url('assets/front/img/favicon.png')); ?>"
                                                     alt="<?php echo e(photo_alt($item, 'photo', $item->name)); ?>">
                                            </div>
                                            <ul class="info-list">
                                                <li><strong>Company Name:</strong>
                                                    <span><?php echo e(read_lang($item, $item->company_name == null ? 'name' : 'company_name')); ?></span>
                                                </li>
                                                <li><strong><?php echo e(read_lang_word('industry')); ?>:</strong>
                                                    <span><?php echo e($item->industry ?? 'N/A'); ?></span>
                                                </li>
                                                <li><strong><?php echo e(read_lang_word('company-type')); ?>:</strong>
                                                    <span>
                                                        <?php if(count($item->user_business)): ?>
                                                            <span>
                                                                <?php $__currentLoopData = $item->user_business; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $business): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php echo e($key > 0 ? ', ' : ''); ?>

                                                                    <?php echo e($business->title); ?>

                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </span>
                                                        <?php else: ?>
                                                            <span>__</span>
                                                        <?php endif; ?>
                                                    </span>
                                                </li>
                                                <li><strong>Year of Establish:</strong>
                                                    <span><?php echo e($item->year_established ?? 'N/A'); ?></span>
                                                </li>
                                                <li><strong><?php echo e(read_lang_word('verified-supplier')); ?>:</strong>
                                                    <span><?php echo e($item->status == 'active' ? 'YES' : 'NO'); ?></span>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="card-image-section">
                                            <?php if($item->products->first()): ?>
                                                <img src="<?php echo e($item->products->first()->photo && is_file($item->products->first()->photo->path) ? url($item->products->first()->photo->path) : url('assets/front/new/images/device.webp')); ?>"
                                                     alt="<?php echo e($item->name); ?> Equipment">
                                            <?php endif; ?>
                                        </div>
                                    </a>
                                </div>
                            <?php endif; ?>
                        <?php else: ?>
                            <?php if($item->products->first()): ?>
                                <div class="col-xl-2 col-lg-3 col-md-4 col-6">
                                    <a href="<?php echo e(route('front.supplier.show', $item->u_id)); ?>" class="supplier-card sm">
                                        <div class="card-logo">
                                            <img src="<?php echo e($item->photo && is_file($item->photo->path) ? url($item->photo->path) : url('assets/front/img/favicon.png')); ?>"
                                                 alt="<?php echo e(photo_alt($item, 'photo', $item->name)); ?>">
                                        </div>
                                        <ul class="info-list">
                                            <li><strong>Industry:</strong> <span><?php echo e($item->industry ?? 'N/A'); ?></span>
                                            </li>
                                        </ul>
                                        <div class="product-image">
                                            <?php if($item->products->first()): ?>
                                                <img src="<?php echo e($item->products->first()->photo && is_file($item->products->first()->photo->path) ? url($item->products->first()->photo->path) : url('assets/front/new/images/device.webp')); ?>"
                                                     alt="<?php echo e($item->name); ?> Equipment">
                                            <?php endif; ?>
                                        </div>
                                    </a>
                                </div>
                            <?php endif; ?>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <!-- End OF Top Suppliers Section -->

    <div class="container-xxl">
        <a href="<?php echo e($banner4->first()->status == 'active' && !blank($banner4->first()->link) ? $banner4->first()->link : '#'); ?>"
           class="banner-box h-auto">
            <img src="<?php echo e(url($banner4->first()->photo->path)); ?>"
                 alt="<?php echo e(photo_alt($banner4->first(), 'photo', 'banner')); ?>">
        </a>
    </div>

    <div class="container-xxl">
        <div class="row g-3 justify-content-center">
            <?php if($exhibitions_smart->count()): ?>
                <div class="col-lg-6">

                    <div class="section-card">
                        <div class="section-heading">
                            <div class="section-heading-right-side">
                                <div class="section-heading-title-box">
                                    <h6 class="section-heading-title"><?php echo e(read_lang_word('smart-expo')); ?></h6>
                                </div>
                            </div>
                            <div class="section-heading-left-side">
                                <a href="#" class="default-button"><?php echo e(read_lang_word('view-more')); ?></a>
                            </div>
                        </div>

                        <div class="section-content">
                            <div class="row g-4">
                                <?php $__currentLoopData = $exhibitions_smart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $exhibition): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($index < 1): ?>
                                        <div class="col-12">
                                            <div class="expo-card">
                                                <div class="expo-card-details">
                                                    <h5 class="expo-title"><?php echo e(read_lang($exhibition, 'title')); ?></h5>
                                                    <ul class="info-list">
                                                        <li><strong><?php echo e(read_lang_word('industry')); ?>:</strong>
                                                            <span><?php echo e(read_lang($exhibition, 'industry')); ?></span>
                                                        </li>
                                                        <li><strong><?php echo e(read_lang_word('duration')); ?>:</strong>
                                                            <span><?php echo e(formatDateRange($exhibition->start_date, $exhibition->end_date)); ?></span>
                                                        </li>
                                                    </ul>
                                                </div>
                                                <div class="expo-card-banner">
                                                    <img src="<?php echo e(url($exhibition->photo->path)); ?>"
                                                         alt="Subcon Thailand">
                                                </div>
                                            </div>
                                        </div>
                                    <?php else: ?>
                                        <div class="col-lg-4 col-md-6">
                                            <div class="expo-card sm">
                                                <div class="expo-card-image">
                                                    <img src="<?php echo e(url($exhibition->photo->path)); ?>"
                                                         alt="Subcon Thailand">
                                                </div>
                                                <div class="expo-card-details">
                                                    <h6 class="expo-title"><?php echo e(read_lang($exhibition, 'title')); ?></h6>
                                                    <ul class="info-list">
                                                        <li><strong><?php echo e(read_lang_word('industry')); ?>:</strong>
                                                            <span><?php echo e(read_lang($exhibition, 'industry')); ?></span>
                                                        </li>
                                                        <li><strong><?php echo e(read_lang_word('duration')); ?>:</strong>
                                                            <span><?php echo e(formatDateRange($exhibition->start_date, $exhibition->end_date)); ?></span>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if($exhibitions_online->count()): ?>
                <div class="col-lg-6">
                    <div class="section-card">
                        <div class="section-heading">
                            <div class="section-heading-right-side">
                                <div class="section-heading-title-box">
                                    <h6 class="section-heading-title"><?php echo e(read_lang_word('online-expo')); ?></h6>
                                </div>
                            </div>
                            <div class="section-heading-left-side">
                                <a href="#" class="default-button"><?php echo e(read_lang_word('view-more')); ?></a>
                            </div>
                        </div>

                        <div class="section-content">
                            <div class="row g-4">
                                <?php $__currentLoopData = $exhibitions_online; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $exhibition): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($index < 1): ?>
                                        <div class="col-12">
                                            <div class="expo-card">
                                                <div class="expo-card-details">
                                                    <h5 class="expo-title"><?php echo e(read_lang($exhibition, 'title')); ?></h5>
                                                    <ul class="info-list">
                                                        <li><strong><?php echo e(read_lang_word('industry')); ?>:</strong>
                                                            <span><?php echo e(read_lang($exhibition, 'industry')); ?></span>
                                                        </li>
                                                        <li><strong><?php echo e(read_lang_word('duration')); ?>:</strong>
                                                            <span><?php echo e(formatDateRange($exhibition->start_date, $exhibition->end_date)); ?></span>
                                                        </li>
                                                    </ul>
                                                </div>
                                                <div class="expo-card-banner">
                                                    <img src="<?php echo e(url($exhibition->photo->path)); ?>"
                                                         alt="Subcon Thailand">
                                                </div>
                                            </div>
                                        </div>
                                    <?php else: ?>
                                        <div class="col-lg-4 col-md-6">
                                            <div class="expo-card sm">
                                                <div class="expo-card-image">
                                                    <img src="<?php echo e(url($exhibition->photo->path)); ?>"
                                                         alt="Subcon Thailand">
                                                </div>
                                                <div class="expo-card-details">
                                                    <h6 class="expo-title"><?php echo e(read_lang($exhibition, 'title')); ?></h6>
                                                    <ul class="info-list">
                                                        <li><strong><?php echo e(read_lang_word('industry')); ?>:</strong>
                                                            <span><?php echo e(read_lang($exhibition, 'industry')); ?></span>
                                                        </li>
                                                        <li><strong><?php echo e(read_lang_word('duration')); ?>:</strong>
                                                            <span><?php echo e(formatDateRange($exhibition->start_date, $exhibition->end_date)); ?></span>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Servceis List Section -->
    <?php if($our_service->count()): ?>
        <div class="container-xxl">
            <div class="section-card">
                <div class="section-heading">
                    <div class="section-heading-right-side">
                        <div class="section-heading-title-box">
                            <h6 class="section-heading-title"><?php echo e(read_lang_word('our-services')); ?></h6>
                        </div>
                    </div>

                    <div class="section-heading-left-side">
                        <a href="" class="default-button">
                            <?php echo e(read_lang_word('view-more')); ?>

                        </a>
                    </div>
                </div>
                <div class="row g-3">
                    <?php $__currentLoopData = $our_service; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-lg-3 col-md-6">
                            <div class="service-card">
                                <div class="service-card-header">
                                    <h5 class="service-card-title"><?php echo e(read_lang($service, 'title')); ?></h5>
                                    <img style="width: 30px"
                                         src="<?php echo e(url($service->icon->path ?? 'assets/front/new/icon/default.png')); ?>">
                                </div>
                                <div class="service-card-body">
                                    <div class="service-card-default-content">
                                        <ul>
                                            <?php if($service->c1): ?>
                                                <li><?php echo e(read_lang($service->c1, 'title')); ?></li>
                                            <?php endif; ?>
                                            <?php if($service->c2): ?>
                                                <li><?php echo e(read_lang($service->c2, 'title')); ?></li>
                                            <?php endif; ?>
                                            <?php if($service->c3): ?>
                                                <li><?php echo e(read_lang($service->c3, 'title')); ?></li>
                                            <?php endif; ?>
                                            <?php if($service->c4): ?>
                                                <li><?php echo e(read_lang($service->c4, 'title')); ?></li>
                                            <?php endif; ?>
                                        </ul>
                                    </div>
                                    <div class="service-card-hover-content">
                                        <?php echo e(Str::limit(strip_tags(read_lang($service, 'text') ?? ''), 250, '...')); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <!-- End Of Servceis List Section -->


    <div class="container-xxl">
        <div class="row g-4">

            <div class="col-xl-6">
                <div class="section-card h-100">
                    <div class="section-heading">
                        <div class="section-heading-right-side">
                            <div class="section-heading-title-box">
                                <h6 class="section-heading-title"><?php echo e(read_lang_word('blog')); ?></h6>
                            </div>
                        </div>
                        <div class="section-heading-left-side">
                            <a href="#" class="default-button"><?php echo e(read_lang_word('view-more')); ?></a>
                        </div>
                    </div>
                    <div class="section-content home-blog-section">
                        <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($index < 2): ?>
                                <div class="blog-card">
                                    <div class="card-image">
                                        <img src="<?php echo e($blog->photo && is_file($blog->photo->path) ? url($blog->photo->path) : url('assets/front/img/home1/blog-1.jpg')); ?>"
                                             alt="<?php echo e(photo_alt($blog, 'photo', read_lang($blog, 'title'))); ?>">
                                        <div class="image-overlay-title"><?php echo e(read_lang($blog, 'title')); ?></div>
                                    </div>
                                    <div class="card-content">
                                        <h5 class="card-title"><?php echo e(read_lang($blog, 'title')); ?></h5>
                                        <p class="card-excerpt"><?php echo e(Str::limit(strip_tags(read_lang($blog, 'text') ?? ''), 100, '...')); ?></p>
                                        <div class="card-meta">
                                            <div class="card-meta-left">
                                                <span><?php echo e(read_lang($blog, 'author')); ?></span>
                                                <?php if(app()->getLocale() == 'fa'): ?>
                                                    <span dir="rtl"><?php echo e(my_jdate($blog->created_at, 'd F Y')); ?></span>
                                                <?php else: ?>
                                                    <span><?php echo e($blog->created_at->format('M d, Y')); ?></span>
                                                <?php endif; ?>
                                            </div>
                                            <a href="<?php echo e(route('front.blog.show', [$blog->slug])); ?>" class="arrow-link">
                                                <i class="fa-solid fa-arrow-right"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <?php if($index > 1 && $index < 4): ?>
                                <div class="blog-card sm">
                                    <div class="card-image">
                                        <img src="<?php echo e($blog->photo && is_file($blog->photo->path) ? url($blog->photo->path) : url('assets/front/img/home1/blog-1.jpg')); ?>"
                                             alt="<?php echo e(photo_alt($blog, 'photo', read_lang($blog, 'title'))); ?>">
                                    </div>
                                    <div class="card-content">
                                        <h6 class="card-title"><?php echo e(read_lang($blog, 'title')); ?></h6>
                                        <div class="card-meta">
                                            <div class="card-meta-left">
                                                <span><?php echo e(read_lang($blog, 'author')); ?></span>
                                                <?php if(app()->getLocale() == 'fa'): ?>
                                                    <span dir="rtl"><?php echo e(my_jdate($blog->created_at, 'd F Y')); ?></span>
                                                <?php else: ?>
                                                    <span><?php echo e($blog->created_at->format('M d, Y')); ?></span>
                                                <?php endif; ?>
                                            </div>
                                            <a href="<?php echo e(route('front.blog.show', [$blog->slug])); ?>" class="arrow-link">
                                                <i class="fa-solid fa-arrow-right"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>

            <div class="col-xl-6">
                <div class="section-card h-100 d-flex flex-column">
                    <div class="section-heading">
                        <div class="section-heading-right-side">
                            <div class="section-heading-title-box">
                                <h6 class="section-heading-title"><?php echo e(read_lang_word('learning-center')); ?></h6>
                            </div>
                        </div>
                        <div class="section-heading-left-side">
                            <a href="#" class="default-button"><?php echo e(read_lang_word('view-more')); ?></a>
                        </div>
                    </div>
                    <div class="section-content video-section">
                        <?php $__currentLoopData = $learnings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $learning): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($index < 1): ?>
                                <div class="resource-card featured video">
                                    <div class="card-image">
                                        <img src="<?php echo e($learning->photo ? url($learning->photo->path) : url('assets/front/new/images/video.jpg')); ?>"
                                             alt="<?php echo e($learning->slug); ?>">

                                        <a href="<?php echo e($learning->link == null ? url($learning->video->path) : $learning->link); ?>"
                                           class="play-button" data-fancybox>
                                            <i class="fa-solid fa-play"></i>
                                        </a>

                                        <div class="video-overlay-content">
                                            <div class="d-flex justify-content-between">
                                                <?php echo e(Str::limit(strip_tags(read_lang($learning, 'text') ?? ''), 150, '...')); ?>

                                                <a style="width: 20px;height: 10px;" class="default-button" href="#"><i style="font-size: 14px ;"
                                                                                                           class="fa fa-arrow-down fa-rotate-270"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php elseif($index < 3): ?>
                                <div class="resource-card featured video">
                                    <div class="card-image">
                                        <img src="<?php echo e($learning->photo ? url($learning->photo->path) : url('assets/front/new/images/video.jpg')); ?>"
                                             alt="<?php echo e($learning->title ?? 'Supplier'); ?>">

                                        <a href="<?php echo e($learning->link == null ? url($learning->video->path) : $learning->link); ?>"
                                           class="play-button" data-fancybox>
                                            <i class="fa-solid fa-play"></i>
                                        </a>
                                        <div class="video-overlay-content">
                                            <div class="d-flex justify-content-between">
                                                <h5 class="card-title"><?php echo e(Str::limit(strip_tags(read_lang($learning, 'text') ?? ''), 50, '...')); ?></h5>
                                                <a style="width: 20px;height: 10px;" class="default-button" href="#"><i style="font-size: 14px ;"
                                                                                                                        class="fa fa-arrow-down fa-rotate-270"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>

        </div>
    </div>


    <div class="container-xxl">
        <div class="section-card">
            <div class="section-heading">
                <div class="section-heading-right-side">
                    <div class="section-heading-title-box">
                        <h6 class="section-heading-title"><?php echo e(read_lang_word('testimonials')); ?></h6>
                    </div>
                    <p><?php echo e(read_lang_word('we-truly-appreciate-your-time-and-support-your-feedback-help-us-grow')); ?></p>
                </div>
                <div class="section-heading-left-side">
                    <a href="#" class="default-button"><?php echo e(read_lang_word('view-more')); ?></a>
                </div>
            </div>

            <div class="section-content">
                <div class="row g-4">

                    <div class="col-lg-4">
                        <div class="gray-card">
                            <div class="flex justify-content-between">
                                <h5 class="base-title"><?php echo e(read_lang_word('success-stories')); ?></h5>
                                <a href="#" class="view-all-link"><?php echo e(read_lang_word('view-all')); ?></a>
                            </div>
                            <div class="swiper success-stories-slider">
                                <div class="swiper-wrapper">
                                    <?php $__currentLoopData = $stories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $story): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="swiper-slide">
                                            <div class="testimonial-card">
                                                <div class="card-logo"><img src="<?php echo e(url($story->photo->path)); ?>"
                                                                            alt="Glaicmc Logo"></div>
                                                <p class="testimonial-text"><?php echo e(Str::limit(strip_tags($story->story ?? ''), 250, '...')); ?></p>
                                                <span class="testimonial-author">The story of <?php echo e($story->company_name); ?> company</span>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                                <div class="swiper-button-prev success-stories-slider-prev"></div>
                                <div class="swiper-button-next success-stories-slider-next"></div>
                            </div>
                            <button type="button" class="default-button" data-bs-toggle="modal"
                                    data-bs-target="#feedbackModal">
                                <?php echo e(read_lang_word('send-feedback')); ?>

                            </button>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="gray-card">
                            <h5 class="base-title"><?php echo e(read_lang_word('videos')); ?></h5>
                            <div class="swiper video-slider text-center">
                                <div class="swiper-wrapper">
                                    <?php $__currentLoopData = $videos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $video): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="swiper-slide">
                                            <a data-fancybox href="<?php echo e(url($video->video->path)); ?>"
                                               data-caption="<?php echo e($video->full_name); ?>">
                                                <video width="320" height="180" preload="metadata" muted>
                                                    <source src="<?php echo e(url($video->video->path)); ?>" type="video/mp4"/>
                                                </video>
                                            </a>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                                <div class="swiper-button-prev video-nav-prev"></div>
                                <div class="swiper-button-next video-nav-next"></div>
                            </div>
                            <button type="button" class="default-button" data-bs-toggle="modal"
                                    data-bs-target="#feedbackModal2">
                                <?php echo e(read_lang_word('send-video')); ?>

                            </button>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="gray-card">
                            <h5 class="base-title"><?php echo e(read_lang_word('mainexpo-rating--reviews')); ?></h5>
                            <div class="ratings-list">
                                <?php $__currentLoopData = $ratings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rating): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="rating-item">
                                        <a href="<?php echo e($rating->link); ?>" target="_blank">
                                            <img src="<?php echo e(url($rating->photo->path)); ?>" alt="Google Logo"
                                                 class="platform-logo">
                                        </a>
                                        <span class="rating-score"><?php echo e(number_format($rating->score, 1)); ?></span>
                                        <div class="stars">
                                            <?php for($i = 1; $i <= 5; $i++): ?>
                                                <?php if($i <= floor($rating->score)): ?>
                                                    <i class="fa-solid fa-star"></i>
                                                <?php elseif($i == floor($rating->score) + 1 && $rating->score - floor($rating->score) >= 0.5): ?>
                                                    <i class="fa-solid fa-star-half-stroke"></i>
                                                <?php else: ?>
                                                    <i class="fa-regular fa-star"></i>
                                                <?php endif; ?>
                                            <?php endfor; ?>
                                        </div>
                                        <a href="<?php echo e($rating->link); ?>" class="default-button"
                                           target="_blank"><?php echo e(read_lang_word('write-review')); ?></a>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <!-- Feedback Modal -->
    <div class="modal fade" id="feedbackModal" tabindex="-1" aria-labelledby="feedbackModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="feedbackModalLabel"><?php echo e(read_lang_word('send-feedback')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="feedbackForm" action="<?php echo e(route('front.feedback.submit')); ?>" method="POST"
                      enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="feedbackName" class="form-label"><?php echo e(read_lang_word('full-name')); ?> *</label>
                            <input type="text" class="form-control" id="feedbackName" name="name" required>
                        </div>
                        <div class="mb-3">
                            <label for="feedbackEmail" class="form-label"><?php echo e(read_lang_word('email')); ?> *</label>
                            <input type="email" class="form-control" id="feedbackEmail" name="email" required>
                        </div>
                        <div class="mb-3">
                            <label for="feedbackCompany" class="form-label"><?php echo e(read_lang_word('company-name')); ?>

                                *</label>
                            <input type="text" class="form-control" id="feedbackCompany" name="company">
                        </div>
                        <div class="mb-3">
                            <label for="logo" class="form-label"><?php echo e(read_lang_word('logo')); ?> *</label>
                            <input type="file" class="form-control" id="logo" name="logo">
                        </div>
                        <div class="mb-3">
                            <label for="feedbackStory" class="form-label"><?php echo e(read_lang_word('your-success-story')); ?>

                                *</label>
                            <textarea class="form-control" id="feedbackStory" name="story" rows="5" required></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                                data-bs-dismiss="modal"><?php echo e(read_lang_word('close')); ?></button>
                        <button type="submit" class="default-button"><?php echo e(read_lang_word('submit-form')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="modal fade" id="feedbackModal2" tabindex="-1" aria-labelledby="feedbackModalLabel2" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="feedbackModalLabel"><?php echo e(read_lang_word('send-feedback')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="feedbackForm2" action="<?php echo e(route('front.feedback.video.submit')); ?>" method="POST"
                      enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="feedbackName" class="form-label"><?php echo e(read_lang_word('full-name')); ?> *</label>
                            <input type="text" class="form-control" id="feedbackName" name="name" required>
                        </div>
                        <div class="mb-3">
                            <label for="feedbackEmail" class="form-label"><?php echo e(read_lang_word('email')); ?> *</label>
                            <input type="email" class="form-control" id="feedbackEmail" name="email" required>
                        </div>
                        <div class="mb-3">
                            <label for="video" class="form-label"><?php echo e(read_lang_word('video')); ?> *</label>
                            <input type="file" class="form-control" id="video" name="video">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                                data-bs-dismiss="modal"><?php echo e(read_lang_word('close')); ?></button>
                        <button type="submit" class="default-button"><?php echo e(read_lang_word('submit-form')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Partners Section -->
    <?php if(count($partners)): ?>
        <div class="container-xxl d-flex">
            <span class="default-button rotate"><?php echo e(read_lang_word('partner2')); ?></span>

            <div class="swiper logos-slider bg-white p-3">
                <div class="swiper-wrapper">
                    <?php $__currentLoopData = $partners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="swiper-slide">
                            <div class="logo-slide-card" style="background-color: white">
                                <a href="<?php echo e($item->link ?? '#'); ?>" class="top_suppliers_a">
                                    <img class="lazyload"
                                         data-src="<?php echo e($item->photo && is_file($item->photo->path) ? url($item->photo->path) : url('assets/front/img/home1/blog-1.jpg')); ?>"
                                         alt="<?php echo e(photo_alt($item, 'photo', read_lang($item, 'title'))); ?>"/>
                                </a>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <!-- End Of Partners Section -->

    <!-- FAQ Section -->
    <section class="container-xxl mt--5">
        <div class="section-card">
            <!-- Heading Box -->
            <div class="section-heading">
                <!-- Title And Description -->
                <div class="section-heading-right-side">
                    <div class="section-heading-title-box">
                        <h6 class="section-heading-title"><?php echo e(read_lang_word('frequently-asked-questions')); ?></h6>
                    </div>
                </div>

                <!-- Input Or Buttons -->
                <div class="section-heading-left-side">
                    <a href="" class="default-button">
                        <?php echo e(read_lang_word('view-more')); ?>

                    </a>
                </div>
            </div>

            <!-- Accordions List -->
            <div class="accordion flex-column gap-3" id="faqAccordion">
                <!-- Accordion Item -->
                <?php $__currentLoopData = $faqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $faq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="accordion-item">
                        <h3 class="accordion-header" id="accordion-<?php echo e($index + 1); ?>">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#accordion-body-<?php echo e($index + 1); ?>" aria-expanded="true"
                                    aria-controls="collapseOne">
                                <?php echo e($index + 1); ?>. <?php echo e($faq->question); ?>

                            </button>
                        </h3>
                        <div id="accordion-body-<?php echo e($index + 1); ?>" class="accordion-collapse collapse"
                             aria-labelledby="accordion-<?php echo e($index + 1); ?>" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                <?php echo $faq->answer; ?>

                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <div>
                <button type="button" class="default-button m-auto mt-3" data-bs-toggle="modal"
                        data-bs-target="#askModal">
                    <?php echo e(read_lang_word('ask-your-question')); ?>

                </button>
            </div>
        </div>
    </section>
    <!-- End FAQ Section -->
    <!-- ask Modal -->
    <div class="modal fade" id="askModal" tabindex="-1" aria-labelledby="askModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="feedbackModalLabel"><?php echo e(read_lang_word('send-feedback')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="feedbackForm" action="<?php echo e(route('front.feedback.submit')); ?>" method="POST"
                      enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="feedbackName" class="form-label"><?php echo e(read_lang_word('full-name')); ?> *</label>
                            <input type="text" class="form-control" id="feedbackName" name="name" required>
                        </div>
                        <div class="mb-3">
                            <label for="feedbackEmail" class="form-label"><?php echo e(read_lang_word('email')); ?> *</label>
                            <input type="email" class="form-control" id="feedbackEmail" name="email" required>
                        </div>
                        <div class="mb-3">
                            <label for="feedbackCompany" class="form-label"><?php echo e(read_lang_word('company-name')); ?>

                                *</label>
                            <input type="text" class="form-control" id="feedbackCompany" name="company">
                        </div>
                        <div class="mb-3">
                            <label for="feedbackStory" class="form-label"><?php echo e(read_lang_word('your-question')); ?>

                            </label>
                            <textarea class="form-control" id="feedbackStory" name="story" rows="5" required></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                                data-bs-dismiss="modal"><?php echo e(read_lang_word('close')); ?></button>
                        <button type="submit" class="default-button"><?php echo e(read_lang_word('submit-form')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0/dist/fancybox/fancybox.umd.js"></script>
    <script>
        Fancybox.bind("[data-fancybox]", {});
    </script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {

            const feedbackForm = document.getElementById('feedbackForm');
            const feedbackForm2 = document.getElementById('feedbackForm2');

            if (feedbackForm) {
                feedbackForm.addEventListener('submit', function (e) {
                    e.preventDefault();

                    // نمایش اسپینر یا پیام در حال بارگذاری
                    const submitBtn = feedbackForm.querySelector('[type="submit"]');
                    submitBtn.disabled = true;
                    submitBtn.innerHTML = '<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> <?php echo e(read_lang_word('submitting')); ?>...';

                    // ارسال فرم با AJAX
                    fetch(feedbackForm.action, {
                        method: 'POST',
                        body: new FormData(feedbackForm),
                        headers: {
                            'X-Requested-With': 'XMLHttpRequest',
                            'Accept': 'application/json'
                        }
                    })
                        .then(response => response.json())
                        .then(data => {
                            if (data.success) {
                                alert('<?php echo e(read_lang_word('feedback-submitted-successfully')); ?>');
                                feedbackForm.reset();
                                const modal = bootstrap.Modal.getInstance(document.getElementById('feedbackModal'));
                                modal.hide();
                            } else {
                                alert(data.message || '<?php echo e(read_lang_word('submission-failed')); ?>');
                            }
                        })
                        .catch(error => {
                            console.error('Error:', error);
                            alert('<?php echo e(read_lang_word('submission-error')); ?>');
                        })
                        .finally(() => {
                            submitBtn.disabled = false;
                            submitBtn.textContent = '<?php echo e(read_lang_word('submit')); ?>';
                        });
                });
            }
            if (feedbackForm2) {
                feedbackForm2.addEventListener('submit', function (e) {
                    e.preventDefault();

                    // نمایش اسپینر یا پیام در حال بارگذاری
                    const submitBtn = feedbackForm2.querySelector('[type="submit"]');
                    submitBtn.disabled = true;
                    submitBtn.innerHTML = '<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> <?php echo e(read_lang_word('submitting')); ?>...';

                    // ارسال فرم با AJAX
                    fetch(feedbackForm2.action, {
                        method: 'POST',
                        body: new FormData(feedbackForm2),
                        headers: {
                            'X-Requested-With': 'XMLHttpRequest',
                            'Accept': 'application/json'
                        }
                    })
                        .then(response => response.json())
                        .then(data => {
                            if (data.success) {
                                alert('<?php echo e(read_lang_word('feedback-submitted-successfully')); ?>');
                                feedbackForm2.reset();
                                const modal = bootstrap.Modal.getInstance(document.getElementById('feedbackModal2'));
                                modal.hide();
                            } else {
                                alert(data.message || '<?php echo e(read_lang_word('submission-failed')); ?>');
                            }
                        })
                        .catch(error => {
                            console.error('Error:', error);
                            alert('<?php echo e(read_lang_word('submission-error')); ?>');
                        })
                        .finally(() => {
                            submitBtn.disabled = false;
                            submitBtn.textContent = '<?php echo e(read_lang_word('submit')); ?>';
                        });
                });
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('front.layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nexpo/public_html/new/source/resources/views/front/index.blade.php ENDPATH**/ ?>