<div x-data="{ isOpen: false }">
    <button
            type="button"
            class="btn btn-success mb-3"
            @click="isOpen = true"
    >
        <i class="fa fa-plus"></i> <?php echo e(translateText('Add Branch Office', lang_admin())); ?>

    </button>
    <div
            class="modal fade"
            :class="{ 'show d-block': isOpen }"
            x-show="isOpen"
            @click.away="isOpen = false"
            role="dialog"
            aria-modal="true"
    >
        <div class="modal-dialog mt-5 my-style-modal">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(translateText('Add New Office', lang_admin())); ?></h5>
                    <button type="button" class="btn-close" @click="isOpen = false" aria-label="Close"></button>
                </div>
                <form wire:submit.prevent="save">
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('components.tom-select', ['options' => $countries,'value' => $data['country_id'],'field' => 'country_id','isMultiple' => false,'immediateUpdate' => true,'required' => true,'label' => translateText('Country', lang_admin()),'placeholder' => ''.e(translateText('Select Country', lang_admin())).'','uniqueKey' => 'country_id']);

$__html = app('livewire')->mount($__name, $__params, 'lw-2046737994-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                            </div>

                            <div class="col-md-4 mb-3">
                                <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('components.tom-select', ['options' => $states,'value' => $data['state_id'],'field' => 'state_id','isMultiple' => false,'immediateUpdate' => true,'required' => true,'label' => translateText('State', lang_admin()),'placeholder' => ''.e(translateText('Select State', lang_admin())).'','disabled' => !count($states),'uniqueKey' => 'state_id']);

$__html = app('livewire')->mount($__name, $__params, 'lw-2046737994-1', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                            </div>

                            <div class="col-md-4 mb-3">
                                <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('components.tom-select', ['options' => $cities,'value' => $data['city_id'],'field' => 'city_id','isMultiple' => false,'immediateUpdate' => true,'required' => true,'label' => translateText('City', lang_admin()),'placeholder' => ''.e(translateText('Select City', lang_admin())).'','disabled' => !count($cities),'uniqueKey' => 'city_id']);

$__html = app('livewire')->mount($__name, $__params, 'lw-2046737994-2', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label><?php echo e(translateText('Street', lang_admin())); ?> <span class="text-danger">*</span></label>
                                <input class="form-control" wire:model="data.street" type="text">
                            </div>

                            <div class="col-md-6 mb-3">
                                <label><?php echo e(translateText('Post Code', lang_admin())); ?> <span class="text-danger">*</span></label>
                                <input class="form-control" wire:model="data.post_code" type="number">
                            </div>
                            <div class="col-md-12 mb-3">
                                <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('components.tom-select', ['options' => $time_zone,'value' => $data['time_zone'],'field' => 'time_zone','isMultiple' => false,'immediateUpdate' => false,'required' => true,'label' => translateText('Time Zone', lang_admin()),'placeholder' => ''.e(translateText('Select Time Zone', lang_admin())).'','uniqueKey' => 'time_zone']);

$__html = app('livewire')->mount($__name, $__params, 'lw-2046737994-3', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                            </div>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" @click="isOpen = false">
                            Close
                        </button>
                        <button type="submit" class="btn btn-primary">
                            Save
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div
            class="modal-backdrop fade"
            :class="{ 'show': isOpen }"
            x-show="isOpen"
    ></div>
</div><?php /**PATH /home/nexpo/public_html/new/source/resources/views/livewire/dashboard/company/company-office/create.blade.php ENDPATH**/ ?>