
<?php $__env->startSection('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(url('assets/front/new/css/selectize.css')); ?>" />
    <style>
        .selectize-input{
            background-color: white;
            transition: background-color 0.5s ease, border 0.5s ease;
        }
        .selectize-input:hover{
            background-color: white;
            border: black solid 1px;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('body'); ?>
    <!--Login Register section start-->
    <div class="container my-5">
        <div class="mainexpo-reg-form-container">
            <div class="mrf-left-panel">
                <img src="<?php echo e(url('assets/front/new/images/register-back.webp')); ?>" alt="Mainexpo Welcome Background"
                     class="mrf-welcome-image-background">
                <div class="mrf-left-panel-overlay-content">
                    <div id="mrf-left-panel-step1-2-content" class="mrf-left-panel-text ">
                        <h1><?php echo e(read_lang($about,'title')); ?></h1>
                        <?php echo read_lang($about,'text'); ?>

                    </div>
                    <div id="mrf-left-panel-step3-content" class="mrf-left-panel-text">
                        <h2><?php echo e(read_lang($about,'title1')); ?></h2>
                        <?php echo read_lang($about,'text1'); ?>

                    </div>
                </div>
            </div>

            <div class="mrf-right-panel">
                <div id="mrf-step-1" class="mrf-form-step">
                    <h2>Create an account</h2>
                    <form id="mrf-form-step-1">
                        <?php echo csrf_field(); ?>
                        <div class="mrf-form-group mb-3">
                            <label for="mrf-email" class="form-label">Email address: <span class="mrf-required">*</span></label>
                            <input type="email" class="form-control" id="mrf-email" name="email" required>
                        </div>
                        <div class="mrf-form-check form-check mb-3">
                            <input type="checkbox" class="form-check-input" id="mrf-agree-terms" name="agree-terms"
                                   required>
                            <label class="form-check-label" for="mrf-agree-terms">I agree to the <a href="#">User
                                    Agreement</a> and
                                the <a href="#">Privacy Policy</a>.</label>
                        </div>
                        <button type="button" class="default-button w-100" id="verify-email-btn">Verify Email</button>
                    </form>
                    <p class="mrf-alternative-signin text-center mt-3">
                        <?php echo e(read_lang_word('already-have-an-account')); ?> <a
                                href="<?php echo e(route('front.loginnew')); ?>"><?php echo e(read_lang_word('sign-in')); ?></a>
                        <br>
                        <?php echo e(read_lang_word('or-sign-in-with')); ?>:
                    </p>
                    <div class="mrf-social-login d-flex justify-content-center gap-2 mt-2">
                        <a href="#" class="mlp-social-btn"><img src="<?php echo e(url('assets/front/new/images/google.png')); ?>"
                                                                alt="Google"></a>
                        <a href="#" class="mlp-social-btn"><img src="<?php echo e(url('assets/front/new/images/facebook.png')); ?>"
                                                                alt="Facebook"></a>
                        <a href="#" class="mlp-social-btn"><img src="<?php echo e(url('assets/front/new/images/linkedin.png')); ?>"
                                                                alt="LinkedIn"></a>
                        <a href="#" class="mlp-social-btn"><img src="<?php echo e(url('assets/front/new/images/twiter.png')); ?>"
                                                                alt="X"></a>
                    </div>
                </div>

                <div id="mrf-step-2" class="mrf-form-step">
                    <div class="mrf-verify-email-popup text-center">
                        <button class="mrf-close-btn btn-close float-end" onclick="mrfClosePopupAndGoToStep(1)"
                                aria-label="Close"></button>
                        <h3 class="mb-3 text-center">Verify your email</h3>
                        <p>A verification code has been sent to your email <strong
                                    id="mrf-user-email-display">your.email@example.com</strong>.</p>
                        <form id="mrf-form-step-2" class="mt-3">
                            <?php echo csrf_field(); ?>
                            <div class="mrf-verification-code-inputs d-flex justify-content-center gap-2 mb-3">
                                <input type="text" class="form-control text-center" maxlength="1" pattern="[0-9]" required>
                                <input type="text" class="form-control text-center" maxlength="1" pattern="[0-9]" required>
                                <input type="text" class="form-control text-center" maxlength="1" pattern="[0-9]" required>
                                <input type="text" class="form-control text-center" maxlength="1" pattern="[0-9]" required>
                            </div>
                            <a href="#" class="mrf-resend-link d-block mb-3" id="resend-code-btn">Resend code</a>
                            <button type="button" class="default-button w-100" id="verify-code-btn">Verify Code</button>
                        </form>
                        <p class="mrf-info-note mt-3">* Please check your Inbox and Spam folder.</p>
                    </div>
                </div>

                <div id="mrf-step-3" class="mrf-form-step">
                    <h2 class="mb-4">Complete Your Information</h2>
                    <form action="<?php echo e(route('front.register.end')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" id="mrf-verified-email" name="email" value="<?php echo e(session('verified_email')); ?>">

                        <input type="hidden" id="role_id" name="role_id" value="2">

                        <ul class="nav nav-tabs nav-fill mb-3" id="userTypeTab" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="buyer-tab" data-bs-toggle="tab"
                                        data-bs-target="#buyer-fields-tabpane" type="button" role="tab"
                                        aria-controls="buyer-fields-tabpane"
                                        aria-selected="true" onclick="document.getElementById('role_id').value = '2'">Buyer
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="supplier-tab" data-bs-toggle="tab"
                                        data-bs-target="#supplier-fields-tabpane" type="button" role="tab"
                                        aria-controls="supplier-fields-tabpane"
                                        aria-selected="false" onclick="document.getElementById('role_id').value = '3'">Supplier/Service Provider
                                </button>
                            </li>
                        </ul>

                        <div class="tab-content" id="userTypeTabContent">
                            <div class="tab-pane fade show active" id="buyer-fields-tabpane" role="tabpanel"
                                 aria-labelledby="buyer-tab">
                                <div id="mrf-buyer-fields">
                                    <div class="mrf-form-group mb-3">
                                        <label for="mrf-company-name-buyer" class="form-label">Company Name:</label>
                                        <input type="text" class="form-control" id="mrf-company-name-buyer"
                                               name="company_name1">
                                        <div class="form-check mt-1">
                                            <input class="form-check-input" type="checkbox" id="mrf-private-buyer"
                                                   name="private_buyer">
                                            <label class="form-check-label" for="mrf-private-buyer">Private
                                                buyer</label>
                                        </div>
                                        <small class="mrf-field-note form-text text-muted">If "Private buyer" is
                                            selected, Company Name is
                                            optional.</small>
                                    </div>
                                    <div class="mrf-form-group mb-3">
                                        <label for="mrf-products-needed-buyer" class="form-label">Products you need:
                                            <span
                                                    class="mrf-required">*</span></label>
                                        <input type="text" class="form-control keywords" id="mrf-products-needed-buyer"
                                               name="products_needed" placeholder="(e.g., Rice, Shoes)">
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="supplier-fields-tabpane" role="tabpanel"
                                 aria-labelledby="supplier-tab">
                                <div id="mrf-supplier-fields">
                                    <div class="mrf-form-group mb-3">
                                        <label for="mrf-company-name-supplier" class="form-label">Company Name: <span
                                                    class="mrf-required">*</span></label>
                                        <input type="text" class="form-control" id="mrf-company-name-supplier"
                                               name="company_name2">
                                    </div>

                                    <div class="mrf-form-group mb-3">
                                        <label for="mrf-products-supplier" class="form-label">Products you
                                            offer:</label>
                                        <input type="text" class="form-control keywords" id="mrf-products-supplier"
                                               name="products_supplier"
                                               placeholder="(e.g., Textiles, Machinery)">
                                    </div>
                                    <div class="mrf-form-group mb-3">
                                        <label for="mrf-services-supplier" class="form-label">Services you
                                            provide:</label>
                                        <input type="text" class="form-control keywords" id="mrf-services-supplier"
                                               name="services_supplier"
                                               placeholder="(e.g., Logistics, Consulting)">
                                    </div>
                                    <small class="mrf-field-note form-text text-muted">Specify products if you are a
                                        supplier, services
                                        if you are a service provider, or both.</small>
                                </div>
                            </div>
                        </div>
                        <div class="mrf-form-group mb-3">
                            <label for="mrf-full-name-supplier" class="form-label">Full Name: <span
                                        class="mrf-required">*</span></label>
                            <input type="text" class="form-control" id="mrf-full-name-supplier"
                                   name="name">
                        </div>
                        <div class="mrf-form-group mb-3 mt-3">
                            <label for="mrf-country" class="form-label">Country: <span
                                        class="mrf-required">*</span></label>
                            <select class="form-select form-control" id="mrf-country" name="country" required>
                                <option selected disabled value="">Select Country</option>
                                <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($country->id); ?>"><?php echo e($country->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="mrf-form-group mb-3">
                            <label for="mrf-password" class="form-label">Password: <span
                                        class="mrf-required">*</span></label>
                            <input type="password" class="form-control" id="mrf-password" name="password"
                                   placeholder="6-20 characters" required>
                        </div>
                        <div class="mrf-form-group mb-3">
                            <label for="mrf-mobile-number" class="form-label">Mobile Number: <span
                                        class="mrf-required">*</span></label>
                            <input type="tel" class="form-control" id="mrf-mobile-number" name="mobile_number" required>
                        </div>

                        <button type="submit" class="default-button w-100 mt-3">Submit</button>
                    </form>
                    <p class="mrf-info-note mt-3">
                        <?php echo read_lang($about,'text2'); ?>

                    </p>
                </div>
            </div>
        </div>
    </div>
    <!--Login Register section end-->
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(url('assets/front/new/js/selectize.js')); ?>" defer></script>
    <script>
        document.querySelector('form').addEventListener('submit', function() {
            const activeTab = document.querySelector('.nav-link.active').id;
            if(activeTab === 'supplier-tab') {
                document.getElementById('role_id').value = '3';
            } else {
                document.getElementById('role_id').value = '2';
            }
        });
        document.addEventListener('DOMContentLoaded', function () {


            const selectize = $(".keywords").selectize({
                delimiter: ",",
                plugins: {
                    remove_button: {
                        label: "×"
                    }
                },
                persist: false,
                createOnBlur: true,
                create: true,
                copyClassesToDropdown: false,
            });

            const urlParams = new URLSearchParams(window.location.search);
            const step = urlParams.get('step');

            if (step === '3' && !sessionStorage.getItem('step3Loaded')) {
                mrfGoToStep(3);
                sessionStorage.setItem('step3Loaded', 'true');
            }
            const inputs = document.querySelectorAll('.mrf-verification-code-inputs input');
            inputs.forEach((input, index) => {
                input.addEventListener('input', () => {
                    if (input.value.length === 1 && index < inputs.length - 1) {
                        inputs[index + 1].focus();
                    }
                });
                input.addEventListener('keydown', (e) => {
                    if (e.key === 'Backspace' && input.value.length === 0 && index > 0) {
                        inputs[index - 1].focus();
                    }
                });
            });



            document.getElementById('verify-email-btn').addEventListener('click', function () {
                const form = document.getElementById('mrf-form-step-1');
                const email = document.getElementById('mrf-email').value;
                const agreeTerms = document.getElementById('mrf-agree-terms').checked;

                if (!email || !agreeTerms) {
                    Swal.fire({
                        title: "<?php echo e(read_lang_word('unsuccessful')); ?>",
                        text: "<?php echo e(read_lang_word('please-fill-required-fields')); ?>",
                        icon: "error",
                        timer: 6000,
                        timerProgressBar: true,
                    });
                    return;
                }

                const formData = new FormData(form);
                formData.append('email', email);
                formData.append('agree-terms', agreeTerms ? 'on' : '');

                fetch('<?php echo e(route("front.verify.email")); ?>', {
                    method: 'POST',
                    body: formData,
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'Accept': 'application/json',
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                    }
                })
                    .then(response => response.json())
                    .then(data => {
                        if (data.status === 'success') {
                            document.getElementById('mrf-user-email-display').textContent = email;
                            mrfGoToStep(2);
                            Swal.fire({
                                title: data.title,
                                text: data.msg,
                                icon: "success",
                                timer: 6000,
                                timerProgressBar: true,
                            });
                        } else {
                            Swal.fire({
                                title: data.title,
                                text: data.msg,
                                icon: "error",
                                timer: 6000,
                                timerProgressBar: true,
                            });
                        }
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        Swal.fire({
                            title: "<?php echo e(read_lang_word('unsuccessful')); ?>",
                            text: "<?php echo e(read_lang_word('server-error')); ?>",
                            icon: "error",
                            timer: 6000,
                            timerProgressBar: true,
                        });
                    });
            });


            document.getElementById('resend-code-btn').addEventListener('click', function (e) {
                e.preventDefault();
                const email = document.getElementById('mrf-email').value;
                const formData = new FormData();
                formData.append('_token', '<?php echo e(csrf_token()); ?>');
                formData.append('email', email);
                formData.append('agree-terms', 'on');

                fetch('<?php echo e(route("front.verify.email")); ?>', {
                    method: 'POST',
                    body: formData,
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'Accept': 'application/json'
                    }
                })
                    .then(response => response.json())
                    .then(data => {
                        Swal.fire({
                            title: data.title,
                            text: data.msg,
                            icon: data.status === 'success' ? "success" : "error",
                            timer: 6000,
                            timerProgressBar: true,
                        });
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        Swal.fire({
                            title: "<?php echo e(read_lang_word('unsuccessful')); ?>",
                            text: "<?php echo e(read_lang_word('server-error')); ?>",
                            icon: "error",
                            timer: 6000,
                            timerProgressBar: true,
                        });
                    });
            });

            document.getElementById('verify-code-btn').addEventListener('click', function () {
                const inputs = document.querySelectorAll('.mrf-verification-code-inputs input');
                const code = Array.from(inputs).map(input => input.value).join('');
                const email = document.getElementById('mrf-email').value;

                if (code.length !== 4) {
                    Swal.fire({
                        title: "<?php echo e(read_lang_word('unsuccessful')); ?>",
                        text: "<?php echo e(read_lang_word('please-enter-valid-code')); ?>",
                        icon: "error",
                        timer: 6000,
                        timerProgressBar: true,
                    });
                    return;
                }

                const formData = new FormData();
                formData.append('_token', '<?php echo e(csrf_token()); ?>');
                formData.append('email', email);
                formData.append('verify', code);

                fetch('<?php echo e(route("front.verify.code")); ?>', {
                    method: 'POST',
                    body: formData,
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'Accept': 'application/json'
                    }
                })
                    .then(response => response.json())
                    .then(data => {
                        if (data.status === 'success') {
                            mrfGoToStep(3);
                            Swal.fire({
                                title: data.title,
                                text: data.msg,
                                icon: "success",
                                timer: 6000,
                                timerProgressBar: true,
                            });
                        } else {
                            Swal.fire({
                                title: data.title,
                                text: data.msg,
                                icon: "error",
                                timer: 6000,
                                timerProgressBar: true,
                            });
                        }
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        Swal.fire({
                            title: "<?php echo e(read_lang_word('unsuccessful')); ?>",
                            text: "<?php echo e(read_lang_word('server-error')); ?>",
                            icon: "error",
                            timer: 6000,
                            timerProgressBar: true,
                        });
                    });
            });

            document.getElementById('mrf-form-step-3').addEventListener('submit', function (e) {
                e.preventDefault();
                const form = this;
                const formData = new FormData(form);

                const activeTab = document.querySelector('#userTypeTab .nav-link.active').id;
                const role = activeTab === 'buyer-tab' ? 'buyer' : 'supplier';
                formData.append('role_id', role);

                const password = document.getElementById('mrf-password').value;
                const mobileNumber = document.getElementById('mrf-mobile-number').value;
                const country = document.getElementById('mrf-country').value;
                let fullName = '';
                let companyName = '';
                let productsNeeded = '';
                let productsSupplier = '';
                let servicesSupplier = '';

                if (role === 'buyer') {
                    fullName = document.getElementById('mrf-full-name-buyer').value;
                    companyName = document.getElementById('mrf-company-name-buyer').value;
                    productsNeeded = document.getElementById('mrf-products-needed-buyer').value;
                    const isPrivateBuyer = document.getElementById('mrf-private-buyer').checked;

                    if (!fullName || !productsNeeded || (!isPrivateBuyer && !companyName) || !country || !password || !mobileNumber) {
                        Swal.fire({
                            title: "<?php echo e(read_lang_word('unsuccessful')); ?>",
                            text: "<?php echo e(read_lang_word('please-fill-required-fields')); ?>",
                            icon: "error",
                            timer: 6000,
                            timerProgressBar: true,
                        });
                        return;
                    }
                } else {
                    fullName = document.getElementById('mrf-full-name-supplier').value;
                    companyName = document.getElementById('mrf-company-name-supplier').value;
                    productsSupplier = document.getElementById('mrf-products-supplier').value;
                    servicesSupplier = document.getElementById('mrf-services-supplier').value;

                    if (!fullName || !companyName || (!productsSupplier && !servicesSupplier) || !country || !password || !mobileNumber) {
                        Swal.fire({
                            title: "<?php echo e(read_lang_word('unsuccessful')); ?>",
                            text: "<?php echo e(read_lang_word('please-fill-required-fields')); ?>",
                            icon: "error",
                            timer: 6000,
                            timerProgressBar: true,
                        });
                        return;
                    }
                }

                formData.append('name', fullName);
                formData.append('password_confirmation', password);
                formData.append('company_name', companyName);
                formData.append('mobile_phone', mobileNumber);
                formData.append('country', country);

                if (role === 'buyer') {
                    formData.append('products_needed', productsNeeded);
                } else {
                    formData.append('products_supplier', productsSupplier);
                    formData.append('services_supplier', servicesSupplier);
                }

                fetch('<?php echo e(route("front.register.end")); ?>', {
                    method: 'POST',
                    body: formData,
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'Accept': 'application/json',
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                    }
                })
                    .then(response => response.json())
                    .then(data => {
                        if (data.status === 'success') {
                            Swal.fire({
                                title: data.title,
                                text: data.msg,
                                icon: "success",
                                timer: 6000,
                                timerProgressBar: true,
                            }).then(() => {
                                window.location.href = data.url_redirect;
                            });
                        } else {
                            console.log( JSON.stringify(data.errors))
                            Swal.fire({
                                title: data.title,
                                text: data.msg || JSON.stringify(data.errors),
                                icon: "error",
                                timer: 6000,
                                timerProgressBar: true,
                            });
                        }
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        Swal.fire({
                            title: "<?php echo e(read_lang_word('unsuccessful')); ?>",
                            text: "<?php echo e(read_lang_word('server-error')); ?>",
                            icon: "error",
                            timer: 6000,
                            timerProgressBar: true,
                        });
                    });
            });

            function mrfGoToStep(step) {
                document.querySelectorAll('.mrf-form-step').forEach(stepDiv => stepDiv.style.display = 'none');
                document.getElementById(`mrf-step-${step}`).style.display = 'block';

                const leftPanelStep1_2 = document.getElementById('mrf-left-panel-step1-2-content');
                const leftPanelStep3 = document.getElementById('mrf-left-panel-step3-content');
                if (step === 3) {
                    leftPanelStep1_2.display = 'none';
                    leftPanelStep3.style.display = 'block';
                } else {
                    leftPanelStep1_2.display = 'block';
                    leftPanelStep3.style.display = 'none';
                }
            }

            document.querySelector('.mrf-close-btn').addEventListener('click', function () {
                fetch('<?php echo e(route("front.clear.mail")); ?>', {
                    method: 'POST',
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'Accept': 'application/json',
                        'X-CSRF-Token': '<?php echo e(csrf_token()); ?>'
                    }
                })
                    .then(response => response.json())
                    .then(data => {
                        mrfGoToStep(1);
                    });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('front.layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nexpo/public_html/new/source/resources/views/front/signup-new.blade.php ENDPATH**/ ?>