<div>
    <form wire:submit.prevent="submit" onkeydown="if(event.key === 'Enter') event.preventDefault();">
        <div class="mb-3">
            <label for="service" class="form-label"><?php echo e(read_lang_word('service')); ?></label>
            <div class="select-container">
                <select class="form-control" id="service" wire:model.change="selectedService" required>
                    <option selected value=""><?php echo e(read_lang_word('select-service').' *'); ?></option>
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $this->services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($service->id); ?>"><?php echo e(read_lang($service,'title')); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </select>
            </div>
            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['selectedService'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <div class="text-danger small"><?php echo e($message); ?></div>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
        </div>

        <div class="mb-3">
            <label for="sub-service" class="form-label"><?php echo e(read_lang_word('sub-service')); ?></label>
            <div class="select-container">
                <select class="form-control" id="sub-service"
                        wire:model="selectedSubService" <?php echo e(!$this->selectedService ? 'disabled' : ''); ?>>
                    <option selected value="selected"><?php echo e(read_lang_word('select-sub-service')); ?></option>
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $this->subServices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($sub->id); ?>"><?php echo e(read_lang($sub,'title')); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </select>
            </div>
            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['selectedSubService'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <div class="text-danger small"><?php echo e($message); ?></div>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
        </div>

        <div class="mb-3 form-check">
            <label for="verified-providers"
                   class="form-check-label"><?php echo e(read_lang_word('verified-service-providers')); ?></label>
            <input type="checkbox" class="form-check-input" id="verified-providers"
                   wire:model.defer="verifiedProviders">
            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['verifiedProviders'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <div class="text-danger small"><?php echo e($message); ?></div>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
        </div>

        <div class="mb-3" wire:ignore
             x-data="{
         keywordOptions: <?php echo \Illuminate\Support\Js::from($initialKeywords)->toHtml() ?>,
         init() {
             new TomSelect(this.$refs.keywordsInput, {
                 plugins: ['remove_button'],
                 create: true,
                 persist: false,
                 maxItems: 10,
                 delimiter: ',',
                 valueField: 'value',
                 labelField: 'text',
                 searchField: 'text',
                 options: this.keywordOptions.map(item => ({value: item, text: item})),
                 onChange: (value) => {
                     window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('serviceName', value.join(','));
                 },
                 onInitialize: function() {
                     this.setValue(window.Livewire.find('<?php echo e($_instance->getId()); ?>').serviceName.split(','));
                 }
             });
         }
     }">
            <label class="form-label"><?php echo e(read_lang_word('service-name-or-keywords')); ?></label>
            <select x-ref="keywordsInput" multiple></select>
            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['serviceName'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <div class="text-danger small"><?php echo e($message); ?></div>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
        </div>

        <div class="mb-4">
            <textarea class="form-control" rows="5" placeholder="<?php echo e(read_lang_word('service-description')); ?>"
                      wire:model.defer="serviceDescription"></textarea>
            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['serviceDescription'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <div class="text-danger small"><?php echo e($message); ?></div>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
        </div>

        <div class="form-buttons">
            <button type="submit" class="default-button"><?php echo e(read_lang_word('submit-form')); ?></button>
            <button type="button" class="default-button" wire:click="resetForm"><?php echo e(read_lang_word('reset')); ?></button>
        </div>
    </form>

    <?php $__env->startPush('styles'); ?>
        <script defer src="<?php echo e(url('assets/front/new/js/alpine.min.js')); ?>"></script>

        <!-- TomSelect -->
        <link href="<?php echo e(url('assets/front/new/css/tom_select.css')); ?>" rel="stylesheet">
        <script src="<?php echo e(url('assets/front/new/js/tom_select.min.js')); ?>"></script>
        <style>
            .ts-control, .ts-wrapper.single.input-active .ts-control{
                background-color: var(--grayBack);
                transition: background-color 0.5s ease, border 0.5s ease;
            }
            .ts-control:hover,
            .ts-wrapper.single.input-active:hover .ts-control {
                background-color: white;
                border: black solid 1px;
            }
            .ts-wrapper.multi .ts-control > div {
                background: #ffffff;
            }
        </style>
    <?php $__env->stopPush(); ?>

    <?php $__env->startPush('scripts'); ?>
        <script>
            const Toast = Swal.mixin({
                toast: true,
                position: "top-end",
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
                didOpen: (toast) => {
                    toast.onmouseenter = Swal.stopTimer;
                    toast.onmouseleave = Swal.resumeTimer;
                }
            });
            document.addEventListener('livewire:init', () => {
                Livewire.on('alert', (value) => {
                    Toast.fire({
                        icon: value['icon'],
                        title: value['title']
                    });
                });

                Livewire.on('resetPage', () => {
                    location.reload();
                });
            });

        </script>
    <?php $__env->stopPush(); ?>
</div><?php /**PATH /home/nexpo/public_html/new/source/resources/views/livewire/front/service/service-form.blade.php ENDPATH**/ ?>