<?php

namespace Cubes\Nestpay\Laravel;

use Illuminate\Support\Facades\Facade as BaseFacade;

class Facade extends BaseFacade
{
    protected static function getFacadeAccessor()
    {
        return 'nestpay';
    }

    public static function routes()
    {
        \Route::prefix('/nestpay')->group(function () {
            \Route::get('/confirm/{id}', 'App\Http\Controllers\NestpayController@confirment')->name('nestpay.confirment');
            \Route::post('/confirm/{id}', 'App\Http\Controllers\NestpayController@confirm')->name('nestpay.confirm');
            \Route::post('/success', 'App\Http\Controllers\NestpayController@success')->name('nestpay.success');
            \Route::post('/fail', 'App\Http\Controllers\NestpayController@fail')->name('nestpay.fail');
        });
    }
}