(function ($) {
    "use strict"; //data background

    $('[data-background]').each(function () {
        var $data_bg = $(this).attr('data-background');
        $(this).css({
            "background-image": 'url(' + $data_bg + ')'
        });
    }); //offcanvas function

    function offCanvus() {
        $(".ofcanvus-toggle").on("click", function () {
            $(".at_offcanvus_menu").addClass("active");
        });
        $(".at-offcanvus-close").on("click", function () {
            $(".at_offcanvus_menu").removeClass("active");
        });
        $(document).on("mouseup", function (e) {
            var offCanvusMenu = $(".at_offcanvus_menu");

            if (!offCanvusMenu.is(e.target) && offCanvusMenu.has(e.target).length === 0) {
                $(".at_offcanvus_menu").removeClass("active");
            }
        });
    }

    offCanvus(); //mobile menu

    $(".mobile-menu-toggle").on("click", function () {
        $(".mobile-menu").addClass("active");
    });
    $(".mobile-menu .close-menu").on("click", function () {
        $(".mobile-menu").removeClass("active");
    });
    $(".mobile-menu ul li.has-submenu a").each(function () {
        $(this).on("click", function () {
            $(this).siblings('ul').slideToggle();
            $(this).toggleClass("icon-rotate");
        });
    });
    $(document).on("mouseup", function (e) {
        var offCanvusMenu = $(".mobile-menu");

        if (!offCanvusMenu.is(e.target) && offCanvusMenu.has(e.target).length === 0) {
            $(".mobile-menu").removeClass("active");
        }
    }); //section scrolldown

    $(".btn-scroll-down").on("click", function () {
        $("html,body").animate({
            scrollTop: 600
        });
        return false;
    }); //scroll top animation

    $(".theme-scrolltop-btn").on("click", function () {
        $("body,html").animate({
            scrollTop: 0
        }, 1500, 'easeOutCubic');
    }); //counterup


    const at_hero_slider = new Swiper('.at-hero-slider-wrapper', {
        slidesPerView: 1,
        loop: true,
        spaceBetween: 0,
        autoplay: {
            delay: 5000
        },
        speed: 900,
        effect: 'fade',
        fadeEffect: {
            crossFade: true
        },
        navigation: {
            nextEl: '.flash1-button-next',
            prevEl: '.flash1-button-prev'
        }
    }); //add banner slider

    const ad_banner_slider = new Swiper(".banner-slider", {
        slidesPerView: 2,
        loop: false,
        spaceBetween: 24,
        autoplay: {
            delay: 4000
        },
        speed: 900,
        pagination: {
            el: '.swiper-pagination',
            type: 'bullets',
            clickable: true
        },
        breakpoints: {
            0: {
                slidesPerView: 1
            },
            576: {
                slidesPerView: 2
            },
            992: {
                slidesPerView: 3
            }
        }
    });
    const feedback_slider = new Swiper(".at_feedback_slider", {
        slidesPerView: 1,
        loop: true,
        spaceBetween: 24,
        autoplay: {
            delay: 5000
        },
        speed: 1500,
        navigation: {
            nextEl: '.slide-btn-next',
            prevEl: '.slide-btn-prev'
        }
    });
    const h2FeedbackSlider = new Swiper(".h2-feedback-slider", {
        slidesPerView: 2,
        loop: true,
        spaceBetween: 24,
        autoplay: {
            delay: 5000
        },
        speed: 1500,
        pagination: {
            el: '.swiper-pagination',
            type: 'bullets',
            clickable: true
        },
        breakpoints: {
            0: {
                slidesPerView: 1
            },
            992: {
                slidesPerView: 2
            }
        }
    });
    const carThumbSlider = new Swiper(".car-thumb-slider", {
        loop: true,
        spaceBetween: 24,
        slidesPerView: 3,
        freeMode: true,
        watchSlidesProgress: true,
        navigation: {
            nextEl: ".slider-button-next",
            prevEl: ".slider-button-prev"
        },
        breakpoints: {
            0: {
                slidesPerView: 2
            },
            576: {
                slidesPerView: 3
            },
            1200: {
                slidesPerView: 2
            },
            1400: {
                slidesPerView: 3
            }
        }
    });
    const carSlider = new Swiper(".car-slider", {
        loop: true,
        spaceBetween: 10,
        thumbs: {
            swiper: carThumbSlider
        }
    });
    const h3FeedbackControl = new Swiper(".h3-feedback-client-slider", {
        spaceBetween: 24,
        slidesPerView: 4,
        freeMode: true,
        watchSlidesProgress: true,
        breakpoints: {
            0: {
                slidesPerView: 1
            },
            768: {
                slidesPerView: 2
            },
            992: {
                slidesPerView: 3
            },
            1200: {
                slidesPerView: 4
            }
        }
    });
    const h3FeedbackSlider = new Swiper(".h3-feedback-slider", {
        loop: true,
        spaceBetween: 24,
        thumbs: {
            swiper: h3FeedbackControl
        }
    }); //Category Menu

    $(".category-toggle").on("click", function () {
        $(".product_category_nav").slideToggle();
    }); //custom scrollbar

    const h4_hero_slider = new Swiper(".h4-hero-slider", {
        slidesPerView: 1,
        loop: true,
        spaceBetween: 10,
        autoplay: true,
        speed: 1500,
        effect: 'fade',
        fadeEffect: {
            crossFade: true
        },
        pagination: {
            el: '.swiper-pagination',
            type: 'bullets',
            clickable: true
        }
    }); //Countdown

    $(".countdown-timer").each(function () {
        var $data_date = $(this).data('date');
        $(this).countdown({
            date: $data_date
        });
    });
    const flashSalesSlider = new Swiper(".flash-sales-slider", {
        slidesPerView: 4,
        spaceBetween: 24,
        loop: true,
        autoplay: true,
        speed: 1500,
        navigation: {
            nextEl: '.flash-button-next',
            prevEl: '.flash-button-prev'
        },
        breakpoints: {
            0: {
                slidesPerView: 1
            },
            576: {
                slidesPerView: 2
            },
            992: {
                slidesPerView: 3
            },
            1200: {
                slidesPerView: 4
            }
        }
    });
    const h4_ct_slider_1 = new Swiper(".h4_ct_slider_1", {
        slidesPerView: 3,
        spaceBetween: 10,
        loop: true,
        autoplay: true,
        speed: 1500,
        navigation: {
            nextEl: '.flash-button-next',
            prevEl: '.flash-button-prev'
        },
        breakpoints: {
            0: {
                slidesPerView: 1
            },
            400: {
                slidesPerView: 2
            },
            768: {
                slidesPerView: 3
            },
            992: {
                slidesPerView: 4
            },
            1200: {
                slidesPerView: 3
            }
        }
    });
    const top_suppliers = new Swiper(".top_suppliers", {
        slidesPerView: 2,
        spaceBetween: 0,
        loop: false,
        centerInsufficientSlides: true,
        autoplay: true,
        speed: 1500,
        navigation: {
            nextEl: '.sflash-button-next',
            prevEl: '.sflash-button-prev'
        },
        breakpoints: {
            0: {
                slidesPerView: 2
            },
            550: {
                slidesPerView: 3
            },
            992: {
                slidesPerView: 5
            },
            1200: {
                slidesPerView: 7
            },
            1400: {
                slidesPerView: 8
            }
        }
    });
    const s4_ct_slider_2 = new Swiper(".s4_ct_slider_2", {
        slidesPerView: 4,
        spaceBetween: 0,
        loop: false,
        autoplay: true,
        speed: 1500,
        navigation: {
            nextEl: '.sflash-button-next',
            prevEl: '.sflash-button-prev'
        },
        breakpoints: {
            0: {
                slidesPerView: 1
            },
            550: {
                slidesPerView: 2
            },
            992: {
                slidesPerView: 3
            },
            1200: {
                slidesPerView: 4
            }
        }
    });
    const s4_ct_slider_product = new Swiper(".s4_ct_slider_product", {
        slidesPerView: 6,
        spaceBetween: 0,
        loop: false,
        autoplay: true,
        speed: 1500,
        navigation: {
            nextEl: '.sflash-button-next',
            prevEl: '.sflash-button-prev'
        },
        breakpoints: {
            0: {
                slidesPerView: 2,
                slidesPerGroup:1,
            },
            550: {
                slidesPerView: 3,
                slidesPerGroup:1,
            },
            992: {
                slidesPerView: 4,
                slidesPerGroup:2,
            },
            1200: {
                slidesPerView: 5,
                slidesPerGroup:2,
            },
            1450: {
                slidesPerView: 6,
                slidesPerGroup:2,
            }
        }
    });

    const product_swiper = new Swiper(".product_swiper", {
        slidesPerView: 6,
        grid: {
            rows: 2,
        },
        spaceBetween: 0,
        loop: false,
        autoplay: true,
        speed: 1500,
        pagination: {
            el: ".swiper-pagination1",
            clickable: true,
        },
        breakpoints: {
            0: {
                slidesPerView: 2,
                slidesPerGroup:1,
            },
            550: {
                slidesPerView: 3,
                slidesPerGroup:1,
            },
            992: {
                slidesPerView: 4,
                slidesPerGroup:2,
            },
            1200: {
                slidesPerView: 5,
                slidesPerGroup:2,
            },
            1450: {
                slidesPerView: 6,
                slidesPerGroup:2,
            }
        }
    });
    const product_swiper2 = new Swiper(".product_swiper2", {
        slidesPerView: 6,
        spaceBetween: 0,
        loop: false,
        autoplay: true,
        speed: 1500,
        pagination: {
            el: ".swiper-pagination1",
            clickable: true,
        },
        breakpoints: {
            0: {
                slidesPerView: 2,
                slidesPerGroup:1,
            },
            550: {
                slidesPerView: 3,
                slidesPerGroup:1,
            },
            992: {
                slidesPerView: 4,
                slidesPerGroup:2,
            },
            1200: {
                slidesPerView: 5,
                slidesPerGroup:2,
            },
            1450: {
                slidesPerView: 6,
                slidesPerGroup:2,
            }
        }
    });
    const product_service_swiper = new Swiper(".product_service_swiper", {
        slidesPerView: 3,
        grid: {
            rows: 2,
        },
        spaceBetween: 0,
        loop: false,
        autoplay: true,
        speed: 1500,
        pagination: {
            el: ".swiper-pagination2",
            clickable: true,
        },
        breakpoints: {
            0: {
                slidesPerView: 1,
                slidesPerGroup:1,
            },
            550: {
                slidesPerView: 2,
                slidesPerGroup:1,
            },
            992: {
                slidesPerView: 3,
                slidesPerGroup:1,
            },
        }
    });
    const h4_ct_slider_2 = new Swiper(".h4_ct_slider_2", {
        slidesPerView: 4,
        spaceBetween: 0,
        loop: false,
        autoplay: true,
        speed: 1500,
        navigation: {
            nextEl: '.flash-button-next',
            prevEl: '.flash-button-prev'
        },
        breakpoints: {
            0: {
                slidesPerView: 1
            },
            550: {
                slidesPerView: 2
            },
            992: {
                slidesPerView: 3
            },
            1200: {
                slidesPerView: 4
            }
        }
    });
    const megaMenuSlider = new Swiper(".megamenu-slider", {
        slidesPerView: 1,
        spaceBetween: 16,
        autoplay: true,
        speed: 1500
    });
    const productThumbSlider = new Swiper(".product_thumb_slider", {
        loop: true,
        spaceBetween: 16,
        slidesPerView: 3,
        freeMode: true,
        watchSlidesProgress: true,
        navigation: {
            nextEl: ".slider-button-next",
            prevEl: ".slider-button-prev"
        },
        breakpoints: {
            0: {
                slidesPerView: 3
            },
            576: {
                slidesPerView: 3
            },
            1200: {
                slidesPerView: 2
            },
            1400: {
                slidesPerView: 4
            }
        }
    });
    const productViewSlider = new Swiper(".product_feature_img_slider", {
        loop: true,
        spaceBetween: 10,
        thumbs: {
            swiper: productThumbSlider
        }
    });
    const blogGridSlider = new Swiper(".blog-grid-slider", {
        slidesPerView: 1,
        autoplay: true,
        loop: true,
        spaceBetween: 10,
        pagination: {
            el: '.swiper-pagination',
            type: 'bullets',
            clickable: true
        }
    });
    const inventorySlider = new Swiper(".inventroy-slider", {
        slidesPerView: 4,
        autoplay: true,
        loop: true,
        spaceBetween: 24,
        navigation: {
            nextEl: ".slider-btn-next",
            prevEl: ".slider-btn-prev"
        },
        breakpoints: {
            0: {
                slidesPerView: 1
            },
            768: {
                slidesPerView: 2
            },
            992: {
                slidesPerView: 3
            },
            1400: {
                slidesPerView: 4
            }
        }
    });
    const ivThumbControlSlider = new Swiper(".iv_thumb_control_slider", {
        slidesPerView: 4,
        loop: true,
        spaceBetween: 24,
        breakpoints: {
            0: {
                slidesPerView: 3,
                spaceBetween: 16
            },
            992: {
                slidesPerView: 4,
                spaceBetween: 24
            }
        }
    });
    const ivThumbSlider = new Swiper(".iv_thumb_slider", {
        slidesPerView: 1,
        autoplay: true,
        loop: true,
        spaceBetween: 16,
        thumbs: {
            swiper: ivThumbControlSlider
        }
    });
    const shopProductslider = new Swiper(".shop-products-slider", {
        slidesPerView: 1,
        autoplay: true,
        loop: true,
        spaceBetween: 16,
        breakpoints: {
            0: {
                slidesPerView: 1
            },
            576: {
                slidesPerView: 2
            },
            992: {
                slidesPerView: 3
            },
            1200: {
                slidesPerView: 1
            }
        }
    });
    const productThumbSlider2 = new Swiper(".product_thumb_slider_2", {
        loop: true,
        spaceBetween: 16,
        slidesPerView: 3,
        freeMode: true,
        watchSlidesProgress: true,
        navigation: {
            nextEl: ".slider-button-next",
            prevEl: ".slider-button-prev"
        },
        breakpoints: {
            0: {
                slidesPerView: 3
            },
            576: {
                slidesPerView: 3
            },
            1200: {
                slidesPerView: 2
            },
            1400: {
                slidesPerView: 4
            }
        }
    });
    const productViewSlider2 = new Swiper(".product_feature_img_slider_2", {
        loop: true,
        spaceBetween: 10,
        thumbs: {
            swiper: productThumbSlider2
        }
    }); //dealer sidebar slider


    const rlProductSlider = new Swiper(".rl-products-slider", {
        slidesPerView: 4,
        spaceBetween: 24,
        loop: true,
        autoplay: true,
        navigation: {
            nextEl: '.slider-button-next',
            prevEl: '.slider-button-prev'
        },
        breakpoints: {
            0: {
                slidesPerView: 1
            },
            576: {
                slidesPerView: 2,
                spaceBetween: 16
            },
            992: {
                slidesPerView: 3,
                spaceBetween: 24
            },
            1400: {
                slidesPerView: 4
            }
        }
    });
    const dealerSlider = new Swiper(".dealership-slider", {
        loop: true,
        spaceBetween: 24,
        autoplay: true,
        slidesPerView: 3,
        pagination: {
            el: '.swiper-pagination',
            type: 'bullets',
            clickable: true
        },
        breakpoints: {
            0: {
                slidesPerView: 1,
                spaceBetween: 16
            },
            768: {
                slidesPerView: 2
            },
            992: {
                slidesPerView: 3
            },
            1400: {
                slidesPerView: 4
            }
        }
    }); //sr feedback slider

    const srFeedbackSlider = new Swiper(".sr-feedback-slider", {
        loop: true,
        spaceBetween: 24,
        autoplay: true,
        slidesPerView: 3,
        breakpoints: {
            0: {
                slidesPerView: 1,
                spaceBetween: 16
            },
            768: {
                slidesPerView: 2
            },
            1200: {
                slidesPerView: 3
            }
        }
    }); //dealership 2 brand slider

    const bannerSlider2 = new Swiper(".dl2-banner-slider", {
        loop: true,
        spaceBetween: 24,
        slidesPerView: 1,
        autoplay: true,
        speed: 1000,
        pagination: {
            el: '.swiper-pagination',
            type: 'bullets',
            clickable: true
        }
    });
    const dl2FeedbackSlider = new Swiper(".dl2-feedback-slider", {
        loop: true,
        spaceBetween: 24,
        autoplay: true,
        speed: 1000,
        breakpoints: {
            992: {
                slidesPerView: 2
            },
            1200: {
                slidesPerView: 1
            }
        }
    }); //content expand

    $(".iv-expand-btn").on("click", function (e) {
        e.preventDefault();
        $(".expanded-content").slideDown();
    });

    //theme file upload

    var file_upload = $(".file_upload");
    file_upload.children(".btn").on("click", function () {
        $(this).siblings('input').click();
    });
    file_upload.children('input').on("change", function () {
        var file_name = this.files[0].name;
        $(this).siblings(".file_name").text(file_name);
    });

    $(".car_listing_nav ul li a").each(function () {
        $(this).on("click", function (e) {
            e.preventDefault();
            var hashOffset = $(this.hash).offset().top - 100;
            $("body,html").animate({
                scrollTop: hashOffset
            }, 1000, 'easeOutCubic');
        });
    }); //shipping form slideToggle

    $(".alternate-shipping label").on("click", function () {
        if ($(this).children("input").is(":checked")) {
            $(".alternate-shipping-form").slideDown();
        } else {
            $(".alternate-shipping-form").slideUp();
        }
    });
    $(window).on('scroll', function () {
        //header sticky
        var scrollBar = $(this).scrollTop();

        if (scrollBar > 100) {
            $(".header-sticky").addClass("sticky-on");
        } else {
            $(".header-sticky").removeClass("sticky-on");
        } //theme scrolltop button


        if (scrollBar > 300) {
            $(".theme-scrolltop-btn").fadeIn();
        } else {
            $(".theme-scrolltop-btn").fadeOut();
        } //vertical listing menu


        var scrollBarPosition = $(window).scrollTop();
        $(".car_listing_nav ul li a").each(function () {
            var navOffset = $(this.hash).offset().top - 120;

            if (scrollBarPosition > navOffset) {
                $(this).parents("ul").find("a.active").removeClass("active");
                $(this).addClass("active");
            }
        });
    });
    $(window).on('load', function () {
        //preloader
        $(".ring-preloader").fadeOut();

        $(".collection-filter-controls button").each(function () {
            $(this).on("click", function () {
                $(this).parent().find("button.active").removeClass("active");
                $(this).addClass("active");
            });
        }); // filter grid 2

    });

    var option_pp = 0;
    $('.add_option').click(function () {
        var type = $(this).attr('data-type')
        var id = $(this).attr('data-id')
        var toman = parseInt($(this).attr('data-price-ir'))
        var o_price = parseInt($(this).attr('data-price'))
        var a_price = parseInt($(this).attr('data-all-price'))
        var a_price_ir = parseInt($(this).attr('data-all-price-ir'))
        var all_option = parseInt($(this).attr('data-all-option'));
        var prepayment = parseInt($(this).attr('data-prepayment'));
        var all_price = 0;
        var all_price_ir = 0;
        var pre_price = 0;
        var pre_price_ir = 0;
        if (type == 'one') {
            if ($('#option_val_' + id).is(':checked')) {
                $('#option_val_' + id).prop('checked', false)
                $(this).text('Add')
                $(this).removeClass('bg-danger')
                all_option -= o_price
            } else {
                $(this).text('Remove')
                $('#option_val_' + id).prop('checked', true)
                $(this).addClass('bg-danger')
                all_option += o_price
            }
        } else {
            var input_val = parseInt($('.option_input_' + id).val())
            if (type == 'plus') {
                $('.option_input_' + id).val(input_val + 1)
                if (!$('#option_val_' + id).is(':checked')) {
                    $('#option_val_' + id).prop('checked', true)
                }
                all_option += o_price;
            } else {
                if (parseInt(input_val) > 1) {
                    $('.option_input_' + id).val(input_val - 1)
                    all_option -= o_price;
                } else {
                    if (parseInt(input_val) > 0) {
                        $('.option_input_' + id).val(input_val - 1)
                        all_option -= o_price;
                    }
                    if ($('#option_val_' + id).is(':checked')) {
                        $('#option_val_' + id).prop('checked', false)
                    }
                }
            }
        }
        option_pp = all_option
        all_price = a_price + all_option
        all_price_ir = a_price_ir + (all_option * toman)
        if (prepayment > 0) {
            pre_price = Math.round((a_price + all_option) * prepayment / 100)
            pre_price_ir = pre_price * toman

            $('#pre_price').text(parseInt(pre_price))
            $('#pre_price_ir').text(parseInt(pre_price_ir))

            $('#pre_price').text(
                function (index, value) {
                    return value.replace(/\D/g, "").replace(/\B(?=(\d{3})+(?!\d))/g, ",");
                })
            $('#pre_price_ir').text(
                function (index, value) {
                    return value.replace(/\D/g, "").replace(/\B(?=(\d{3})+(?!\d))/g, ",");
                })
        }
        $('.add_option').attr('data-all-option', parseInt(all_option))
        $('#option_price').text(parseInt(all_option))
        $('#all_price').text(parseInt(all_price))
        $('#all_price_ir').text(parseInt(all_price_ir))


        $('#option_price').text(
            function (index, value) {
                return value.replace(/\D/g, "").replace(/\B(?=(\d{3})+(?!\d))/g, ",");
            })
        $('#all_price').text(
            function (index, value) {
                return value.replace(/\D/g, "").replace(/\B(?=(\d{3})+(?!\d))/g, ",");
            })
        $('#all_price_ir').text(
            function (index, value) {
                return value.replace(/\D/g, "").replace(/\B(?=(\d{3})+(?!\d))/g, ",");
            })

    })

    $('.pay_check_level').click(function () {
        var type = $(this).attr('data-id')
        $('.radio_pay').attr('checked', false)
        $('.pay_check_level').removeClass('checked')
        $('.pay_' + type).addClass('checked')
        $('#radio_' + type).attr('checked', true)
    })

    $('.en_input').on('keyup', function (event) {
        var arregex = /^[a-zA-Z0-9_ ]*$/;
        if (!arregex.test(event.key)) {
            $('.en_input').val("");
        }
    });
    $('.number_input').on('keyup', function (event) {
        var arregex = /^[0-9]*$/;
        if (!arregex.test(event.key)) {
            $('.number_input').val("");
        }
    });
    $('.modal_btn_click').click(function (event) {
        var title = $(this).attr('data-title');
        var url = $(this).attr('data-url');

        $('#CarMessageModalLabel').text(title)
        $('#CarMessageModalForm').attr('action', url)
    });
    $('#bimeh_checked_label').click(function () {
        var all_price = parseInt($(this).attr('data-all-price'))
        var all_price_not_bimeh = parseInt($(this).attr('data-all-price-bimeh'))
        var pre_price = $(this).attr('data-pre-price')
        var pre_price_not_bimeh_t = $(this).attr('data-pre-price-not-bimeh')
        var toman = parseInt($(this).attr('data-toman'))
        var prepayment = parseInt($(this).attr('data-prepayment'))
        if ($('#bimeh_checked').is(':checked')) {
            $('#all_price').text(all_price + option_pp)
            $('#pre_price').text(Math.round((all_price + option_pp) * prepayment / 100))
            // $('#pre_price').text(parseInt(pre_price))
            $('#all_price_ir').text((all_price + option_pp) * toman)
            // $('#pre_price_ir').text(parseInt(pre_price) * parseInt(toman))
            $('#pre_price_ir').text(Math.round(((all_price + option_pp) * prepayment / 100) * toman))

            $('.add_option').attr('data-all-price', all_price)
            $('.add_option').attr('data-all-price-ir', parseInt(all_price) * parseInt(toman))
        } else {
            $('#all_price').text(all_price_not_bimeh + option_pp)
            // $('#pre_price').text(parseInt(pre_price_not_bimeh_t))
            $('#pre_price').text(Math.round(((all_price_not_bimeh + option_pp) * prepayment / 100)))
            $('#all_price_ir').text((all_price_not_bimeh + option_pp) * toman)
            // $('#pre_price_ir').text(parseInt(pre_price_not_bimeh_t) * parseInt(toman))
            $('#pre_price_ir').text(Math.round(((all_price_not_bimeh + option_pp) * prepayment / 100) * toman))

            $('.add_option').attr('data-all-price', all_price_not_bimeh)
            $('.add_option').attr('data-all-price-ir', parseInt(all_price_not_bimeh) * parseInt(toman))
        }

        $('#all_price').text(
            function (index, value) {
                return value.replace(/\D/g, "").replace(/\B(?=(\d{3})+(?!\d))/g, ",");
            })
        $('#pre_price').text(
            function (index, value) {
                return value.replace(/\D/g, "").replace(/\B(?=(\d{3})+(?!\d))/g, ",");
            })
        $('#all_price_ir').text(
            function (index, value) {
                return value.replace(/\D/g, "").replace(/\B(?=(\d{3})+(?!\d))/g, ",");
            })
        $('#pre_price_ir').text(
            function (index, value) {
                return value.replace(/\D/g, "").replace(/\B(?=(\d{3})+(?!\d))/g, ",");
            })
    })

    $('#admin_pay_label').click(function () {
        if ($('#admin_pay_input').is(':checked')) {
            $('#admin_pay_type_tr').removeClass('d-none')
            if ($('#admin_pay_type2_input').is(':checked')) {
                $('#admin_pay_file_tr').removeClass('d-none')
            }
        } else {
            $('#admin_pay_type_tr').addClass('d-none')
            $('#admin_pay_file_tr').addClass('d-none')
        }
    })
    $('#admin_pay_type1_label').click(function () {
        if ($('#admin_pay_type1_input').is(':checked')) {
            $('#admin_pay_file_tr').addClass('d-none')
        }
    })
    $('#admin_pay_type2_label').click(function () {
        if ($('#admin_pay_type2_input').is(':checked')) {
            $('#admin_pay_file_tr').removeClass('d-none')
        }
    })
})(window.jQuery);


jQuery(document).ready(function ($) {

    if (window.history && window.history.pushState) {

        window.history.pushState('forward', null, null);

        $(window).on('popstate', function () {
            $('.ring-preloader').css('display', 'flex')
            window.location.replace(document.referrer);
        });
    }
});

function myFunctionPrint() {


    window.print();

    window.open('', '_parent', '');

    window.close();

}

$('.open_filter').click(function () {
    if ($('.ul_category_product').hasClass('open')) {
        $('.ul_category_product').removeClass('open')
        $(this).removeClass('bg-danger')
        $('.ul_category_product_filter').removeClass('fa-close')
        $('.ul_category_product_filter').addClass('fa-filter')
    } else {
        $('.ul_category_product').addClass('open')
        $('.ul_category_product_filter').removeClass('fa-filter')
        $(this).addClass('bg-danger')
        $('.ul_category_product_filter').addClass('fa-close')
    }
})

// انتخاب تمامی آیتم‌های dropdown
const dropdownItems = document.querySelectorAll('.dropdown-menu-search');
const selectedCategoryInput = document.getElementById('selectedCategory');
const dropdownToggle = document.querySelector('.dropdown-toggle-search');
// افزودن رویداد کلیک به هر آیتم
dropdownItems.forEach(item => {
    item.addEventListener('click', function (e) {
        e.preventDefault(); // جلوگیری از رفتار پیش‌فرض لینک
        const selectedValue = this.getAttribute('data-value'); // دریافت مقدار data-value
        const selectedText = this.textContent; // دریافت متن انتخاب‌شده
        // به‌روزرسانی مقدار فیلد مخفی
        selectedCategoryInput.value = selectedValue;
        // به‌روزرسانی متن دکمه dropdown
        dropdownToggle.textContent = selectedText;
    });
});

$('#level2_next').click(function () {
    $('.loading_full').removeClass('d-none')
    var email = $('#username').val()
    var url = $(this).attr('data-url') + '?email=' + email
    $.get(url, function (data, status) {
        if (data.status == 'success') {
            $('#username').prop('readonly', true)
            $('.level1').addClass('d-none')
            $('.level2').removeClass('d-none')
            $('.level2_3').removeClass('d-none')

            Swal.fire({
                title: data.title,
                text: data.msg,
                icon: "success",
                timer: 6000,
                timerProgressBar: true,
            })
        } else {
            Swal.fire({
                title: data.title,
                text: data.msg,
                icon: "warning",
                timer: 6000,
                timerProgressBar: true,
            })
        }
        $('.loading_full').addClass('d-none')
    })
})
$('#level2_resend').click(function () {
    $('.loading_full').removeClass('d-none')
    var email = $('#username').val()
    var url = $(this).attr('data-url') + '?email=' + email
    $.get(url, function (data, status) {
        if (data.status == 'success') {
            $('#username').prop('readonly', true)
            $('.level1').addClass('d-none')
            $('.level2').removeClass('d-none')
            $('.level2_3').removeClass('d-none')

            Swal.fire({
                title: data.title,
                text: data.msg,
                icon: "success",
                timer: 6000,
                timerProgressBar: true,
            })
        } else {
            Swal.fire({
                title: data.title,
                text: data.msg,
                icon: "warning",
                timer: 6000,
                timerProgressBar: true,
            })
        }
        $('.loading_full').addClass('d-none')
    })
})
$('#level3_next').click(function () {
    $('.loading_full').removeClass('d-none')
    var verify = $('#verify_code').val()
    var url = $(this).attr('data-url') + '?verify=' + verify
    $.get(url, function (data, status) {
        if (data.status == 'success') {
            $('.level1').addClass('d-none')
            $('.level2').addClass('d-none')
            $('.level2_3').removeClass('d-none')
            $('.level3').removeClass('d-none')

            Swal.fire({
                title: data.title,
                text: data.msg,
                icon: "success",
                timer: 6000,
                timerProgressBar: true,
            })
        } else {
            Swal.fire({
                title: data.title,
                text: data.msg,
                icon: "warning",
                timer: 6000,
                timerProgressBar: true,
            })
        }
        $('.loading_full').addClass('d-none')
    })
})
$('#level1_back').click(function () {
    $('.loading_full').removeClass('d-none')
    var url = $(this).attr('data-url')
    $.get(url, function (data, status) {
        if (data.status == 'success') {
            $('#username').val('')
            $('#verify_code').val('')
            $('#username').prop('readonly', false)
            $('.level1').removeClass('d-none')
            $('.level2').addClass('d-none')
            $('.level3').addClass('d-none')
            $('.level2_3').addClass('d-none')

            Swal.fire({
                title: data.title,
                text: data.msg,
                icon: "success",
                timer: 6000,
                timerProgressBar: true,
            })
        } else {
            Swal.fire({
                title: data.title,
                text: data.msg,
                icon: "warning",
                timer: 6000,
                timerProgressBar: true,
            })
        }
        $('.loading_full').addClass('d-none')
    })
})
$('#register_end').click(function () {
    $('.loading_full').removeClass('d-none')
    var name = $('#name').val()
    var password = $('#password').val()
    var password_confirmation = $('#password_confirmation').val()
    var url = $(this).attr('data-url') + '?name=' + name + '&password=' + password + '&password_confirmation=' + password_confirmation
    $.get(url, function (data, status) {
        if (data.status == 'success') {
            $('.level1').addClass('d-none')
            $('.level2').addClass('d-none')
            $('.level2_3').removeClass('d-none')
            $('.level3').removeClass('d-none')

            Swal.fire({
                title: data.title,
                text: data.msg,
                icon: "success",
                timer: 6000,
                timerProgressBar: true,
            })

            setTimeout(function () {
                window.location.href = data.url_redirect;
            }, 3000);
        } else if (data.status == 'error') {
            let errors = data.errors;
            let errorMessages = '';

            // نمایش خطاها در یک لیست
            $.each(errors, function (key, value) {
                errorMessages += `<li>${key + 1} + ${value}</li>`;
            });

            Swal.fire({
                title: data.title,
                html: `<ul>${errorMessages}</ul>`,
                icon: "error",
                timer: 6000,
                timerProgressBar: true,
            });
            $('.loading_full').addClass('d-none')
        } else {
            Swal.fire({
                title: data.title,
                text: data.msg,
                icon: "warning",
                timer: 6000,
                timerProgressBar: true,
            })
            $('.loading_full').addClass('d-none')
        }
    })
})

function alert_verify(title, msg) {
    Swal.fire({
        title: title,
        text: msg,
        icon: "warning",
        timer: 6000,
        timerProgressBar: true,
    })
}


var swiper_product = new Swiper(".mySwiperProduct", {
    spaceBetween: 10,
    slidesPerView: 4,
    freeMode: true,
    watchSlidesProgress: true,
});
var swiper_product2 = new Swiper(".mySwiperProduct2", {
    spaceBetween: 10,
    navigation: {
        nextEl: ".swiper-button-next.product-next",
        prevEl: ".swiper-button-prev.product-prev",
    },
    thumbs: {
        swiper: swiper_product,
    },
});


$('.collapse-panel').click(function (){
    if($(this).hasClass('active'))
    {
        $(this).removeClass('active')
    }
    else
    {
        $('.collapse-panel').removeClass('active')
        $(this).addClass('active')
    }
})

$('.phone_input').on('keyup', function () {
    var value = $(this).val();
    var valid = /^[0-9+]*$/.test(value);
    if (!valid)
        $(this).val(value.replace(/[^0-9+]/g, ''));
});

function chat_function(url)
{
    $('#loading').removeClass('d-none')
    $('#iframe_show').addClass('d-none')
    $.get(url, function (data, status) {
        if (data.status === 1)
        {
            $('#iframe').html(data.html)
            $('#chatModal').modal('show');
            setTimeout(function() {
                $('#loading').addClass('d-none')
                $('#iframe_show').removeClass('d-none')
            }, 4000);
        } else {
            Swal.fire({
                title: data.title,
                text: data.msg,
                icon: "warning",
                timer: 6000,
                timerProgressBar: true,
            })
        }
    })
}
let mrfCurrentStep = 1;
let mrfSteps, mrfEmailDisplayElement, mrfEmailInputElement, mrfLeftPanelStep12Content, mrfLeftPanelStep3Content;

function mrfUpdateLeftPanelContent(stepNumber) {
    if (mrfLeftPanelStep12Content && mrfLeftPanelStep3Content) {
        if (stepNumber === 1 || stepNumber === 2) {
            mrfLeftPanelStep12Content.classList.add('mrf-active');
            mrfLeftPanelStep3Content.classList.remove('mrf-active');
        } else if (stepNumber === 3) {
            mrfLeftPanelStep12Content.classList.remove('mrf-active');
            mrfLeftPanelStep3Content.classList.add('mrf-active');
        } else {
            mrfLeftPanelStep12Content.classList.remove('mrf-active');
            mrfLeftPanelStep3Content.classList.remove('mrf-active');
        }
    }
}

function mrfShowStep(stepNumber) {
    if (!mrfSteps) return;
    mrfSteps.forEach(step => step.classList.remove('mrf-active'));
    const nextStepElement = document.getElementById(`mrf-step-${stepNumber}`);
    if (nextStepElement) {
        nextStepElement.classList.add('mrf-active');
        mrfCurrentStep = stepNumber;
        mrfUpdateLeftPanelContent(stepNumber);
    }
}

window.mrfGoToStep = function(stepNumber) {
    if (mrfCurrentStep === 1 && stepNumber === 2) {
        const form1 = document.getElementById('mrf-form-step-1');
        if (!form1) return;
        if (!form1.checkValidity()) {
            form1.reportValidity();
            return;
        }
        if (mrfEmailInputElement && mrfEmailDisplayElement) {
            mrfEmailDisplayElement.textContent = mrfEmailInputElement.value;
        }
    } else if (mrfCurrentStep === 2 && stepNumber === 3) {
        const form2 = document.getElementById('mrf-form-step-2');
        if (!form2) return;
        let codeIsValid = true;
        const codeInputs = form2.querySelectorAll('.mrf-verification-code-inputs input');
        /*codeInputs.forEach(input => {
            if (!input.value.match(/^[0-9a-zA-Z]$/)) {
                codeIsValid = false;
                input.classList.add('is-invalid');
            } else {
                input.classList.remove('is-invalid');
            }
        });*/
        if (!codeIsValid) {
            return;
        }
    }
    mrfShowStep(stepNumber);
}

window.mrfClosePopupAndGoToStep = function(stepNumber) {
    mrfShowStep(stepNumber);
}

document.addEventListener('DOMContentLoaded', () => {
    if (document.querySelector('.mainexpo-reg-form-container')) {
        mrfSteps = document.querySelectorAll(".mainexpo-reg-form-container .mrf-form-step");
        mrfEmailDisplayElement = document.getElementById('mrf-user-email-display');
        mrfEmailInputElement = document.getElementById('mrf-email');
        mrfLeftPanelStep12Content = document.getElementById('mrf-left-panel-step1-2-content');
        mrfLeftPanelStep3Content = document.getElementById('mrf-left-panel-step3-content');

        mrfShowStep(1);

        const codeInputs = document.querySelectorAll('.mainexpo-reg-form-container .mrf-verification-code-inputs input');
        codeInputs.forEach((input, index) => {
            input.addEventListener('input', (e) => {
                if (e.target.value.length === 1 && index < codeInputs.length - 1) {
                    codeInputs[index + 1].focus();
                }
            });
            input.addEventListener('keydown', (e) => {
                if (e.key === 'Backspace' && e.target.value.length === 0 && index > 0) {
                    codeInputs[index - 1].focus();
                }
            });
        });

        const privateBuyerCheckbox = document.getElementById('mrf-private-buyer');
        const companyNameBuyerInput = document.getElementById('mrf-company-name-buyer');

        function mrfManageRequiredFieldsForTabs(activeTabId) {
            const buyerFieldsContainer = document.getElementById('mrf-buyer-fields');
            const supplierFieldsContainer = document.getElementById('mrf-supplier-fields');

            const setRequired = (container, isRequired) => {
                if (!container) {
                    return;
                }
                container.querySelectorAll('input[name], select[name], textarea[name]').forEach(input => {
                    if (input.id === 'mrf-full-name-buyer' || input.id === 'mrf-products-needed-buyer' ||
                        input.id === 'mrf-company-name-supplier' || input.id === 'mrf-full-name-supplier') {
                        input.required = isRequired;
                    }
                    if (input.id === 'mrf-company-name-buyer') {
                        if (privateBuyerCheckbox) {
                            input.required = isRequired && !privateBuyerCheckbox.checked;
                        } else if (isRequired) {
                            input.required = true;
                        }
                    }
                });
            };

            if (activeTabId === 'buyer-fields-tabpane') {
                setRequired(buyerFieldsContainer, true);
                setRequired(supplierFieldsContainer, false);
            } else if (activeTabId === 'supplier-fields-tabpane') {
                setRequired(buyerFieldsContainer, false);
                setRequired(supplierFieldsContainer, true);
            }
        }

        if (privateBuyerCheckbox && companyNameBuyerInput) {
            privateBuyerCheckbox.addEventListener('change', function() {
                companyNameBuyerInput.disabled = this.checked;
                const buyerTabActive = document.getElementById('buyer-tab')?.classList.contains('active');
                if (buyerTabActive) {
                    companyNameBuyerInput.required = !this.checked;
                }
                if (this.checked) {
                    companyNameBuyerInput.value = '';
                }
            });
            const initialBuyerTabActive = document.getElementById('buyer-tab')?.classList.contains('active');
            if (initialBuyerTabActive) {
                companyNameBuyerInput.required = !privateBuyerCheckbox.checked;
            } else {
                companyNameBuyerInput.required = false;
            }
        }

        const userTypeTabs = document.querySelectorAll('#userTypeTab button[data-bs-toggle="tab"]');
        userTypeTabs.forEach(tabEl => {
            tabEl.addEventListener('shown.bs.tab', event => {
                const activeTabPaneId = event.target.getAttribute('data-bs-target').substring(1);
                mrfManageRequiredFieldsForTabs(activeTabPaneId);
                if (privateBuyerCheckbox && companyNameBuyerInput) {
                    if (activeTabPaneId === 'buyer-fields-tabpane') {
                        companyNameBuyerInput.disabled = privateBuyerCheckbox.checked;
                        companyNameBuyerInput.required = !privateBuyerCheckbox.checked;
                    } else {
                        companyNameBuyerInput.disabled = true;
                        companyNameBuyerInput.required = false;
                    }
                }
            });
        });
        
        const initialActiveUserTypeTab = document.querySelector('#userTypeTab button[data-bs-toggle="tab"].active');
        if (initialActiveUserTypeTab) {
            mrfManageRequiredFieldsForTabs(initialActiveUserTypeTab.getAttribute('data-bs-target').substring(1));
        } else if (userTypeTabs.length > 0) {
             mrfManageRequiredFieldsForTabs('buyer-fields-tabpane');
        }


        const finalForm = document.getElementById('mrf-form-step-3');
        if (finalForm) {
            finalForm.addEventListener('submit', function(event) {
                event.preventDefault();
                if (!this.checkValidity()) {
                    this.reportValidity();
                    Array.from(this.elements).forEach(el => {
                        if (el.willValidate && !el.checkValidity()) {
                            el.classList.add('is-invalid');
                        } else if (el.willValidate) {
                            el.classList.remove('is-invalid');
                            el.classList.add('is-valid');
                        }
                    });
                    return;
                }
                alert('Form submitted successfully! (This is a demo message)');
            });
        }

        const phoneInputFieldReg = document.querySelector("#mrf-mobile-number");
        if (phoneInputFieldReg && window.intlTelInput) {
            const phoneInputReg = window.intlTelInput(phoneInputFieldReg, {
                initialCountry: "auto",
                geoIpLookup: callback => { fetch("https://ipinfo.io/json?token=YOUR_TOKEN").then(r => r.json()).then(d => callback(d.country)).catch(() => callback("us")); },
                utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.13/js/utils.js",
            });
        }
    }

    if (document.querySelector('.mlp-login-container')) {
        const passwordInput = document.getElementById('mlp-login-password');
        const passwordToggle = document.querySelector('.mlp-password-toggle');

        if (passwordInput && passwordToggle) {
            passwordToggle.addEventListener('click', function () {
                const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
                passwordInput.setAttribute('type', type);
                this.textContent = type === 'password' ? '👁️' : '👁️‍🗨️';
            });
        }

        const emailLoginTab = document.getElementById('email-login-tab');
        if (emailLoginTab) {
            emailLoginTab.addEventListener('shown.bs.tab', function (event) {
                document.getElementById('mlp-login-email')?.focus();
            });
        }

        const phoneLoginTab = document.getElementById('phone-login-tab');
        if (phoneLoginTab) {
            phoneLoginTab.addEventListener('shown.bs.tab', function (event) {
                document.getElementById('mlp-login-phone')?.focus();
            });
        }
        
        const phoneInputFieldLogin = document.querySelector("#mlp-login-phone");
        if (phoneInputFieldLogin && window.intlTelInput) {
            const phoneInputLogin = window.intlTelInput(phoneInputFieldLogin, {
                initialCountry: "auto",
                geoIpLookup: callback => { 
                    fetch("https://ipinfo.io/json?token=YOUR_IPINFO_TOKEN")
                        .then(r => r.json())
                        .then(d => callback(d.country))
                        .catch(() => callback("us")); 
                },
                utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.13/js/utils.js",
            });
        }
    }
});