/*================================ Header ==============================*/

const headerSection = document.querySelector("header");
const root = document.querySelector(":root");
function updateHeaderHeight() {
  root.style.setProperty("--headerHeight", headerSection.offsetHeight + "px");
}

window.addEventListener("load", updateHeaderHeight);
window.addEventListener("resize", updateHeaderHeight);

const closeBtn = document.querySelector(".close-top-header");
const headerTop = document.querySelector(".header-top-side");

closeBtn?.addEventListener("click", () => {
  headerTop?.classList.add("closed");
  root.style.setProperty("--headerHeight", headerSection.offsetHeight + "px");
});

/*================================ FAQ Accordion ==============================*/

const faqAccordion = document.querySelectorAll(".faq-item");

faqAccordion.forEach((element) => {
  element.addEventListener("click", openFAQAccordion);
});

function openFAQAccordion(event) {
  event.preventDefault();
  event.target.parentElement.classList.toggle("faq-item-open");
}

/*========================== Read More Description =========================*/

// For Open And Collapse Description
function moreOrLess(e) {
  let description = e.target.previousElementSibling;
  description.classList.toggle("all-description");
  // Change Button Text
  if (description.classList.contains("all-description")) {
    e.target.innerHTML = "نمایش کمتر";
  } else {
    e.target.innerHTML = "نمایش بیشتر";
  }
}

/*================================ Tooltip ==============================*/

const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]');
const tooltipList = [...tooltipTriggerList].map((tooltipTriggerEl) => new bootstrap.Tooltip(tooltipTriggerEl));

/*============================== File Input ==============================*/
document.querySelectorAll('input[type="file"]').forEach((input) => {
  const container = input.closest(".custom-file-upload");
  const fileNameSpan = container?.querySelector(".file-name");
  if (fileNameSpan) {
    input.addEventListener("change", () => {
      if (input.files.length === 0) {
        fileNameSpan.textContent = "No File Chosen";
      } else {
        const fileNames = Array.from(input.files).map((file) => file.name);
        fileNameSpan.textContent = fileNames.join(" | ");
      }
    });
  }
});

function toggleCustomInput() {
  const select = document.getElementById("productCategory");
  const customInput = document.getElementById("customCategory");

  if (select.value === "other") {
    customInput.style.display = "block";
  } else {
    customInput.style.display = "none";
  }
}

/*========================== Categories Accordion =========================*/

// Handle category accordion toggle icons
document.addEventListener("DOMContentLoaded", function () {
  // Handle main category toggles
  const categoryToggles = document.querySelectorAll(".category-toggle");
  categoryToggles.forEach((toggle) => {
    toggle.addEventListener("click", function () {
      const icon = this.querySelector(".toggle-icon");
      const isExpanded = this.getAttribute("aria-expanded") === "true";

      // Toggle icon rotation
      if (icon) {
        if (isExpanded) {
          icon.classList.remove("fa-plus");
          icon.classList.add("fa-minus");
        } else {
          icon.classList.remove("fa-minus");
          icon.classList.add("fa-plus");
        }
      }
    });
  });

  // Handle subcategory toggles
  const subcategoryToggles = document.querySelectorAll(".subcategory-toggle");
  subcategoryToggles.forEach((toggle) => {
    toggle.addEventListener("click", function () {
      const icon = this.querySelector("i");
      const targetId = this.getAttribute("data-bs-target");
      const targetElement = document.querySelector(targetId);

      if (targetElement && icon) {
        const isExpanded = targetElement.classList.contains("show");

        if (isExpanded) {
          icon.classList.remove("fa-minus");
          icon.classList.add("fa-plus");
        } else {
          icon.classList.remove("fa-plus");
          icon.classList.add("fa-minus");
        }
      }
    });
  });

  // Handle search functionality in subcategories
  const searchInputs = document.querySelectorAll(".search-box input");
  searchInputs.forEach((input) => {
    input.addEventListener("input", function () {
      const searchTerm = this.value.toLowerCase();
      const subcategoryItems = this.closest(".subcategory-content").querySelector(".subcategory-items");
      const items = subcategoryItems.querySelectorAll("li");

      items.forEach((item) => {
        const text = item.textContent.toLowerCase();
        if (text.includes(searchTerm)) {
          item.style.display = "block";
        } else {
          item.style.display = "none";
        }
      });
    });
  });

  // Handle Bootstrap collapse events for proper icon management
  const collapseElements = document.querySelectorAll(".collapse");
  collapseElements.forEach((element) => {
    element.addEventListener("shown.bs.collapse", function () {
      const toggle = document.querySelector(`[data-bs-target="#${this.id}"]`);
      if (toggle) {
        const icon = toggle.querySelector("i, .toggle-icon");
        if (icon) {
          icon.classList.remove("fa-plus");
          icon.classList.add("fa-minus");
        }
      }
    });

    element.addEventListener("hidden.bs.collapse", function () {
      const toggle = document.querySelector(`[data-bs-target="#${this.id}"]`);
      if (toggle) {
        const icon = toggle.querySelector("i, .toggle-icon");
        if (icon) {
          icon.classList.remove("fa-minus");
          icon.classList.add("fa-plus");
        }
      }
    });
  });
});

/*================================ Scroll Up ==============================*/

const scrollButton = document.getElementById("scrollToTop");

scrollButton.onclick = () => {
  document.body.scrollTop = 0;
  document.documentElement.scrollTop = 0;
};
window.onscroll = () => {
  if (document.body.scrollTop > 20 || document.documentElement.scrollTop > 20) {
    headerSection.classList.add("header-scroll");
    scrollButton.style.visibility = "visible";
    scrollButton.style.opacity = "1";
  } else {
    headerSection.classList.remove("header-scroll");
    scrollButton.style.visibility = "hidden";
    scrollButton.style.opacity = "0";
  }
};

/*================================ Mobile Menu Accordion ==============================*/

const mobileNavigationAccordion = document.querySelectorAll(".mobile-navigation-accordion-button");

mobileNavigationAccordion.forEach((element) => {
  element.addEventListener("click", openAccordion);
});

function openAccordion(event) {
  event.preventDefault();
  event.target.parentElement.parentElement.classList.toggle("open-mobile-navigation-accordion");
}

/*================================= Counter Box =================================*/

// For Count The Numbers Of Counter Boxes
if (document.querySelectorAll(".counter-value").length) {
  const targetElement = document.querySelector(".counters-list");
  let isCounting = false;

  document.addEventListener("scroll", function (e) {
    const bounding = targetElement.getBoundingClientRect();

    if (bounding.top >= 0 && bounding.left >= 0 && bounding.right <= (window.innerWidth || document.documentElement.clientWidth) && bounding.bottom <= (window.innerHeight || document.documentElement.clientHeight)) {
      if (!isCounting) {
        // Select Elements
        const array = Array.from(document.querySelectorAll(".counter-value"));
        // Select Array Element
        array.map((item) => {
          let targetNumber = Number(item.textContent);
          let duration = 2000;
          let increment = targetNumber / (duration / 20); // 20ms is the interval step
          let currentNumber = 0;

          function counterUp() {
            currentNumber += increment;
            if (currentNumber >= targetNumber) {
              item.textContent = targetNumber;
              clearInterval(stop);
            } else {
              item.textContent = Math.floor(currentNumber);
            }
          }
          // Update every 20ms
          const stop = setInterval(counterUp, 20);
        });
        isCounting = true;
      }
    }
  });
}
document.addEventListener("DOMContentLoaded", function () {
  document.querySelectorAll(".default-button").forEach(function (btn) {
    const originalText = btn.textContent.trim();
    const hoverText = btn.getAttribute("hover-txt");
    if (hoverText) {
      btn.addEventListener("mouseenter", function () {
        btn.textContent = hoverText;
      });

      btn.addEventListener("mouseleave", function () {
        btn.textContent = originalText;
      });
    }
  });
});
/**========================================================================
 *                                     FancyBox
 *========================================================================**/

function switchTab(e) {
  document.querySelectorAll(".tab-pane").forEach((e) => {
    e.classList.remove("show", "active");
  });
  const t = document.getElementById(e);
  t && t.classList.add("show", "active");
}

/*================================ Footer ==============================*/

document.querySelectorAll(".footer-heading").forEach((heading) => {
  heading.addEventListener("click", () => {
    const dropdown = heading.nextElementSibling;
    if (dropdown) {
      dropdown.style.display = dropdown.style.display === "block" ? "none" : "block";
    }
  });
});

/*================================ Grid Or List View ==============================*/

document.addEventListener("DOMContentLoaded", function () {
  const viewToggleButtons = document.querySelectorAll(".view-toggle button");
  const productsContainer = document.getElementById("products-container");

  if (window.innerWidth <= 600) {
    viewToggleButtons.forEach((button) => {
      button.disabled = true;
    });
    productsContainer.classList.add("products-list");
    productsContainer.classList.remove("products-grid");
    return;
  }

  viewToggleButtons.forEach((button) => {
    button.addEventListener("click", function () {
      if (window.innerWidth <= 600) {
        return;
      }

      if (this.classList.contains("active")) {
        return;
      }

      viewToggleButtons.forEach((btn) => {
        btn.classList.remove("active");
      });
      this.classList.add("active");

      const view = this.dataset.view;

      if (view === "list") {
        productsContainer.classList.remove("products-grid");
        productsContainer.classList.add("products-list");
      } else {
        productsContainer.classList.remove("products-list");
        productsContainer.classList.add("products-grid");
      }
    });
  });
});

/*================================ Login Register ==============================*/

let mrfCurrentStep = 1;
let mrfSteps, mrfEmailDisplayElement, mrfEmailInputElement, mrfLeftPanelStep12Content, mrfLeftPanelStep3Content;

function mrfUpdateLeftPanelContent(stepNumber) {
  if (mrfLeftPanelStep12Content && mrfLeftPanelStep3Content) {
    if (stepNumber === 1 || stepNumber === 2) {
      mrfLeftPanelStep12Content.classList.add("mrf-active");
      mrfLeftPanelStep3Content.classList.remove("mrf-active");
    } else if (stepNumber === 3) {
      mrfLeftPanelStep12Content.classList.remove("mrf-active");
      mrfLeftPanelStep3Content.classList.add("mrf-active");
    } else {
      mrfLeftPanelStep12Content.classList.remove("mrf-active");
      mrfLeftPanelStep3Content.classList.remove("mrf-active");
    }
  }
}

function mrfShowStep(stepNumber) {
  if (!mrfSteps) return;
  mrfSteps.forEach((step) => step.classList.remove("mrf-active"));
  const nextStepElement = document.getElementById(`mrf-step-${stepNumber}`);
  if (nextStepElement) {
    nextStepElement.classList.add("mrf-active");
    mrfCurrentStep = stepNumber;
    mrfUpdateLeftPanelContent(stepNumber);
  }
}

window.mrfGoToStep = function (stepNumber) {
  if (mrfCurrentStep === 1 && stepNumber === 2) {
    const form1 = document.getElementById("mrf-form-step-1");
    if (!form1) return;
    if (!form1.checkValidity()) {
      form1.reportValidity();
      return;
    }
    if (mrfEmailInputElement && mrfEmailDisplayElement) {
      mrfEmailDisplayElement.textContent = mrfEmailInputElement.value;
    }
  } else if (mrfCurrentStep === 2 && stepNumber === 3) {
    const form2 = document.getElementById("mrf-form-step-2");
    if (!form2) return;
    let codeIsValid = true;
    const codeInputs = form2.querySelectorAll(".mrf-verification-code-inputs input");
    codeInputs.forEach((input) => {
      if (!input.value.match(/^[0-9a-zA-Z]$/)) {
        codeIsValid = false;
        input.classList.add("is-invalid");
      } else {
        input.classList.remove("is-invalid");
      }
    });
    if (!codeIsValid) {
      return;
    }
  }
  mrfShowStep(stepNumber);
};

window.mrfClosePopupAndGoToStep = function (stepNumber) {
  mrfShowStep(stepNumber);
};

document.addEventListener("DOMContentLoaded", () => {
  if (document.querySelector(".mainexpo-reg-form-container")) {
    mrfSteps = document.querySelectorAll(".mainexpo-reg-form-container .mrf-form-step");
    mrfEmailDisplayElement = document.getElementById("mrf-user-email-display");
    mrfEmailInputElement = document.getElementById("mrf-email");
    mrfLeftPanelStep12Content = document.getElementById("mrf-left-panel-step1-2-content");
    mrfLeftPanelStep3Content = document.getElementById("mrf-left-panel-step3-content");

    mrfShowStep(1);

    const codeInputs = document.querySelectorAll(".mainexpo-reg-form-container .mrf-verification-code-inputs input");
    codeInputs.forEach((input, index) => {
      input.addEventListener("input", (e) => {
        if (e.target.value.length === 1 && index < codeInputs.length - 1) {
          codeInputs[index + 1].focus();
        }
      });
      input.addEventListener("keydown", (e) => {
        if (e.key === "Backspace" && e.target.value.length === 0 && index > 0) {
          codeInputs[index - 1].focus();
        }
      });
    });

    const privateBuyerCheckbox = document.getElementById("mrf-private-buyer");
    const companyNameBuyerInput = document.getElementById("mrf-company-name-buyer");

    function mrfManageRequiredFieldsForTabs(activeTabId) {
      const buyerFieldsContainer = document.getElementById("mrf-buyer-fields");
      const supplierFieldsContainer = document.getElementById("mrf-supplier-fields");

      const setRequired = (container, isRequired) => {
        if (!container) {
          return;
        }
        container.querySelectorAll("input[name], select[name], textarea[name]").forEach((input) => {
          if (input.id === "mrf-full-name-buyer" || input.id === "mrf-products-needed-buyer" || input.id === "mrf-company-name-supplier" || input.id === "mrf-full-name-supplier") {
            input.required = isRequired;
          }
          if (input.id === "mrf-company-name-buyer") {
            if (privateBuyerCheckbox) {
              input.required = isRequired && !privateBuyerCheckbox.checked;
            } else if (isRequired) {
              input.required = true;
            }
          }
        });
      };

      if (activeTabId === "buyer-fields-tabpane") {
        setRequired(buyerFieldsContainer, true);
        setRequired(supplierFieldsContainer, false);
      } else if (activeTabId === "supplier-fields-tabpane") {
        setRequired(buyerFieldsContainer, false);
        setRequired(supplierFieldsContainer, true);
      }
    }

    if (privateBuyerCheckbox && companyNameBuyerInput) {
      privateBuyerCheckbox.addEventListener("change", function () {
        companyNameBuyerInput.disabled = this.checked;
        const buyerTabActive = document.getElementById("buyer-tab")?.classList.contains("active");
        if (buyerTabActive) {
          companyNameBuyerInput.required = !this.checked;
        }
        if (this.checked) {
          companyNameBuyerInput.value = "";
        }
      });
      const initialBuyerTabActive = document.getElementById("buyer-tab")?.classList.contains("active");
      if (initialBuyerTabActive) {
        companyNameBuyerInput.required = !privateBuyerCheckbox.checked;
      } else {
        companyNameBuyerInput.required = false;
      }
    }

    const userTypeTabs = document.querySelectorAll('#userTypeTab button[data-bs-toggle="tab"]');
    userTypeTabs.forEach((tabEl) => {
      tabEl.addEventListener("shown.bs.tab", (event) => {
        const activeTabPaneId = event.target.getAttribute("data-bs-target").substring(1);
        mrfManageRequiredFieldsForTabs(activeTabPaneId);
        if (privateBuyerCheckbox && companyNameBuyerInput) {
          if (activeTabPaneId === "buyer-fields-tabpane") {
            companyNameBuyerInput.disabled = privateBuyerCheckbox.checked;
            companyNameBuyerInput.required = !privateBuyerCheckbox.checked;
          } else {
            companyNameBuyerInput.disabled = true;
            companyNameBuyerInput.required = false;
          }
        }
      });
    });

    const initialActiveUserTypeTab = document.querySelector('#userTypeTab button[data-bs-toggle="tab"].active');
    if (initialActiveUserTypeTab) {
      mrfManageRequiredFieldsForTabs(initialActiveUserTypeTab.getAttribute("data-bs-target").substring(1));
    } else if (userTypeTabs.length > 0) {
      mrfManageRequiredFieldsForTabs("buyer-fields-tabpane");
    }

    const finalForm = document.getElementById("mrf-form-step-3");
    if (finalForm) {
      finalForm.addEventListener("submit", function (event) {
        event.preventDefault();
        if (!this.checkValidity()) {
          this.reportValidity();
          Array.from(this.elements).forEach((el) => {
            if (el.willValidate && !el.checkValidity()) {
              el.classList.add("is-invalid");
            } else if (el.willValidate) {
              el.classList.remove("is-invalid");
              el.classList.add("is-valid");
            }
          });
          return;
        }
        alert("Form submitted successfully! (This is a demo message)");
      });
    }

    const phoneInputFieldReg = document.querySelector("#mrf-mobile-number");
    if (phoneInputFieldReg && window.intlTelInput) {
      const phoneInputReg = window.intlTelInput(phoneInputFieldReg, {
        initialCountry: "auto",
        geoIpLookup: (callback) => {
          fetch("https://ipinfo.io/json?token=YOUR_TOKEN")
            .then((r) => r.json())
            .then((d) => callback(d.country))
            .catch(() => callback("us"));
        },
        utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.13/js/utils.js",
      });
    }
  }

  if (document.querySelector(".mlp-login-container")) {
    const passwordInput = document.getElementById("mlp-login-password");
    const passwordToggle = document.querySelector(".mlp-password-toggle");

    if (passwordInput && passwordToggle) {
      passwordToggle.addEventListener("click", function () {
        const type = passwordInput.getAttribute("type") === "password" ? "text" : "password";
        passwordInput.setAttribute("type", type);
        this.textContent = type === "password" ? "👁️" : "👁️‍🗨️";
      });
    }

    const emailLoginTab = document.getElementById("email-login-tab");
    if (emailLoginTab) {
      emailLoginTab.addEventListener("shown.bs.tab", function (event) {
        document.getElementById("mlp-login-email")?.focus();
      });
    }

    const phoneLoginTab = document.getElementById("phone-login-tab");
    if (phoneLoginTab) {
      phoneLoginTab.addEventListener("shown.bs.tab", function (event) {
        document.getElementById("mlp-login-phone")?.focus();
      });
    }

    const phoneInputFieldLogin = document.querySelector("#mlp-login-phone");
    if (phoneInputFieldLogin && window.intlTelInput) {
      const phoneInputLogin = window.intlTelInput(phoneInputFieldLogin, {
        initialCountry: "auto",
        geoIpLookup: (callback) => {
          fetch("https://ipinfo.io/json?token=YOUR_IPINFO_TOKEN")
            .then((r) => r.json())
            .then((d) => callback(d.country))
            .catch(() => callback("us"));
        },
        utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.13/js/utils.js",
      });
    }
  }
});
