<?php

use Illuminate\Support\Str;
use Illuminate\Support\Carbon;
use Illuminate\Support\HtmlString;
use Illuminate\Container\Container;
use Illuminate\Contracts\Bus\Dispatcher;
use Illuminate\Contracts\Auth\Access\Gate;
use Illuminate\Contracts\Routing\UrlGenerator;
use Illuminate\Foundation\Bus\PendingDispatch;
use Illuminate\Contracts\Debug\ExceptionHandler;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Contracts\Auth\Factory as AuthFactory;
use Illuminate\Contracts\View\Factory as ViewFactory;
use Illuminate\Contracts\Cookie\Factory as CookieFactory;
use Symfony\Component\Debug\Exception\FatalThrowableError;
use Illuminate\Database\Eloquent\Factory as EloquentFactory;
use Illuminate\Contracts\Validation\Factory as ValidationFactory;
use Illuminate\Contracts\Broadcasting\Factory as BroadcastFactory;
use Illuminate\Support\Facades\File;


if (!function_exists('fetchLinkMeta')) {
    function fetchLinkMeta($url) {
        try {
            $html = file_get_contents($url);

            $meta = [
                'title' => '',
                'description' => '',
                'image' => '',
                'url' => $url
            ];

            // استخراج عنوان
            if (preg_match('/<title>(.*?)<\/title>/', $html, $matches)) {
                $meta['title'] = $matches[1];
            }

            // استخراج توضیحات متا
            if (preg_match('/<meta.*?name="description".*?content="(.*?)".*?>/', $html, $matches)) {
                $meta['description'] = $matches[1];
            }

            // استخراج تصویر
            if (preg_match('/<meta.*?property="og:image".*?content="(.*?)".*?>/', $html, $matches)) {
                $meta['image'] = $matches[1];
            }

            return $meta;
        } catch (Exception $e) {
            return null;
        }
    }
}
if (!function_exists('url_check')) {
    function url_check($date)
    {
        $regex = "((https?|ftp)\:\/\/)?"; // SCHEME
        $regex .= "([a-z0-9+!*(),;?&=\$_.-]+(\:[a-z0-9+!*(),;?&=\$_.-]+)?@)?"; // User and Pass
        $regex .= "([a-z0-9-.]*)\.([a-z]{2,3})"; // Host or IP
        $regex .= "(\:[0-9]{2,5})?"; // Port
        $regex .= "(\/([a-z0-9+\$_-]\.?)+)*\/?"; // Path
        $regex .= "(\?[a-z+&\$_.-][a-z0-9;:@&%=+\/\$_.-]*)?"; // GET Query
        $regex .= "(#[a-z_.-][a-z0-9+\$_.-]*)?"; // Anchor

        if(preg_match("/^$regex$/i", $date))
            return true;

        return false;
    }
}
if (!function_exists('diff_day_date')) {
    function diff_day_date($date)
    {
        $start=Carbon::parse($date)->format('Ymd');
        $end=Carbon::now()->format('Ymd');


        return (int)$end-$start;
    }
}
if (!function_exists('array_pluck')) {
    function array_pluck($items, $value, $title, $defult = null)
    {
        $r = [];
        if ($defult != null) {
            $r = [$defult[0] => $defult[1]];
        }

        $r += Arr::pluck($items, $value, $title);
        return $r;

    }
}


if (!function_exists('j2g')) {
    function j2g($date)
    {
        $ymd=str_replace('-','/',$date);
        $ymd=explode('/',$ymd);
        require_once('../jdf.php');
        if (count($ymd)==3){
            $jalali_date = jalali_to_gregorian($ymd[0],$ymd[1],$ymd[2]);
            return implode('-',$jalali_date);
        }
    }
}
if (!function_exists('g2j')) {
    function g2j($date, $type)
    {
        $timestamp = (strtotime($date));
        require_once('../jdf.php');
        $jalali_date = jdate($type, $timestamp);
        return $jalali_date;
    }
}


if (! function_exists('isMobile')) {
    function isMobile()
    {
        return preg_match("/(android|avantgo|blackberry|bolt|boost|cricket|docomo|fone|hiptop|mini|mobi|palm|phone|pie|tablet|up\.browser|up\.link|webos|wos)/i", $_SERVER["HTTP_USER_AGENT"]);
    }
}

if (!function_exists('file_store')) {
    function file_store($u_file, $u_path, $u_prefix)
    {
        $file = $u_file;
        $originalName = $u_file->getClientOriginalName();
        $destinationPath = $u_path;
        $extension = $file->getClientOriginalExtension();
        $fileName = $u_prefix . md5(time() . '-' . $originalName) . '.' . $extension;
        $file->move($destinationPath, $fileName);
        $f_path = $destinationPath . "" . $fileName;
        return $f_path;
    }
}
