<?php

namespace App\Http\Livewire\Chat;

use App\Events\MessageSent2;
use App\Events\MessageRead;
use App\Models\ConversationMessage;
use App\Models\User;
use App\Models\Conversation;
use Livewire\Component;

class Chatbox extends Component
{
    public $selectConversation;
    public $receiverInstance;
    public $messages_count;
    public $messages;
    public $paginateVAr=10;
    public $height=10;

//    protected $listeners=['loadConversation','pushMessage','loadMore','updateHeight'];


    public function getListeners()
    {
        $auth_id=auth()->user()->id;
        return [
            "echo-private:user-chat.{$auth_id},MessageSent2"=>'broadcastedMessageReceived',
            "echo-private:user-chat.{$auth_id},MessageRead"=>'broadcastedMessageRead',
            'loadConversation','pushMessage','loadMore','updateHeight','broadcastMessageRead','resetComponent'
        ];
    }

    public function resetComponent()
    {
        $this->selectConversation=null;
        $this->receiverInstance=null;
    }

    function broadcastedMessageRead($event)
    {
        if($this->selectConversation)
        {
            if((int) $this->selectConversation->id == (int) $event['conversation_id'])
            {
                $this->dispatchBrowserEvent('markMessageAsRead');
            }
        }
    }

    function broadcastedMessageReceived($event)
    {
        $this->emitTo('chat.chatlist','refresh');

        $broadcastedMessage = ConversationMessage::find($event['message_id']);
        if ($this->selectConversation)
        {
            $this->dispatchBrowserEvent('mp3Play');
            if((int) $this->selectConversation->id === (int) $event['conversation_id'])
            {
                $broadcastedMessage->read=1;
                $broadcastedMessage->save();

                $this->pushMessage($broadcastedMessage->id);

                $this->emitSelf('broadcastMessageRead');
            }
        }
    }

    public function broadcastMessageRead()
    {
        broadcast(new MessageRead($this->selectConversation->id,$this->receiverInstance->id));
    }

    public function pushMessage($messageId)
    {
        $newMessage=ConversationMessage::find($messageId);
        $this->messages->push($newMessage);

        $this->dispatchBrowserEvent('rowChatToBottom');
    }

    function loadMore()
    {
        $this->paginateVAr=$this->paginateVAr + 10;

        $this->messages_count=ConversationMessage::where('conversation_id',$this->selectConversation->id)->count();
        $this->messages=ConversationMessage::where('conversation_id',$this->selectConversation->id)
            ->skip($this->messages_count - $this->paginateVAr)
            ->take($this->paginateVAr)->orderBy('id')->get();

        $height=$this->height;
        $this->dispatchBrowserEvent('updateHeight',($height));
    }
    function updateHeight($height)
    {
        $this->height=$height;
    }

    public function loadConversation(Conversation $conversation,User $receiver)
    {
        $this->selectConversation=$conversation;
        $this->receiverInstance=$receiver;

        $this->messages_count=ConversationMessage::where('conversation_id',$this->selectConversation->id)->count();
        $this->messages=ConversationMessage::where('conversation_id',$this->selectConversation->id)
            ->skip($this->messages_count - $this->paginateVAr)
            ->take($this->paginateVAr)->orderBy('id')->get();

        $this->dispatchBrowserEvent('chatSelected');

        ConversationMessage::where('conversation_id',$this->selectConversation->id)
            ->where('receiver_id',auth()->id())->update(['read'=>1]);

        $this->emitSelf('broadcastMessageRead');
    }
    public function render()
    {
        return view('livewire.chat.chatbox');
    }
}
