<?php

namespace App\Http\Livewire\Chat;

use App\Models\Conversation;
use App\Models\User;
use Livewire\Component;

class Chatlist extends Component
{
    public $auth_id;
    public $conversations;
    public $receiverInstance;
    public $name;
    public $selectConversation;

    protected $listeners=['chatUserSelected','chatUserSelected2','refresh'=>'$refresh','resetComponent'];

    public function resetComponent()
    {
        $this->selectConversation=null;
        $this->receiverInstance=null;
    }

    public function chatUserSelected(Conversation $conversation,$receiver_id)
    {
        $this->selectConversation=$conversation;

        $receiverInstance=User::find($receiver_id);

        $this->emitTo('chat.chatbox','loadConversation',$this->selectConversation,$receiverInstance);

        $this->emitTo('chat.send-message','updateSendMessage',$this->selectConversation,$receiverInstance);
    }
    public function chatUserSelected2($sender_id,$receiver_id)
    {
        $conversation=Conversation::where('sender_id',$sender_id)->where('receiver_id',$receiver_id)->orWhere('sender_id',$receiver_id)->where('receiver_id',$sender_id)->first();
        $this->selectConversation=$conversation;

        $receiverInstance=User::find($receiver_id);


        $this->emitTo('chat.chatbox','loadConversation',$this->selectConversation,$receiverInstance);

        $this->emitTo('chat.send-message','updateSendMessage',$this->selectConversation,$receiverInstance);
    }
    public function grtChatUserInstance(Conversation $conversation,$request)
    {
        $this->auth_id=auth()->id();
        if($conversation->sender_id == $this->auth_id)
        {
            $this->receiverInstance=User::firstWhere('id',$conversation->receiver_id);
        }
        else
        {
            $this->receiverInstance=User::firstWhere('id',$conversation->sender_id);
        }
        if(isset($request))
        {
            if($request == 'name_role')
            {
                $role=$this->receiverInstance->role();
                return $this->receiverInstance->name."($role)";
            }
            elseif($request == 'profile')
            {
                if($this->receiverInstance->photo)
                    return $this->receiverInstance->photo->path;
                else
                    return null;
            }
            else
                return $this->receiverInstance->$request;
        }
    }
    public function mount()
    {
        $this->auth_id=auth()->id();
        $this->conversations=Conversation::where('sender_id',$this->auth_id)
            ->orWhere('receiver_id',$this->auth_id)
            ->orderByDesc('last_time_message')->get();
    }

    public function render()
    {
        return view('livewire.chat.chatlist');
    }
}
