<?php

namespace App\Http\Livewire\Chat;

use App\Events\MessageSent;
use App\Events\MessageSent2;
use App\Models\Conversation;
use App\Models\ConversationMessage;
use App\Models\User;
use Livewire\Component;
// others
use Livewire\WithPagination; // this

class SendMessage extends Component
{
    use WithPagination; // and this
    public $selectConversation;
    public $receiverInstance;
    public $body;
    public $body1;
    public $body_imoji;
    public $createdMessage;

    protected $listeners = ['updateSendMessage', 'dispatchMessageSent', 'resetComponent', 'getSoundRecord','getSoundDelete', 'getUploadFile', 'getImojiSet'];

    public function resetComponent()
    {
        $this->selectConversation = null;
        $this->receiverInstance = null;
    }

    function updateSendMessage(Conversation $conversation, User $receiver)
    {
        $this->selectConversation = $conversation;
        $this->receiverInstance = $receiver;
    }

    function getSoundRecord($body1)
    {
        $this->body1 = $body1;
        $end_body = str_replace(['https://chat.mainexpo.com.tr/', 'http://chat.mainexpo.com.tr/'], '', $body1);
        $this->dispatchBrowserEvent('sound_play', ($end_body));
    }
    function getSoundDelete()
    {
        if (!blank($this->body1)) {
            $this->reset('body1');
        }
    }

    function getUploadFile($file_url)
    {
        $this->createdMessage = ConversationMessage::create([
            'conversation_id' => $this->selectConversation->id,
            'sender_id' => auth()->id(),
            'receiver_id' => $this->receiverInstance->id,
            'body' => $file_url[0],
            'type' => $file_url[1],
        ]);

        $this->selectConversation->last_time_message = $this->createdMessage->created_at;
        $this->selectConversation->save();

        $this->emitTo('chat.chatbox', 'pushMessage', $this->createdMessage->id);
        $this->emitTo('chat.chatlist', 'refresh');

        if (!blank($this->body1)) {
            $this->reset('body1');
        }

        $this->reset('body');

        $this->emitSelf('dispatchMessageSent');
    }

    public function sendEmoji($emoji)
    {
        $this->dispatchBrowserEvent('emoji-added', ['emoji' => $emoji]);
//        $body=$this->body.' '.$emoji;
//        $this->body=$body;
    }
    public function sendMessage()
    {
        $type = 'text';
        if (blank($this->body) && blank($this->body1) && blank($this->body_imoji)) {
            return null;
        }
        if (blank($this->body) && blank($this->body1) && !blank($this->body_imoji)) {
            $this->body = $this->body_imoji;
        }
        if (!blank($this->body1)) {
            $this->body = $this->body1;
            $type = 'mp3';
        }
        $this->createdMessage = ConversationMessage::create([
            'conversation_id' => $this->selectConversation->id,
            'sender_id' => auth()->id(),
            'receiver_id' => $this->receiverInstance->id,
            'body' => $this->body,
            'type' => $type,
        ]);

        $this->selectConversation->last_time_message = $this->createdMessage->created_at;
        $this->selectConversation->save();

        $this->emitTo('chat.chatbox', 'pushMessage', $this->createdMessage->id);
        $this->emitTo('chat.chatlist', 'refresh');

        if (!blank($this->body1)) {
            $this->reset('body1');
        }
        $this->reset('body');

        $this->emitSelf('dispatchMessageSent');
    }

    public function dispatchMessageSent()
    {
        broadcast(new MessageSent2(Auth()->user(), $this->createdMessage, $this->selectConversation, $this->receiverInstance));
    }

    public function render()
    {
        return view('livewire.chat.send-message');
    }
}
