<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Conversation extends Model
{
    use HasFactory;
    protected $guarded = ['id', 'created_at', 'updated_at'];

    public function messages()
    {
        return $this->hasMany('App\Models\ConversationMessage', 'conversation_id');
    }
    public function messages_last()
    {
        return $this->hasOne('App\Models\ConversationMessage', 'conversation_id')->orderByDesc('id');
    }
    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function user_send()
    {
        return $this->belongsTo('App\Models\User', 'sender_id');
    }
    public function user_receiver()
    {
        return $this->belongsTo('App\Models\User', 'receiver_id');
    }
}
