<div>
    @if($selectConversation)
        <div class="chatbox_header">
            <div class="return">
                <i class="bi bi-arrow-left"></i>
            </div>
            <div class="img_container">
                @if($receiverInstance->photo)
                    <img src="https://mainexpo.com.tr/{{$receiverInstance->photo->path}}" data-fancybox="gallery{{$receiverInstance->photo->id}}" href="https://mainexpo.com.tr/{{$receiverInstance->photo->path}}" alt="">
                @else
                    <img src="https://ui-avatars.com/api/?name= {{$receiverInstance->name}}" alt="">
                @endif
            </div>
            <div class="name">
                {{$receiverInstance->name}} ({{$receiverInstance->role()}})
            </div>
            <div class="info">
                {{--                <div class="info_item">--}}
                {{--                    <i class="bi bi-telephone-fill"></i>--}}
                {{--                </div>--}}
                {{--                <div class="info_item">--}}
                {{--                    <i class="bi bi-image"></i>--}}
                {{--                </div>--}}
                {{--                <div class="info_item">--}}
                {{--                    <i class="bi bi-info-circle-fill"></i>--}}
                {{--                </div>--}}
            </div>
        </div>
        <div class="chatbox_body">
            @foreach($messages as $message)
                <div class="msg_body {{auth()->id() == $message->sender_id?'msg_body_me':'msg_body_receiver'}}"
                     style="width: 80%;max-width: 80%;max-width: max-content">
                    @if(url_check($message->body))
                        <p class="{{!preg_match('/^[^\x{600}-\x{6FF}]+$/u', str_replace("\\\\", "", $message->body))?'d-rtl':'d-ltr'}}">
                            @if($message->type=='mp3')
                                <audio controls src="{{$message->body}}"></audio>
                            @elseif($message->type=='video')
                                <video controls src="{{$message->body}}"></video>
                            @elseif($message->type=='pic')
                                <a data-fancybox="gallery_message_{{$message->id}}" href="{{$message->body}}"  class="text-info" target="_blank">
                                    <img src="{{$message->body}}">
                                </a>
                            @else
                                <a href="{{$message->body}}" class="text-info" target="_blank">{{$message->body}}</a>
                            @endif
                        </p>
                    @else
                        <p class="{{!preg_match('/^[^\x{600}-\x{6FF}]+$/u', str_replace("\\\\", "", $message->body))?'d-rtl':'d-ltr'}}">{{$message->body}}</p>
                    @endif
                    <div class="msg_body_footer">
                        <div class="date mt-2">
                            @if(diff_day_date($message->created_at) > 1)
                                {{--                                {{g2j($message->created_at->format('Y-m-d m: i a'),'Y/m/d H:i')}}--}}
                                {{$message->created_at->format('Y-m-d H:i')}}
                            @elseif(diff_day_date($message->created_at) > 0)
                                Yesterday
                                {{$message->created_at->format('H:i')}}
                            @else
                                Today
                                {{$message->created_at->format('H:i')}}
                            @endif
                        </div>
                        <div class="read">
                            @php
                                if($message->sender_id == auth()->id())
                                {
                                    if($message->read == 0)
                                        {
                                            echo '<i class="bi bi-check2 status-tick"></i>';
                                        }
                                    else
                                        {
                                            echo '<i class="bi bi-check2-all text-primary status-tick"></i>';
                                        }
                                }
                                else
                                    {
                                        echo '<i class="bi bi-check2 status-tick d-none"></i>';
                                    }
                            @endphp
                            {{--                            <i class="bi bi-check"></i>--}}
                        </div>
                    </div>
                </div>
            @endforeach
        </div>

        <script>
            $('.chatbox_body').scroll(function () {
                var top = $('.chatbox_body').scrollTop();

                if (top == 0) {
                    window.livewire.emit('loadMore')
                }
            })
        </script>
        <script>
            window.addEventListener('updateHeight', event => {
                let old = event.detail.height;
                let newHeight = $('.chatbox_body')[0].scrollHeight;
                let height = $('.chatbox_body').scrollTop(newHeight - old);

                window.livewire.emit('updateHeight', {
                    height: height,
                })
            })
        </script>
    @else
        <div class="col-11 mt-3 mx-auto alert alert-danger text-center">
            No Conversation Selected
        </div>

    @endif

    <script>
        window.addEventListener('rowChatToBottom', event => {
            $('.chatbox_body').scrollTop($('.chatbox_body')[0].scrollHeight);
        })
    </script>

    <script>
        $(document).on('click', '.return', function () {
            window.livewire.emit('resetComponent');
        })
    </script>
    <script>
        window.addEventListener('markMessageAsRead', event => {
            var value = document.querySelectorAll('.status-tick')
            if (value.array != undefined && value.array != null && value.array != '') {
                value.array.forEach(element, index => {
                    element.classList.remove('bi bi-check2')
                    element.classList.add('bi bi-check2-all', 'text-primary')
                });
            }
        })
    </script>
    <script>
        let music = new Audio('{{url('source/public/mp3/mp3.wav')}}');
        window.addEventListener('mp3Play', event => {
            music.play()
        })
    </script>

</div>
