<div>
    <div class="chatlist_header">
        <div class="title">
            {{auth()->user()->name}}
        </div>
        <div class="img_container">
            @if(auth()->user()->photo)
                <img src="https://mainexpo.com.tr/{{auth()->user()->photo->path}}" data-fancybox="gallery{{auth()->user()->photo->id}}" href="https://mainexpo.com.tr/{{auth()->user()->photo->path}}" alt="">
             @else
            <img src="https://ui-avatars.com/api/?background=0D8ABC&color=fff&name={{auth()->user()->name}}" alt="">
             @endif
        </div>
    </div>
    <div class="chatlist_body">
        @if(count($conversations) > 0)
            @foreach($conversations->sortByDesc('last_time_message') as $conversation)
                <div class="chat_list_item" wire:key="{{$conversation->id}}"
                     wire:click="$emit('chatUserSelected',{{$conversation}},{{$this->grtChatUserInstance($conversation,$name='id')}})">
                    <div class="chat_list_img_container">
                        @if($this->grtChatUserInstance($conversation,$name='profile'))
                            <img src="https://mainexpo.com.tr/{{$this->grtChatUserInstance($conversation,$name='profile')}}" data-fancybox="gallery_profile_rand{{rand(10000,99999)}}" href="https://mainexpo.com.tr/{{$this->grtChatUserInstance($conversation,$name='profile')}}" alt="">
                        @else
                        <img
                            src="https://ui-avatars.com/api/?name={{$this->grtChatUserInstance($conversation,$name='name')}}" alt="">
                        @endif
                    </div>
                    <div class="chat_list_info">
                        <div class="top_row">
                            <div class="list_username">
                                {{$this->grtChatUserInstance($conversation,$name='name_role')}}
                            </div>
                            <span class="date">{{count($conversation->messages)?$conversation->messages_last->created_at->shortAbsoluteDiffForHumans():''}}</span>
                        </div>
                        <div class="bottom_row">
                            <div class="message_body text-truncate @if(count($conversation->messages)) {{!preg_match('/^[^\x{600}-\x{6FF}]+$/u', str_replace("\\\\", "", $conversation->messages_last->body))?'d-rtl':'d-ltr'}} @endif">
                                @if(count($conversation->messages))
                                    @if(auth()->user()->id == $conversation->messages_last->sender_id)
                                        You:
                                    @endif
                                    @if($conversation->messages_last->type == 'text')
                                        {{$conversation->messages_last->body}}
                                    @else
                                        {{$conversation->messages_last->type}}
                                    @endif
                                @else
                                    'Not Message'
                                @endif
                            </div>

                            @php
                                if(count($conversation->messages->where('read',0)->where('receiver_id',auth()->id())))
                                    {
                                        echo '<div class="unread_count badge rounded-pill text-light bg-danger"> '
                                        . count($conversation->messages->where('read',0)->where('receiver_id',auth()->id())) .
                                        ' </div>';
                                    }
                            @endphp
                        </div>
                    </div>
                </div>
            @endforeach
                @if(session()->has('user_id1') && session()->has('user_id2'))
                    <script>
                        $(document).ready(function () {
                            window.livewire.emit('chatUserSelected2',{{session('user_id1')}},{{session('user_id2')}});
                        })
                    </script>
                @endif
        @else
            You Have No Conversations
        @endif
    </div>
</div>
