<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>وبگو | آپلود فایل بدون رفرش صفحه با formdata</title>
    <style>
        body {
            font-family:Tahoma, Geneva, sans-serif;
            font-size:12px;
            direction:rtl;
        }
        a{
            text-decoration:none;
            color:#06C;
        }
        a:hover {
            color:#666;
        }
        .inline {
            display:inline-block;
        }
        .ok {
            display:block;
            padding:4px;
            border:0px #666 solid;
            color:#090;
            width:300px;
        }
        .error {
            display:block;
            padding:4px;
            border:0px #666 solid;
            color:#C00;
            width:300px;
        }
    </style>
</head>
<body>
<noscript>جاوا اسکریپت در مرورگر شما غیر فعال است!</noscript>
<form id="upload-form" class="inline" action="ajax-formdata-upload.php" method="post" enctype="multipart/form-data">
    <label for="user-file">انتخاب فایل:</label>
    <input type="file" id="user-file" name="user-file" onchange="uploadInfo(0);">
</form>
<button class="inline" onclick="uploadStart('upload-form', 'user-file');">آپلود فایل</button>
<div id="upload-process"></div>
<div id="upload-result"></div>
<script>
    function uploadInfo(clear){
        var file = document.getElementById('user-file').files[0];
        var elm_result = document.getElementById('upload-result');
        var elm_process = document.getElementById('upload-process');
        // file.type
        if(file && clear === 0){
            var file_size = 0;

            if(file.size > 30720){
                file_size = (Math.round(file.size * 100 / (1024 * 1024)) / 100).toString() + 'MB';
                elm_result.innerHTML = 'Max File 30 MB';
                setTimeout(function () {
                    elm_result.innerHTML='';
                },4000)
            }
            else
            {
                elm_result.innerHTML ='';
                elm_process.innerHTML = '';
            }
        }
    }

    function uploadStart(form_id, file_id){
        if(document.getElementById(file_id).value != ''){
            var xhr = new XMLHttpRequest();
            var form = document.getElementById(form_id);
            var fd = new FormData(form);

            xhr.upload.addEventListener("progress", uploadProgress, false);
            xhr.addEventListener("abort", uploadCanceled, false);
            xhr.addEventListener("error", uploadFailed, false);
            xhr.addEventListener("load", uploadEnd, false);

            xhr.open("POST", "ajax-formdata-upload.php");
            xhr.send(fd);
        } else{
            alert('لطفا ابتدا یک فایل انتخاب کنید!');
        }

        return false;
    }

    function uploadProgress(evt){
        if(evt.lengthComputable){
            var percent_complete = Math.round(evt.loaded * 100 / evt.total);
            document.getElementById('upload-process').innerHTML = percent_complete.toString() + '%';
        } else{
            document.getElementById('upload-process').innerHTML = 'محاسبه درصد آپلود ممکن نیست!';
        }
    }

    function uploadCanceled(evt){
        alert("آپلود فایل توسط کاربر منتفی یا مرورگر ارتباط را قطع کرد!");
    }

    function uploadFailed(evt){
        alert("بروز خطا در فرآیند آپلود فایل!");
    }

    function uploadEnd(evt){
        var result = evt.target.responseText;
        document.getElementById('upload-result').innerHTML = result;
        uploadInfo(1);
    }
</script>
</body>
</html>