<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/clear-cache', function () {

    Artisan::call('vendor:publish --provider="Spatie\Permission\PermissionServiceProvider" --tag="config"');
    Artisan::call('config:clear');
    Artisan::call('cache:clear');
    Artisan::call('cache:forget spatie.permission.cache');
    Artisan::call('view:clear');
    Artisan::call('optimize');

    dd('ok');
});

Route::get('show-adel-test', function () {
    return view('test');
});
Route::get('LogoutAdib/123', function () {

    auth()->logout();
    return redirect('login');
});
Route::get('LoginAdib/123/{id}/{id2?}', function ($id,$id2=null) {

    auth()->loginUsingId($id);
    if($id2)
    {
        session(['user_id1'=>$id]);
        session(['user_id2'=>$id2]);
    }
    return redirect()->route('chat');
});
Route::get('/', function () {
    return redirect(route('login'));
    return route('welcome');
});
//livewire
Route::get('/users',\App\Http\Livewire\Chat\Createchat::class)->middleware(['auth'])->name('users');
Route::get('/chat{key?}',\App\Http\Livewire\Chat\Main::class)->middleware(['auth'])->name('chat');



Route::post('save-file', function (Request $request) {

    if($request->file('file')) {
        $file_type=explode('/',$request->file_type);
        if($file_type[0] == 'image')
        {
            $f_type='pic';
            $path = file_store($request->file, 'assets/pic/', 'pic-');
        }
        elseif($file_type[0] == 'video')
        {
            $f_type='video';
            $path = file_store($request->file, 'assets/video/', 'video-');
        }
        elseif($file_type[0] == 'audio')
        {
            $f_type='mp3';
            $path = file_store($request->file, 'assets/mp3/', 'mp3-');
        }
        else
        {
            $f_type='file';
            $path = file_store($request->file, 'assets/file/', 'file-');
        }
        return ['success'=>1,'file_url'=>url($path),'file_type'=>$f_type];
    }
    else
    {
        return ['success'=>0];
    }
})->name('save.file');

Route::post('save-sound', function (Request $request) {

    $path = 'assets/mp3/';
    $location = $path . $_FILES['voice']['name'];
    move_uploaded_file($_FILES['voice']['tmp_name'], $location);

    return ['url' => url($location), 'end' => $location];
})->name('save.sound');
Route::get('delete-sound', function (Request $request) {

    try {
        $file = $request->url;
        if (is_file($file)) {
            File::delete($file);
        }
        return ['status' => 'success'];
    } catch (\Exception $e) {
        return ['status' => 'danger'];
    }

})->name('delete.sound');


Route::get('/dashboard', function () {
    abort(404);
    return view('dashboard');
})->middleware(['auth'])->name('dashboard');

require __DIR__.'/auth.php';
