<div>
    <?php if($selectConversation): ?>
        <div class="chatbox_header">
            <div class="return">
                <i class="bi bi-arrow-left"></i>
            </div>
            <div class="img_container">
                <?php if($receiverInstance->photo): ?>
                    <img src="https://tooamerica.com/<?php echo e($receiverInstance->photo->path); ?>" data-fancybox="gallery<?php echo e($receiverInstance->photo->id); ?>" href="https://tooamerica.com/<?php echo e($receiverInstance->photo->path); ?>" alt="">
                <?php else: ?>
                    <img src="https://ui-avatars.com/api/?name= <?php echo e($receiverInstance->name); ?>" alt="">
                <?php endif; ?>
            </div>
            <div class="name">
                <?php echo e($receiverInstance->name); ?> (<?php echo e($receiverInstance->role()); ?>)
            </div>
            <div class="info">
                
                
                
                
                
                
                
                
                
            </div>
        </div>
        <div class="chatbox_body">
            <?php $__currentLoopData = $messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="msg_body <?php echo e(auth()->id() == $message->sender_id?'msg_body_me':'msg_body_receiver'); ?>"
                     style="width: 80%;max-width: 80%;max-width: max-content">
                    <?php if(url_check($message->body)): ?>
                        <p class="<?php echo e(!preg_match('/^[^\x{600}-\x{6FF}]+$/u', str_replace("\\\\", "", $message->body))?'d-rtl':'d-ltr'); ?>">
                            <?php if($message->type=='mp3'): ?>
                                <audio controls src="<?php echo e($message->body); ?>"></audio>
                            <?php elseif($message->type=='video'): ?>
                                <video controls src="<?php echo e($message->body); ?>"></video>
                            <?php elseif($message->type=='pic'): ?>
                                <a data-fancybox="gallery_message_<?php echo e($message->id); ?>" href="<?php echo e($message->body); ?>"  class="text-info" target="_blank">
                                    <img src="<?php echo e($message->body); ?>">
                                </a>
                            <?php else: ?>
                                <a href="<?php echo e($message->body); ?>" class="text-info" target="_blank"><?php echo e($message->body); ?></a>
                            <?php endif; ?>
                        </p>
                    <?php else: ?>
                        <p class="<?php echo e(!preg_match('/^[^\x{600}-\x{6FF}]+$/u', str_replace("\\\\", "", $message->body))?'d-rtl':'d-ltr'); ?>"><?php echo e($message->body); ?></p>
                    <?php endif; ?>
                    <div class="msg_body_footer">
                        <div class="date mt-2">
                            <?php if(diff_day_date($message->created_at) > 1): ?>
                                
                                <?php echo e($message->created_at->format('Y-m-d H:i')); ?>

                            <?php elseif(diff_day_date($message->created_at) > 0): ?>
                                Yesterday
                                <?php echo e($message->created_at->format('H:i')); ?>

                            <?php else: ?>
                                Today
                                <?php echo e($message->created_at->format('H:i')); ?>

                            <?php endif; ?>
                        </div>
                        <div class="read">
                            <?php
                                if($message->sender_id == auth()->id())
                                {
                                    if($message->read == 0)
                                        {
                                            echo '<i class="bi bi-check2 status-tick"></i>';
                                        }
                                    else
                                        {
                                            echo '<i class="bi bi-check2-all text-primary status-tick"></i>';
                                        }
                                }
                                else
                                    {
                                        echo '<i class="bi bi-check2 status-tick d-none"></i>';
                                    }
                            ?>
                            
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <script>
            $('.chatbox_body').scroll(function () {
                var top = $('.chatbox_body').scrollTop();

                if (top == 0) {
                    window.livewire.emit('loadMore')
                }
            })
        </script>
        <script>
            window.addEventListener('updateHeight', event => {
                let old = event.detail.height;
                let newHeight = $('.chatbox_body')[0].scrollHeight;
                let height = $('.chatbox_body').scrollTop(newHeight - old);

                window.livewire.emit('updateHeight', {
                    height: height,
                })
            })
        </script>
    <?php else: ?>
        <div class="col-11 mt-3 mx-auto alert alert-danger text-center">
            No Conversation Selected
        </div>

    <?php endif; ?>

    <script>
        window.addEventListener('rowChatToBottom', event => {
            $('.chatbox_body').scrollTop($('.chatbox_body')[0].scrollHeight);
        })
    </script>

    <script>
        $(document).on('click', '.return', function () {
            window.livewire.emit('resetComponent');
        })
    </script>
    <script>
        window.addEventListener('markMessageAsRead', event => {
            var value = document.querySelectorAll('.status-tick')
            if (value.array != undefined && value.array != null && value.array != '') {
                value.array.forEach(element, index => {
                    element.classList.remove('bi bi-check2')
                    element.classList.add('bi bi-check2-all', 'text-primary')
                });
            }
        })
    </script>
    <script>
        let music = new Audio('<?php echo e(url('source/public/mp3/mp3.wav')); ?>');
        window.addEventListener('mp3Play', event => {
            music.play()
        })
    </script>

</div>
<?php /**PATH /home/academy/public_html/chat/source/resources/views/livewire/chat/chatbox.blade.php ENDPATH**/ ?>