<div>
    <div class="chatlist_header">
        <div class="title">
            <?php echo e(auth()->user()->name); ?>

        </div>
        <div class="img_container">
            <?php if(auth()->user()->photo): ?>
                <img src="https://mainexpo.com.tr/<?php echo e(auth()->user()->photo->path); ?>" data-fancybox="gallery<?php echo e(auth()->user()->photo->id); ?>" href="https://mainexpo.com.tr/<?php echo e(auth()->user()->photo->path); ?>" alt="">
             <?php else: ?>
            <img src="https://ui-avatars.com/api/?background=0D8ABC&color=fff&name=<?php echo e(auth()->user()->name); ?>" alt="">
             <?php endif; ?>
        </div>
    </div>
    <div class="chatlist_body">
        <?php if(count($conversations) > 0): ?>
            <?php $__currentLoopData = $conversations->sortByDesc('last_time_message'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $conversation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="chat_list_item" wire:key="<?php echo e($conversation->id); ?>"
                     wire:click="$emit('chatUserSelected',<?php echo e($conversation); ?>,<?php echo e($this->grtChatUserInstance($conversation,$name='id')); ?>)">
                    <div class="chat_list_img_container">
                        <?php if($this->grtChatUserInstance($conversation,$name='profile')): ?>
                            <img src="https://mainexpo.com.tr/<?php echo e($this->grtChatUserInstance($conversation,$name='profile')); ?>" data-fancybox="gallery_profile_rand<?php echo e(rand(10000,99999)); ?>" href="https://mainexpo.com.tr/<?php echo e($this->grtChatUserInstance($conversation,$name='profile')); ?>" alt="">
                        <?php else: ?>
                        <img
                            src="https://ui-avatars.com/api/?name=<?php echo e($this->grtChatUserInstance($conversation,$name='name')); ?>" alt="">
                        <?php endif; ?>
                    </div>
                    <div class="chat_list_info">
                        <div class="top_row">
                            <div class="list_username">
                                <?php echo e($this->grtChatUserInstance($conversation,$name='name_role')); ?>

                            </div>
                            <span class="date"><?php echo e(count($conversation->messages)?$conversation->messages_last->created_at->shortAbsoluteDiffForHumans():''); ?></span>
                        </div>
                        <div class="bottom_row">
                            <div class="message_body text-truncate <?php if(count($conversation->messages)): ?> <?php echo e(!preg_match('/^[^\x{600}-\x{6FF}]+$/u', str_replace("\\\\", "", $conversation->messages_last->body))?'d-rtl':'d-ltr'); ?> <?php endif; ?>">
                                <?php if(count($conversation->messages)): ?>
                                    <?php if(auth()->user()->id == $conversation->messages_last->sender_id): ?>
                                        You:
                                    <?php endif; ?>
                                    <?php if($conversation->messages_last->type == 'text'): ?>
                                        <?php echo e($conversation->messages_last->body); ?>

                                    <?php else: ?>
                                        <?php echo e($conversation->messages_last->type); ?>

                                    <?php endif; ?>
                                <?php else: ?>
                                    'Not Message'
                                <?php endif; ?>
                            </div>

                            <?php
                                if(count($conversation->messages->where('read',0)->where('receiver_id',auth()->id())))
                                    {
                                        echo '<div class="unread_count badge rounded-pill text-light bg-danger"> '
                                        . count($conversation->messages->where('read',0)->where('receiver_id',auth()->id())) .
                                        ' </div>';
                                    }
                            ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php if(session()->has('user_id1') && session()->has('user_id2')): ?>
                    <script>
                        $(document).ready(function () {
                            window.livewire.emit('chatUserSelected2',<?php echo e(session('user_id1')); ?>,<?php echo e(session('user_id2')); ?>);
                        })
                    </script>
                <?php endif; ?>
        <?php else: ?>
            You Have No Conversations
        <?php endif; ?>
    </div>
</div>
<?php /**PATH /home/mainexpo/public_html/chat/source/resources/views/livewire/chat/chatlist.blade.php ENDPATH**/ ?>