<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title>Chat Laravel</title>

        <!-- bootstrap -->
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet"
              integrity="sha384-GLhlTQ8iRABdZLl6O3oVMWSktQOp6b7In1Zl3/Jr59b6EGGoI1aFkw7cmDA6j6gD" crossorigin="anonymous">
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"
                integrity="sha384-w76AqPfDkMBDXo30jS1Sgez6pr3x5MlQ1ZAGC+nuZB+EYdgRZgiwxhTBTkF7CXvN"
                crossorigin="anonymous"></script>
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.3/font/bootstrap-icons.css">

        <!-- style -->
        <link rel="stylesheet" href="<?php echo e(url('source/public/css/app.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(url('source/public/css/fancybox.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(url('source/public/css/chat.css?v=1.1.7')); ?>">
        <link rel="stylesheet" href="<?php echo e(url('source/public/css/jquery-confirm.min.css')); ?>">

        <!-- jquery -->
        <script src="<?php echo e(url('source/public/js/jquery.js')); ?>"></script>
        <script src="<?php echo e(url('source/public/js/jquery-confirm.min.js')); ?>"></script>
        <script src="<?php echo e(url('source/public/js/app.js')); ?>"></script>
        <script src="<?php echo e(url('source/public/js/fancybox.js')); ?>"></script>
        <style>
            body{
                font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell;
            }
        </style>
        <?php echo \Livewire\Livewire::styles(); ?>

    </head>
    <body class="font-sans antialiased">
    











































        <div class="min-h-screen">
            <?php echo $__env->make('layouts.navigation', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <!-- Page Content -->
            <main>
                <?php echo e($slot); ?>

            </main>
        </div>

        <?php echo \Livewire\Livewire::scripts(); ?>


    </body>
</html>
<?php /**PATH /home/mainexpo/public_html/chat/source/resources/views/layouts/app.blade.php ENDPATH**/ ?>