<div>
    <?php if($selectConversation && $selectConversation->status == 'active'): ?>
        <form wire:submit.prevent="sendMessage" method="post">
            <?php echo csrf_field(); ?>
            <div class="chatbox_footer">
                <div class="custom_form_group">
                    <input wire:model.defer="body" type="text" id="audio_input" class="control text-js-code" placeholder="write message">
                    <a href="javascript:void(0)" class="btn_img_record" id="start_button" title="شروع ضبط">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-mic-fill" viewBox="0 0 16 16">
                            <path d="M5 3a3 3 0 0 1 6 0v5a3 3 0 0 1-6 0z"/>
                            <path d="M3.5 6.5A.5.5 0 0 1 4 7v1a4 4 0 0 0 8 0V7a.5.5 0 0 1 1 0v1a5 5 0 0 1-4.5 4.975V15h3a.5.5 0 0 1 0 1h-7a.5.5 0 0 1 0-1h3v-2.025A5 5 0 0 1 3 8V7a.5.5 0 0 1 .5-.5"/>
                        </svg>
                    </a>
                    <a href="javascript:void(0)" class="btn_img_record" style="display: none;" id="stop_button" title="توقف ضبط">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-stop-circle" viewBox="0 0 16 16">
                            <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16"/>
                            <path d="M5 6.5A1.5 1.5 0 0 1 6.5 5h3A1.5 1.5 0 0 1 11 6.5v3A1.5 1.5 0 0 1 9.5 11h-3A1.5 1.5 0 0 1 5 9.5z"/>
                        </svg>
                    </a>
                    <a href="javascript:void(0)" class="btn_img_record" style="display: none;" id="stop_button1" title="توقف ضبط">
                        <img src="<?php echo e(url('assets/giphy.gif')); ?>" alt="record stop">
                    </a>
                    <a href="javascript:void(0)" class="btn_img_record" data-url="" style="display: none;" id="del_button" title="حذف ضبط">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-mic-mute-fill" viewBox="0 0 16 16">
                            <path d="M13 8c0 .564-.094 1.107-.266 1.613l-.814-.814A4 4 0 0 0 12 8V7a.5.5 0 0 1 1 0zm-5 4c.818 0 1.578-.245 2.212-.667l.718.719a5 5 0 0 1-2.43.923V15h3a.5.5 0 0 1 0 1h-7a.5.5 0 0 1 0-1h3v-2.025A5 5 0 0 1 3 8V7a.5.5 0 0 1 1 0v1a4 4 0 0 0 4 4m3-9v4.879L5.158 2.037A3.001 3.001 0 0 1 11 3"/>
                            <path d="M9.486 10.607 5 6.12V8a3 3 0 0 0 4.486 2.607m-7.84-9.253 12 12 .708-.708-12-12z"/>
                        </svg>
                    </a>
                    <label class="btn_file_add custom-file-upload">
                        <input type="file" id="user-file" name="user-file"/>
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-paperclip" viewBox="0 0 16 16">
                            <path d="M4.5 3a2.5 2.5 0 0 1 5 0v9a1.5 1.5 0 0 1-3 0V5a.5.5 0 0 1 1 0v7a.5.5 0 0 0 1 0V3a1.5 1.5 0 1 0-3 0v9a2.5 2.5 0 0 0 5 0V5a.5.5 0 0 1 1 0v7a3.5 3.5 0 1 1-7 0z"/>
                        </svg>
                    </label>
                    <audio controls autoplay class="audio_src" id="audio_src" style="display: none"></audio>
                    <div id="upload-result" style="display: none"></div>
                    <div id="upload-process" style="display: none">Uploading...</div>
                    <div class="imoji_chat_a">
                        <a href="javascript:void(0)">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-emoji-sunglasses" viewBox="0 0 16 16">
                                <path d="M4.968 9.75a.5.5 0 1 0-.866.5A4.5 4.5 0 0 0 8 12.5a4.5 4.5 0 0 0 3.898-2.25.5.5 0 1 0-.866-.5A3.5 3.5 0 0 1 8 11.5a3.5 3.5 0 0 1-3.032-1.75M7 5.116V5a1 1 0 0 0-1-1H3.28a1 1 0 0 0-.97 1.243l.311 1.242A2 2 0 0 0 4.561 8H5a2 2 0 0 0 1.994-1.839A3 3 0 0 1 8 6c.393 0 .74.064 1.006.161A2 2 0 0 0 11 8h.438a2 2 0 0 0 1.94-1.515l.311-1.242A1 1 0 0 0 12.72 4H10a1 1 0 0 0-1 1v.116A4.2 4.2 0 0 0 8 5c-.35 0-.69.04-1 .116"/>
                                <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0m-1 0A7 7 0 1 0 1 8a7 7 0 0 0 14 0"/>
                            </svg>
                        </a>
                        <div class="imoji_chat">
                            <?php $__currentLoopData = range(128512,128591); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="javascript:void(0)" data-code="&#<?php echo e($i); ?>;" wire:click="sendEmoji('&#<?php echo e($i); ?>;')" class="imoji_click">&#<?php echo e($i); ?>;</a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php $__currentLoopData = range(129293,129324); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="javascript:void(0)" data-code="&#<?php echo e($i); ?>;" wire:click="sendEmoji('&#<?php echo e($i); ?>;')" class="imoji_click">&#<?php echo e($i); ?>;</a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php $__currentLoopData = range(128070,128080); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="javascript:void(0)" data-code="&#<?php echo e($i); ?>;" wire:click="sendEmoji('&#<?php echo e($i); ?>;')" class="imoji_click">&#<?php echo e($i); ?>;</a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php $__currentLoopData = range(127792,127812); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="javascript:void(0)" data-code="&#<?php echo e($i); ?>;" wire:click="sendEmoji('&#<?php echo e($i); ?>;')" class="imoji_click">&#<?php echo e($i); ?>;</a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                           

                        </div>
                    </div>
                    <button type="submit" class="submit">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path fill="currentColor" d="M21.243 12.437a.5.5 0 0 0 0-.874l-2.282-1.268A75.5 75.5 0 0 0 4.813 4.231l-.665-.208A.5.5 0 0 0 3.5 4.5v5.75a.5.5 0 0 0 .474.5l1.01.053a44.4 44.4 0 0 1 7.314.998l.238.053c.053.011.076.033.089.05a.16.16 0 0 1 .029.096c0 .04-.013.074-.029.096c-.013.017-.036.039-.089.05l-.238.053a44.5 44.5 0 0 1-7.315.999l-1.01.053a.5.5 0 0 0-.473.499v5.75a.5.5 0 0 0 .65.477l.664-.208a75.5 75.5 0 0 0 14.147-6.064z"/></svg>
                    </button>
                </div>
            </div>
        </form>
        <script>
            $('.text-js-code').on('keyup', function () {
                $(this).val().charAt(0).charCodeAt(0) < 200 ?
                    $(this).css('direction', 'ltr') :
                    $(this).css('direction', 'rtl');
            })
        </script>
        <script>
            $(document).ready(function () {
                $("#start_button").click(function () {
                    startRecord();
                    $(this).hide();
                    $("#stop_button").show();
                    $("#stop_button1").show();
                    $("#start_gif").show();
                });
                function startRecord() {
                    navigator.mediaDevices.getUserMedia({ audio: true })
                        .then(stream => {
                            const mediaRecorder = new MediaRecorder(stream);
                            mediaRecorder.start();

                            const audioChunks = [];
                            mediaRecorder.addEventListener("dataavailable", event => {
                                audioChunks.push(event.data);
                            });

                            $("#stop_button").click(function () {
                                stream.getTracks() // get all tracks from the MediaStream
                                    .forEach( track => track.stop() );
                                mediaRecorder.stop();
                                // $(this).hide();
                                // $("#del_button").show('fade');
                                // $("#audio_src").show('fade');
                            });
                            mediaRecorder.addEventListener("stop", () => {
                                const audioBlob = new Blob(audioChunks);
                                createDownloadLink(audioBlob);
                            });
                        })
                        .catch(e => {
                            console.log("e: ", e);
                        });
                }
                function createDownloadLink(blob) {


                    var reader = new FileReader();
                    reader.readAsDataURL(blob);
                    reader.onloadend = function() {
                        var base64data = reader.result;


                        var file = dataURLtoFile('chat_voice_'+base64data,Date.now()+'.wav');


                        var data = new FormData();
                        data.append('voice', file,file.name);
                        $.ajaxSetup({
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            }
                        });
                        $.ajax({
                            url: '<?php echo e(route('save.sound')); ?>',
                            type:'POST',
                            data: data,
                            contentType: false,
                            processData: false,
                            success: function(data){
                                // $('#audio_input').val(data.url)
                                //
                                // var audio = document.querySelector("#audio_src");
                                // audio.src = data.url;
                                // $('#del_button').attr('data-url',data.end)

                                window.livewire.emit('getSoundRecord', data.url);
                            },
                            error:function (err) {
                            }
                        });
                    }
                }

                function dataURLtoFile(dataurl, filename) {

                    var arr = dataurl.split(','),
                        mime = arr[0].match(/:(.*?);/)[1],
                        bstr = atob(arr[1]),
                        n = bstr.length,
                        u8arr = new Uint8Array(n);

                    while(n--){
                        u8arr[n] = bstr.charCodeAt(n);
                    }

                    return new File([u8arr], filename, {type:mime});
                }
            });

            $('#del_button').click(function (){
                var url1 = $(this).attr('data-url');

                var url='<?php echo e(route('delete.sound')); ?>?url='+url1;
                $.get(url, function (data, status) {
                    if(data.status === 'success')
                    {
                        $('#audio_input').val('')

                        var audio = document.querySelector("#audio_src");
                        audio.src = ''

                        $('#del_button').attr('data-url','')
                        $('#del_button').hide();
                        $("#audio_src").hide();
                        $("#start_button").show();
                        window.livewire.emit('getSoundDelete');
                    }
                })
            })
            document.addEventListener('emoji-added', event => {
                let input = document.getElementById('audio_input');
                console.log(input.value)
                input.value += ' ' + event.detail.emoji;
                input.dispatchEvent(new Event('input'));
            });
            window.addEventListener('sound_play',event=> {
                let body_end=event.detail;
                let body=body_end
                $('#audio_input').val(body)

                var audio = document.querySelector("#audio_src");
                audio.src = body;
                $("#start_button").hide('');
                $("#stop_button").hide('');
                $("#stop_button1").hide('');
                $("#del_button").show();
                $("#audio_src").show();
                $('#del_button').attr('data-url',body_end)
            })
        </script>
        <script>
            $('#user-file').on('change',function (){
                var file = document.getElementById('user-file').files[0];
                var filename = file.name; // دریافت نام فایل
                var extension = filename.split('.').pop(); // استخراج پسوند
                var allowedFileTypes = ['zip', 'rar', 'pdf', 'jpg', 'jpeg', 'png', 'gif', 'webp', 'ico', 'txt', 'doc', 'docx', 'xlsx', 'mov', 'mp4', 'mp3', 'wav'];
                var result = document.getElementById('upload-result');
                if(file){
                    if(parseInt(file.size) > 31457280){
                        result.innerHTML = 'Max File Size 30 MB';
                        $('#upload-result').show();
                        setTimeout(function () {
                            result.innerHTML='';
                            $('#upload-result').hide();
                        },4000)
                        $("#upload-process").hide();
                    }
                    else if (!allowedFileTypes.includes(extension)) {
                        result.innerHTML = 'File uploads with this extension are not permitted.';
                        $('#upload-result').show();
                        setTimeout(function () {
                            result.innerHTML='';
                            $('#upload-result').hide();
                        },4000)
                    }
                    else
                    {
                        $("#upload-process").show();
                        var files = $('#user-file')[0].files;
                        result.innerHTML ='';
                        var fd = new FormData();
                        fd.append('file',files[0]);
                        fd.append('file_type',file.type);
                        $.ajaxSetup({
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            }
                        });
                        // AJAX request
                        $.ajax({
                            url: "<?php echo e(route('save.file')); ?>",
                            method: 'post',
                            data: fd,
                            contentType: false,
                            processData: false,
                            dataType: 'json',
                            success: function(response){
                                if(response.success == 1){ // Uploaded successfully
                                    $("#upload-process").hide();
                                    console.log(response.file_url)
                                    console.log(response.file_type)
                                    window.livewire.emit('getUploadFile', [response.file_url,response.file_type]);
                                }else{
                                    $("#upload-process").hide();
                                    result.innerHTML = 'Uploaded Danger';
                                    $('#upload-result').show();
                                    setTimeout(function () {
                                        result.innerHTML='';
                                        $('#upload-result').hide();
                                    },4000)
                                }
                            },
                            error: function(response){
                                $("#upload-process").hide();
                                result.innerHTML = 'Uploaded Danger';
                                $('#upload-result').show();
                                setTimeout(function () {
                                    result.innerHTML='';
                                    $('#upload-result').hide();
                                },4000)
                                console.log("error : " + JSON.stringify(response) );
                            }
                        });
                    }
                }
            })
        </script>
    <?php endif; ?>
</div>


<?php /**PATH /home/mainexpo/public_html/chat/source/resources/views/livewire/chat/send-message.blade.php ENDPATH**/ ?>