<?php
namespace App\Http\Controllers\Admin\Company;

use App\Http\Controllers\Controller;
use App\Models\BusinessInformation;
use App\Models\CompanyForm;
use App\Http\Requests\Company\BusinessInformationRequest;
use App\Models\ProductCategory;
use Illuminate\Http\Request;

class BusinessInformationController extends Controller
{
    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return translateText('اطلاعات کسب و کار', lang_admin());
                break;
            case 'edit':
                return translateText('ویرایش اطلاعات کسب و کار', lang_admin());
                break;
            case 'url_back':
                return route('admin.business-information.edit',auth()->id());
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:company_edit', ['only' => ['edit', 'update']]);
    }
    public function edit($id)
    {
        $item = BusinessInformation::firstOrCreate(
            ['user_id' => $id],
            ['user_id' => $id]
        );

        $categories = ProductCategory::where('parent_id', null)
            ->orderBy('sort')
            ->pluck('title','id')
            ->all();

        $bussiness_types = CompanyForm::where('type', 'bussiness_type')
            ->pluck('title', 'title')
            ->all();

        $ownership_models = CompanyForm::where('type', 'ownership_model')
            ->pluck('title', 'title')
            ->all();

        return view('admin.company.business_information.edit', compact('item', 'categories','bussiness_types', 'ownership_models'), ['title' => $this->controller_title('edit')]);
    }

    public function update(BusinessInformationRequest $request, $id)
    {
        $item = BusinessInformation::findOrFail($id);

        try {
            $item->update([
                'bussiness_type' => json_encode($request->bussiness_type),
                'registration_number' => $request->registration_number,
                'ownership_model' => $request->ownership_model,
                'main_product_keywords' => json_encode($request->main_product_keywords),
                'tax_identification_number' => $request->tax_identification_number
            ]);
            $item->categories()->sync($request->category_id);
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت ویرایش شد', lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای ویرایش به مشکل خوردیم، مجدد تلاش کنید', lang_admin()));
        }
    }
}