<?php

namespace App\Http\Controllers\Admin\Company;

use App\Http\Controllers\Controller;
use App\Http\Requests\Company\ContactInformationRequest;
use App\Models\Photo;
use App\Models\ContactInformation;
use App\Models\Country;
use App\Models\City;
use App\Models\State;
use App\Models\CompanyForm;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use App\Services\DataCacheService;

class ContactInformationController extends Controller
{
    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return translateText('اطلاعات تماس', lang_admin());
                break;
            case 'edit':
                return translateText('ویرایش اطلاعات تماس', lang_admin());
                break;
            case 'url_back':
                return route('admin.contact-information.edit',auth()->id());
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:company_edit', ['only' => ['edit', 'update']]);
    }

    public function edit($id)
    {
        $url_back = $this->controller_title('url_back');
        $item = ContactInformation::firstOrCreate(
            ['user_id' => $id],
            ['user_id' => $id]
        );
        $country_code = Country::orderBy('name')
            ->get(['phonecode', 'name'])
            ->mapWithKeys(function ($item) {
                return [$item->phonecode => "{$item->name} (+{$item->phonecode})"];
            })
            ->all();

        $country = DataCacheService::getCountries();
        $time_zone = DataCacheService::getTimeZones();

        $langS = CompanyForm::where('type', 'lang')
            ->pluck('title', 'title')
            ->all();

        $social_media = CompanyForm::where('type', 'social_media')
            ->pluck('title', 'title')
            ->all();

        return view('admin.company.contact_information.edit', compact('url_back','time_zone','country','social_media','langS','country_code', 'item'), ['title' => $this->controller_title('edit')]);
    }

    public
    function update(ContactInformationRequest $request, $id)
    {

        $item = ContactInformation::findOrFail($id);
        try {
            ContactInformation::where('id', $id)->update([
                'contact_person' => $request->contact_person,
                'job_title' => $request->job_title,
                'department' => $request->department,
                'email_address' => $request->email_address,
                'backup_email' => $request->backup_email,
                'country_code1' => $request->country_code1,
                'city_code' => $request->city_code,
                'phone_number' => $request->phone_number,
                'country_code2' => $request->country_code2,
                'mobile_number' => $request->mobile_number,
                'country_code3' => $request->country_code3,
                'city_code2' => $request->city_code2,
                'fax_number' => $request->fax_number,
                'supported_languages' => json_encode($request->supported_languages),
                'social_media' => json_encode($this->prepareSocialMedia($request)), 
                'country_id' => $request->country_id,
                'state_id' => $request->state_id,
                'city_id' => $request->city_id,
                'street' => $request->street,
                'post_code' => $request->post_code,
                'time_zone' => $request->time_zone,
            ]);

            //edit profile
            if ($request->hasFile('profile')) {
                if ($item->profile) {
                    if (is_file($item->profile->path)) {
                        File::delete($item->profile->path);
                        delete_directory($item->profile->path);
                    }
                    $item->profile->delete();
                }
                $profile = new Photo();
                $profile->type = 'profile';
                $profile->path = file_store($request->profile, 'assets/admin/uploads/company/profile' . '/');
                $item->profile()->save($profile);
            }
            
            store_lang($item, $request, ['contact_person', 'job_title', 'department'], 'edit');

            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت ویرایش شد', lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای ویرایش به مشکل خوردیم، مجدد تلاش کنید', lang_admin()));
        }
    }
    private function prepareSocialMedia($request)
    {
        $socialMedia = [];

        if ($request->has('social_media_type') && $request->has('social_media')) {
            $types = $request->social_media_type;
            $values = $request->social_media;

            foreach ($types as $index => $type) {
                $socialMedia[] = [
                    'type' => $type,
                    'value' => $values[$index],
                ];
            }
        }

        return $socialMedia;
    }

}
