<?php

namespace App\Http\Controllers\Admin\Company;

use App\Http\Controllers\Controller;
use App\Http\Requests\Company\GeneralInformationRequest;
use App\Models\Photo;
use App\Models\GeneralInformation;
use App\Models\Country;
use App\Models\CompanyForm;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;

class GeneralInformationController extends Controller
{
    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return translateText('اطلاعات عمومی', lang_admin());
                break;
            case 'edit':
                return translateText('ویرایش اطلاعات عمومی', lang_admin());
                break;
            case 'url_back':
                return route('admin.general-information.edit',auth()->id());
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:company_edit', ['only' => ['edit', 'update']]);
    }

    public
    function edit($id)
    {
        $url_back = $this->controller_title('url_back');
        $item = GeneralInformation::firstOrCreate(
            ['user_id' => $id],
            ['user_id' => $id]
        );
        $countries = Country::query()
            ->select('id', 'name', 'emoji')
            ->get()
            ->mapWithKeys(function ($country) {
                return [$country->id => "{$country->emoji} {$country->name}"];
            })
            ->all();
        $currencies = CompanyForm::where('type', 'currencies')
            ->pluck('title', 'title')
            ->all();

        $payments = CompanyForm::where('type', 'payment_terms')
            ->pluck('title', 'title')
            ->all();

        $days = CompanyForm::where('type', 'days')
            ->pluck('title', 'title')
            ->all();

        $employeesRange = CompanyForm::where('type', 'number_of_emploees')
            ->pluck('title', 'title')
            ->all();

        $currenciesString = $item->accepted_currencies ?? '';
        $currenciesArray = array_filter(array_map('trim', explode(',', $currenciesString)));
        $accepted_currencies = array_combine($currenciesArray, $currenciesArray);

        $paymentTermsString = $item->payment_terms ?? '';
        $paymentTermsArray = array_filter(array_map('trim', explode(',', $paymentTermsString)));
        $payment_terms = array_combine($paymentTermsArray, $paymentTermsArray);

        $workingDaysString = $item->working_days ?? '';
        $daysArray = array_filter(array_map('trim', explode(',', $workingDaysString)));
        $working_days = array_combine($daysArray, $daysArray);
        return view('admin.company.general_information.edit', compact('url_back','employeesRange','days','working_days','payment_terms','payments', 'item','countries','currencies','accepted_currencies'), ['title' => $this->controller_title('edit')]);
    }

    public
    function update(GeneralInformationRequest $request, $id)
    {
        $item = GeneralInformation::findOrFail($id);
        try {
            GeneralInformation::where('id', $id)->update([
                'company_name' => $request->company_name,
                'company_ceo' => $request->company_ceo,
                'company_introduction' => $request->company_introduction,
                'company_description' => $request->company_description,
                'year_of_established' => $request->year_of_established,
                'number_of_employees' => $request->number_of_employees,
                'website' => $request->website,
                'accepted_currencies' => implode(', ',$request->accepted_currencies),
                'payment_terms' => implode(', ',$request->payment_terms),
                'oem_services' => $request->oem_services,
                'working_days' => implode(', ', $request->working_days),
            ]);

            if ($request->has('main_markets')) {
                $item->countries()->sync($request->main_markets);
            }
            //edit logo
            if ($request->hasFile('logo')) {
                if ($item->logo) {
                    if (is_file($item->logo->path)) {
                        File::delete($item->logo->path);
                        delete_directory($item->logo->path);
                    }
                    $item->logo->delete();
                }
                $logo = new Photo();
                $logo->type = 'logo';
                $logo->path = file_store($request->logo, 'assets/admin/uploads/company/logo' . '/');
                $item->logo()->save($logo);
            }

            //edit banner1
            if ($request->hasFile('banner1')) {
                if ($item->banner1) {
                    if (is_file($item->banner1->path)) {
                        File::delete($item->banner1->path);
                        delete_directory($item->banner1->path);
                    }
                    $item->banner1->delete();
                }
                $banner1= new Photo();
                $banner1->type = 'banner1';
                $banner1->path = file_store($request->banner1, 'assets/admin/uploads/company/banner1' . '/');
                $item->banner1()->save($banner1);
            }

            //edit banner2
            if ($request->hasFile('banner2')) {
                if ($item->banner2) {
                    if (is_file($item->banner2->path)) {
                        File::delete($item->banner2->path);
                        delete_directory($item->banner2->path);
                    }
                    $item->banner2->delete();
                }
                $banner2= new Photo();
                $banner2->type = 'banner2';
                $banner2->path = file_store($request->banner2, 'assets/admin/uploads/company/banner2' . '/');
                $item->banner2()->save($banner2);
            }

            //edit brochure
            if ($request->hasFile('brochure')) {
                if ($item->brochure->first()) {
                    if (is_file($item->brochure->first()->path)) {
                        File::delete($item->brochure->first()->path);
                        delete_directory($item->brochure->first()->path);
                    }
                    $item->brochure->first()->delete();
                }
                $brochure= new Photo();
                $brochure->type = 'brochure';
                $brochure->path = file_store($request->brochure, 'assets/admin/uploads/company/brochure' . '/');
                $item->brochure()->save($brochure);
            }
            //edit video
            if ($request->hasFile('video')) {
                if ($item->video->first()) {
                    if (is_file($item->video->first()->path)) {
                        File::delete($item->video->first()->path);
                        delete_directory($item->video->first()->path);
                    }
                    $item->video->first()->delete();
                }
                $photo = new Photo();
                $photo->type = 'video';
                $photo->path = file_store($request->video, 'assets/admin/uploads/company/video' . '/');
                $item->video()->save($photo);
            }
//            added gallery photos
            if ($request->hasFile('gallery')) {
                foreach ($request->gallery as $photo) {
                    $gallery = new Photo();
                    $gallery->type = 'gallery';
                    $gallery->path = file_store($photo, 'assets/admin/uploads/company/gallery' . '/');
                    $item->gallery()->save($gallery);
                }
            }
            store_lang($item, $request, ['company_name', 'company_ceo', 'company_introduction', 'company_description'], 'edit');

            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت ویرایش شد', lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای ویرایش به مشکل خوردیم، مجدد تلاش کنید', lang_admin()));
        }
    }
    
}
