<?php

namespace App\Http\Controllers\Admin\Company;

use App\Http\Controllers\Controller;
use App\Http\Requests\Company\OfficeInformationRequest;
use App\Models\OfficeInformation;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Services\DataCacheService;

class OfficeInformationController extends Controller
{
    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return translateText('اطلاعات دفاتر', lang_admin());;
            case 'edit':
                return translateText('ویرایش اطلاعات دفاتر', lang_admin());
            case 'url_back':
                return route('admin.office-information.index', auth()->id());
            default:
                return '';
        }
    }

    public function __construct()
    {
        $this->middleware('permission:company_edit', ['only' => ['edit', 'update', 'addBranch']]);
    }

    public function index()
    {
        $items = OfficeInformation::with(['country','state','city'])
            ->where('user_id',auth()->id())
            ->get();
        $country = DataCacheService::getCountries();
        $time_zone = DataCacheService::getTimeZones();

        return view('admin.company.offices_information.index', compact('items',
            'country',
            'time_zone'), ['title' => $this->controller_title('index')]);
    }

    public function store(OfficeInformationRequest $request)
    {
        try {
            OfficeInformation::create([
                'user_id' => auth()->id(),
                'type' => 'branch',
                'country_id' => $request->country_id,
                'state_id' => $request->state_id,
                'city_id' => $request->city_id,
                'street' => $request->street,
                'zip_code' => $request->zip_code,
                'time_zone' => $request->time_zone,
            ]);

            return redirect($this->controller_title('url_back'))
                ->with('flash_message', translateText('شعبه جدید با موفقیت اضافه شد', lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()
                ->with('err_message', translateText('برای افزودن شعبه به مشکل خوردیم، مجدد تلاش کنید', lang_admin()));
        }
    }

    public function edit($id)
    {
        $url_back = $this->controller_title('url_back');
        $item = OfficeInformation::find($id);

        $country = DataCacheService::getCountries();
        $time_zone = DataCacheService::getTimeZones();

        return view('admin.company.offices_information.edit', compact('url_back',
            'item',
            'country',
            'time_zone'
        ), ['title' => $this->controller_title('edit')]);
    }

    public function update(OfficeInformationRequest $request, $id)
    {
        try {
            OfficeInformation::where('id', $id)->update([
                'country_id' => $request->country_id,
                'state_id' => $request->state_id,
                'city_id' => $request->city_id,
                'street' => $request->street,
                'zip_code' => $request->zip_code,
                'time_zone' => $request->time_zone,
            ]);

            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت ویرایش شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای ویرایش به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
    public function destroy($id)
    {
        $item = OfficeInformation::findOrFail($id);
        try {
            $item->delete();
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت حذف شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای حذف به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

}