<?php

namespace App\Http\Controllers\Admin\Form;

use App\Http\Controllers\Controller;
use App\Imports\CatImport;
use App\Models\Feedback;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Maatwebsite\Excel\Facades\Excel;

class FeedbackController extends Controller
{
    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return translateText('بازخوردها', lang_admin());
                break;
            case 'create':
                return translateText('افزودن بازخورد', lang_admin());
                break;
            case 'edit':
                return translateText('ویرایش بازخورد', lang_admin());
                break;
            case 'url_back':
                return route('admin.feedback.story.index');
                break;
            case 'url_back2':
                return route('admin.feedback.video.index');
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:feedback_list', ['only' => ['index', 'show']]);
        $this->middleware('permission:feedback_delete', ['only' => ['destroy']]);
    }

    public function index1()
    {
        $items = Feedback::whereNotNull('story')
            ->orderBy('id')
            ->get();
        return view('admin.form.feedback_story', compact('items'), ['title' => $this->controller_title('index')]);
    }

    public function index2()
    {
        $items = Feedback::whereNull('story')
            ->orderBy('id')
            ->get();
        return view('admin.form.feedback_video', compact('items'), ['title' => $this->controller_title('index')]);
    }

    public function show($id)
    {
        $item = FeedBack::find($id);
        return view('admin.form.feedback_show', compact('item'), ['title' => $this->controller_title('index')]);
    }
    public function update(Request $request, $id)
    {
        try {
            $request->validate([
                'status' => 'required|in:pending,active'
            ]);

            $feedback = Feedback::findOrFail($id);
            $feedback->status = $request->status;
            $feedback->save();
            $url_back = $feedback->story ? $this->controller_title('url_back') : $this->controller_title('url_back2');
            return redirect($url_back)->with('flash_message', translateText('اطلاعات با موفقیت ویرایش  شد', lang_admin()));
        }catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای ویرایش به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
}
