<?php

namespace App\Http\Controllers\Admin\Form;

use App\Http\Controllers\Controller;
use App\Models\RequiredServiceUser;
use Illuminate\Http\Request;


class RequiredServiceController extends Controller
{
    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return translateText('سرویس های مورد نیاز', lang_admin());
                break;
            case 'create':
                return translateText('افزودن سرویس های مورد نیاز', lang_admin());
                break;
            case 'edit':
                return translateText('ویرایش سرویس های مورد نیاز', lang_admin());
                break;
            case 'url_back':
                return route('admin.required-service.index');
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:feedback_list', ['only' => ['index', 'show']]);
        $this->middleware('permission:feedback_delete', ['only' => ['destroy']]);
    }

    public function index()
    {
        $items = RequiredServiceUser::with('user')
            ->orderBy('id', 'desc')
            ->get();;
        return view('admin.form.required_service.index', compact('items'), ['title' => $this->controller_title('index')]);
    }
    

    public function show($id)
    {
        $item = RequiredServiceUser::with('user')->find($id);
        $item->seen = 'yes';
        $item->save();
        return view('admin.form.required_service.show', compact('item'), ['title' => $this->controller_title('index')]);
    }
    public function update(Request $request, $id)
    {
    }
}
