<?php

namespace App\Http\Controllers\Admin\Land;

use App\Models\ExhibitionDate;
use App\Http\Requests\Land\ExhibitionDateRequest;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;

class ExhibitionDateController extends Controller
{
    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return translateText('نمایشگاه ها', lang_admin());
                break;
            case 'create':
                return translateText('افزودن', lang_admin());
                break;
            case 'edit':
                return translateText('ویرایش', lang_admin());
                break;
            case 'url_back':
                return route('admin.exhibition.index');
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:exhibition_list', ['only' => ['index', 'show']]);
        $this->middleware('permission:exhibition_create', ['only' => ['create', 'store']]);
        $this->middleware('permission:exhibition_delete', ['only' => ['destroy']]);
        $this->middleware('permission:exhibition_edit', ['only' => ['edit', 'update']]);
    }

    public function index()
    {
        $items = ExhibitionDate::orderByDesc('from_date')->get();
        return view('admin.land.exhibition.index', compact('items'), ['title' => $this->controller_title('index')]);
    }

    public function create()
    {
        $url_back = $this->controller_title('url_back');
        return view('admin.land.exhibition.create', compact('url_back'), ['title' => $this->controller_title('create')]);
    }

    public function store(ExhibitionDateRequest $request)
    {
        try {
            $item = ExhibitionDate::create([
                'title' => $request->title,
                'from_date' => $request->from_date,
//                'to_date' => $request->to_date,
                'text' => $request->text,
                'status' => $request->status,
            ]);
            store_lang($item, $request, ['title', 'text', 'status'], 'create');

            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت افزوده شد', lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای افزودن به مشکل خوردیم، مجدد تلاش کنید', lang_admin()));
        }
    }

    public function edit($id, Request $request)
    {
        $item = ExhibitionDate::findOrFail($id);
        $url_back = $this->controller_title('url_back');
        return view('admin.land.exhibition.edit', compact('url_back', 'item'), ['title' => $this->controller_title('edit')]);
    }

    public function update($id, ExhibitionDateRequest $request)
    {
        try {
            $item = ExhibitionDate::findOrFail($id);
            ExhibitionDate::where('id', $id)->update([
                'title' => $request->title,
                'from_date' => $request->from_date,
//                'to_date' => $request->to_date,
                'text' => $request->text,
                'status' => $request->status,
            ]);
            store_lang($item, $request, ['title', 'text', 'status'], 'edit');

            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت ویرایش شد', lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('اطلاعات با موفقیت ویرایش شد', lang_admin()));
        }
    }

    public function destroy($id, Request $request)
    {
        $item = ExhibitionDate::findOrFail($id);
        try {
            $item->delete();
            return redirect()->back()->with('flash_message', translateText('اطلاعات با موفقیت حذف شد', lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای حذف به مشکل خوردیم، مجدد تلاش کنید', lang_admin()));
        }
    }
}
