<?php

namespace App\Http\Controllers\Admin\Other;

use App\Http\Controllers\Controller;
use App\Http\Requests\Other\RatingRequest;
use App\Models\Photo;
use App\Imports\CatImport;
use App\Models\Rating;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Maatwebsite\Excel\Facades\Excel;

class RatingController extends Controller
{
    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return translateText('دسته رتبه بندی ها',lang_admin());
                break;
            case 'create':
                return translateText('افزودن رتبه بندی ها',lang_admin());
                break;
            case 'edit':
                return translateText('ویرایش رتبه بندی ها',lang_admin());
                break;
            case 'url_back':
                return route('admin.rating.index');
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:certificate_list', ['only' => ['index', 'show']]);
        $this->middleware('permission:certificate_create', ['only' => ['create', 'store']]);
        $this->middleware('permission:certificate_edit', ['only' => ['edit', 'update']]);
        $this->middleware('permission:certificate_delete', ['only' => ['destroy']]);
    }

    public function index()
    {
        $items = Rating::all();
        return view('admin.other.rating.index', compact('items'), ['title' => $this->controller_title('index')]);
    }

    public function show($id)
    {

    }

    public function create()
    {
        $url_back = $this->controller_title('url_back');
        return view('admin.other.rating.create', compact('url_back'), ['title' => $this->controller_title('create')]);
    }

    public function store(RatingRequest $request)
    {
        try {
            $item = Rating::create([
                'status' => $request->status,
                'link' => $request->link,
                'score' => $request->score,
            ]);

            if ($request->hasFile('photo')) {
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->photo, 'assets/admin/uploads/rating/photo' . '/');
                $item->photo()->save($photo);
            }

            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت افزوده شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای افزودن به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

    public function edit($id)
    {
        $url_back = $this->controller_title('url_back');
        $item = Rating::findOrFail($id);
        return view('admin.other.rating.edit', compact('url_back', 'item'), ['title' => $this->controller_title('edit')]);
    }

    public function update(RatingRequest $request, $id)
    {
        $item = Rating::findOrFail($id);
        try {
            Rating::where('id', $id)->update([
                'status' => $request->status,
                'link' => $request->link,
                'score' => $request->score,
            ]);
            //edit category
            if ($request->hasFile('photo')) {
                if ($item->photo) {
                    if (is_file($item->photo->path)) {
                        File::delete($item->photo->path);
                        delete_directory($item->photo->path);
                    }
                    $item->photo->delete();
                }
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->photo, 'assets/admin/uploads/rating/photo' . '/');
                $item->photo()->save($photo);
            }

            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت ویرایش شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای ویرایش به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

    public function destroy($id)
    {
        $item = Rating::findOrFail($id);
        try {
            $item->delete();
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت حذف شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای حذف به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
}
