<?php

namespace App\Http\Controllers\Admin\Other;

use App\Models\SourcingMagazine;
use App\Models\ProductCategory;
use App\Models\Setting;
use App\Models\Photo;
use App\Http\Requests\Other\SourcingMagazineRequest;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;

class SourcingMagazineController extends Controller
{
    public function controller_title($type)
    {
        switch ($type)
        {
            case 'index':
                return translateText('Sourcing e-Magazines',lang_admin());
                break;
            case 'create':
                return translateText('افزودن Sourcing e-Magazines',lang_admin());
                break;
            case 'edit':
                return translateText('ویرایش Sourcing e-Magazines',lang_admin());
                break;
            case 'url_back':
                return route('admin.sourcing-magazine.index');
                break;
            default:
                return '';
                break;
        }
    }
    public function __construct()
    {
        $this->middleware('permission:sourcing_magazine_list', ['only' => ['index','show']]);
        $this->middleware('permission:sourcing_magazine_create', ['only' => ['create','store']]);
        $this->middleware('permission:sourcing_magazine_edit', ['only' => ['edit','update','top_page']]);
        $this->middleware('permission:sourcing_magazine_delete', ['only' => ['destroy']]);
        $this->middleware('permission:sourcing_magazine_sort', ['only' => ['sort']]);
    }

    public function index()
    {
        $items=SourcingMagazine::orderBy('sort')->get();
        $setting=Setting::first();
        return view('admin.other.sourcing_magazine.index', compact('items','setting'), ['title' => $this->controller_title('index')]);
    }
    public function show($id)
    {

    }
    public function create()
    {
        $url_back=$this->controller_title('url_back');
        $cats=ProductCategory::where('parent_id',null)->orderBy('id')->get();
        return view('admin.other.sourcing_magazine.create',compact('url_back','cats'), ['title' => $this->controller_title('create')]);
    }
    public function store(SourcingMagazineRequest $request)
    {
        try {
            $item = SourcingMagazine::create([
                'cat_id' => $request->cat_id,
                'title' => $request->title,
                'issue_date' => $request->issue_date,
                'includes' => $request->includes,
                'text' => $request->text,
                'status' => $request->status,
            ]);
            //create SourcingMagazine
            if ($request->hasFile('photo')) {
                $gallery = new Photo();
                $gallery->type = 'photo';
                $gallery->path = file_store($request->photo, 'assets/admin/uploads/other/sourcing_magazine/photo', '/');
                $item->photo()->save($gallery);
            }
            if ($request->hasFile('pdf')) {
                $gallery = new Photo();
                $gallery->type = 'pdf';
                $gallery->path = file_store($request->pdf, 'assets/admin/uploads/other/sourcing_magazine/pdf', '/');
                $item->pdf()->save($gallery);
            }

            store_lang($item,$request,['title','issue_date','includes','text','status'],'create');
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت افزوده شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای افزودن به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
    public function edit($id)
    {
        $url_back=$this->controller_title('url_back');
        $item=SourcingMagazine::findOrFail($id);
        $cats=ProductCategory::where('parent_id',null)->orderBy('id')->get();
        return view('admin.other.sourcing_magazine.edit',compact('url_back','item','cats'), ['title' => $this->controller_title('edit')]);
    }
    public function update(SourcingMagazineRequest $request,$id)
    {
        $item=SourcingMagazine::findOrFail($id);
        try {
            SourcingMagazine::where('id',$id)->update([
                'cat_id' => $request->cat_id,
                'title' => $request->title,
                'issue_date' => $request->issue_date,
                'includes' => $request->includes,
                'text' => $request->text,
                'status' => $request->status,
            ]);
            //edit SourcingMagazine

            if ($request->hasFile('photo')) {
                if($item->photo)
                {
                    if(is_file($item->photo->path))
                    {
                        File::delete($item->photo->path);
                        delete_directory($item->photo->path);
                    }
                    $item->photo->delete();
                }
                $gallery = new Photo();
                $gallery->type = 'photo';
                $gallery->path = file_store($request->photo, 'assets/admin/uploads/other/sourcing_magazine/photo', '/');
                $item->photo()->save($gallery);
            }
            if ($request->hasFile('pdf')) {
                if($item->pdf)
                {
                    if(is_file($item->pdf->path))
                    {
                        File::delete($item->pdf->path);
                        delete_directory($item->pdf->path);
                    }
                    $item->pdf->delete();
                }
                $gallery = new Photo();
                $gallery->type = 'pdf';
                $gallery->path = file_store($request->pdf, 'assets/admin/uploads/other/sourcing_magazine/pdf', '/');
                $item->pdf()->save($gallery);
            }

            store_lang($item,$request,['title','issue_date','includes','text','status'],'edit');
            return redirect($this->controller_title('url_back'))->with('flash_message',translateText('اطلاعات با موفقیت ویرایش شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای ویرایش به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
    public function destroy($id)
    {
        $item=SourcingMagazine::findOrFail($id);
        try {
            $item->delete();
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت حذف شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای حذف به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
    public function sort(Request $request,$id)
    {
        $item=SourcingMagazine::findOrFail($id);
        try {
            $item->sort=$request->sort;
            $item->update();
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت سورت شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای سورت به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
    public function top_page(Request $request)
    {
        $item=Setting::firstOrFail();
        try {
            $item->sourcing_magazine_title=$request->sourcing_magazine_title;
            $item->sourcing_magazine_text=$request->sourcing_magazine_text;
            $item->update();

            if ($request->hasFile('sourcing_magazine_photo')) {
                if($item->sourcing_magazine_photo)
                {
                    if(is_file($item->sourcing_magazine_photo->path))
                    {
                        File::delete($item->sourcing_magazine_photo->path);
                        delete_directory($item->sourcing_magazine_photo->path);
                    }
                    $item->sourcing_magazine_photo->delete();
                }
                $gallery = new Photo();
                $gallery->type = 'sourcing_magazine_photo';
                $gallery->path = file_store($request->sourcing_magazine_photo, 'assets/admin/uploads/other/SourcingMagazine/sourcing_magazine_photo', '/');
                $item->sourcing_magazine_photo()->save($gallery);
            }
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت ویرایش شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای ویرایش به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

}
