<?php

namespace App\Http\Controllers\Admin\Product;

use App\Http\Controllers\Controller;
use App\Http\Requests\Product\ProductRequest;
use App\Models\Photo;
use App\Models\Product;
use App\Models\ProductPrice;
use App\Models\ProductFeature;
use App\Models\ProductCategory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;

class ProductServiceController extends Controller
{
    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return translateText('خدمات',lang_admin());
                break;
            case 'create':
                return translateText('افزودن خدمت',lang_admin());
                break;
            case 'edit':
                return translateText('ویرایش خدمت',lang_admin());
                break;
            case 'price':
                return translateText('قیمت های خدمت ',lang_admin());
                break;
            case 'feature':
                return translateText('ویژگی های خدمت ',lang_admin());
                break;
            case 'url_back':
                return route('admin.product-service.index');
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:product_list', ['only' => ['index', 'show']]);
        $this->middleware('permission:product_create', ['only' => ['create', 'store']]);
        $this->middleware('permission:product_edit', ['only' => ['edit', 'update']]);
        $this->middleware('permission:product_delete', ['only' => ['destroy']]);
        $this->middleware('permission:product_sort', ['only' => ['sort']]);
        $this->middleware('permission:product_other', ['only' => ['product_price','product_feature','product_price_new','product_feature_new','product_price_update','product_feature_update','product_price_remove','product_feature_remove']]);
    }

    public function index()
    {
        $items = Product::whereHas('c1_service_yes')->orderByDesc('id');
        if(auth()->user()->hasRole('supplier'))
            $items=$items->where('user_id',auth()->id());
        $items=$items->get();
        return view('admin.product.service.index', compact('items'), ['title' => $this->controller_title('index')]);
    }

    public function show($id)
    {

    }

    public function create()
    {
        $url_back = $this->controller_title('url_back');
        $cats = ProductCategory::where('service','yes')->where('parent_id',null)->orderBy('sort')->get();
        $cats2 = ProductCategory::where('parent_id','!=', null)->where('user_id',1)->whereHas('parent_service_yes')->whereHas('childs',function ($c){
            $c->where('user_id',auth()->id());
        })->orderBy('sort')->get();
        $cats3 = ProductCategory::where('user_id', auth()->id())->whereHas('parent_null')->orderBy('sort')->get();
        return view('admin.product.service.create', compact('url_back', 'cats','cats2','cats3'), ['title' => $this->controller_title('create')]);
    }

    public function store(ProductRequest $request)
    {
        try {
            $user = auth()->user();
            $item = Product::create([
                'user_id' => auth()->id(),
                'category_id' => $request->category_id == 'father' ?  $request->category_id3 : $request->category_id,
                'c_1' => $request->category_id1,
                'c_2' => $request->category_id2,
                'c_3' => $request->category_id3,
                'c_4' => $request->category_id == 'father' ? null : $request->category_id,
                'title' => $request->title,
                'slug' => generateSlug($request->title),
                'text' => $request->text,
                'meta_description' => $request->meta_description,
                'meta_title' => $request->meta_title,
                'status' => $request->status,
                'unit' => $request->unit,
                'for_we' => ($user->hasRole('buyer') || $user->hasRole('supplier')) ? 'no' : 'yes' ,
            ]);
            $item->slug=$item->slug.'-'.$item->id;
            $item->save();
            //create product
            if ($request->hasFile('photo')) {
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->photo, 'assets/admin/uploads/product/service' . '/');
                $item->photo()->save($photo);
            }
            //create video
            if ($request->hasFile('video')) {
                $photo = new Photo();
                $photo->type = 'video';
                $photo->path = file_store($request->video, 'assets/admin/uploads/product/video/service' . '/');
                $item->video()->save($photo);
            }
            if ($request->hasFile('icon')) {
                $photo = new Photo();
                $photo->type = 'icon';
                $photo->path = file_store($request->icon, 'assets/admin/uploads/product-category' . '/');
                $item->icon()->save($photo);
            }
//            added gallery photos
            if ($request->hasFile('photos')) {
                foreach ($request->photos as $photo) {
                    $gallery = new Photo();
                    $gallery->type = 'gallery';
                    $gallery->path = file_store($photo, 'assets/admin/uploads/product/photos/service', '/');
                    $item->gallery()->save($gallery);
                }
            }
            store_lang($item, $request, ['title', 'text', 'meta_title', 'meta_description','unit', 'status'], 'create');

            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت افزوده شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای افزودن به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

    public function edit($id)
    {
        $url_back = $this->controller_title('url_back');
        $cats = ProductCategory::where('service','yes')->where('parent_id',null)->orderBy('sort')->get();
        $cats2 = ProductCategory::where('parent_id','!=', null)->where('user_id',1)->whereHas('parent_service_yes')->whereHas('childs',function ($c){
            $c->where('user_id',auth()->id());
        })->orderBy('sort')->get();
        $cats3 = ProductCategory::where('user_id', auth()->id())->whereHas('parent_null')->orderBy('sort')->get();
        $item = Product::whereHas('c1_service_yes')->findOrFail($id);
        if(auth()->user()->hasRole('supplier') && $item->user_id != auth()->id())
            abort(404);

        return view('admin.product.service.edit', compact('url_back', 'item', 'cats','cats2','cats3'), ['title' => $this->controller_title('edit')]);
    }

    public function update(ProductRequest $request, $id)
    {
        $item = Product::whereHas('c1_service_yes')->findOrFail($id);
        if(auth()->user()->hasRole('supplier') && $item->user_id != auth()->id())
            abort(404);
        try {
            Product::where('id', $id)->update([
                'category_id' => $request->category_id == 'father' ?  $request->category_id3 : $request->category_id,
                'c_1' => $request->category_id1,
                'c_2' => $request->category_id2,
                'c_3' => $request->category_id3,
                'c_4' => $request->category_id == 'father' ? null : $request->category_id,
                'title' => $request->title,
//                'slug' => $request->slug,
                'text' => $request->text,
                'meta_description' => $request->meta_description,
                'meta_title' => $request->meta_title,
                'status' => $request->status,
                'unit' => $request->unit,
            ]);
            //edit product
            if ($request->hasFile('photo')) {
                if ($item->photo) {
                    if (is_file($item->photo->path)) {
                        File::delete($item->photo->path);
                        delete_directory($item->photo->path);
                    }
                    $item->photo->delete();
                }
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->photo, 'assets/admin/uploads/product/service' . '/');
                $item->photo()->save($photo);
            }
            //edit video
            if ($request->hasFile('video')) {
                if ($item->video) {
                    if (is_file($item->video->path)) {
                        File::delete($item->video->path);
                        delete_directory($item->video->path);
                    }
                    $item->video->delete();
                }
                $photo = new Photo();
                $photo->type = 'video';
                $photo->path = file_store($request->video, 'assets/admin/uploads/product/video/service' . '/');
                $item->video()->save($photo);
            }
            if ($request->hasFile('icon')) {
                if ($item->icon) {
                    if (is_file($item->icon->path)) {
                        File::delete($item->icon->path);
                        delete_directory($item->icon->path);
                    }
                    $item->icon->delete();
                }
                $photo = new Photo();
                $photo->type = 'icon';
                $photo->path = file_store($request->icon, 'assets/admin/uploads/product-category' . '/');
                $item->icon()->save($photo);
            }
//            added gallery photos
            if ($request->hasFile('photos')) {
                foreach ($request->photos as $photo) {
                    $gallery = new Photo();
                    $gallery->type = 'gallery';
                    $gallery->path = file_store($photo, 'assets/admin/uploads/product/photos/service'. '/');
                    $item->gallery()->save($gallery);
                }
            }
            store_lang($item, $request, ['title', 'text', 'meta_title', 'meta_description','unit', 'status'], 'edit');

            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت ویرایش شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای ویرایش به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

    public function destroy($id)
    {
        $item = Product::whereHas('c1_service_yes')->findOrFail($id);
        if(auth()->user()->hasRole('supplier') && $item->user_id != auth()->id())
            abort(404);
        try {
            $item->delete();
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت حذف شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای حذف به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
    public function sort($id, Request $request)
    {
        $item = Product::findOrFail($id);
        if(auth()->user()->hasRole('supplier') && $item->user_id != auth()->id())
            abort(404);
        try {
            $item->sort = $request->sort;
            $item->update();
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت سورت شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای سورت به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
    public function product_price($id)
    {
        $product = Product::whereHas('c1_service_yes')->findOrFail($id);
        $items = ProductPrice::where('product_id',$id)->orderBy('price')->get();
        $url_back = $this->controller_title('url_back');
        if(auth()->user()->hasRole('supplier') && $product->user_id != auth()->id())
            abort(404);

        return view('admin.product.price', compact('url_back', 'product', 'items'), ['title' => $this->controller_title('price').' '.$product->title]);
    }
    public function product_price_new(Request $request,$id)
    {
        $item = Product::whereHas('c1_service_yes')->findOrFail($id);
        if(auth()->user()->hasRole('supplier') && $item->user_id != auth()->id())
            abort(404);
        try {
            ProductPrice::create([
                'product_id'=>$id,
                'price'=>$request->price,
                'from'=>$request->from,
                'to'=>$request->to,
            ]);
            return redirect()->back()->with('flash_message', translateText('اطلاعات با موفقیت افزوده شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای افزودن به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
    public function product_price_update(Request $request,$id)
    {
        $item = ProductPrice::findOrFail($id);
        $product=Product::whereHas('c1_service_yes')->findOrFail($item->product_id);
        if(auth()->user()->hasRole('supplier') && $product->user_id != auth()->id())
            abort(404);
        try {
            ProductPrice::where('id',$id)->update([
                'price'=>$request->price,
                'from'=>$request->from,
                'to'=>$request->to,
            ]);
            return redirect()->back()->with('flash_message', translateText('اطلاعات با موفقیت ویرایش شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای ویرایش به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
    public function product_price_remove(Request $request,$id)
    {
        $item = ProductPrice::findOrFail($id);
        $product=Product::whereHas('c1_service_yes')->findOrFail($item->product_id);
        if(auth()->user()->hasRole('supplier') && $product->user_id != auth()->id())
            abort(404);
        try {
            $item->delete();
            return redirect()->back()->with('flash_message', translateText('اطلاعات با موفقیت حذف شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message',translateText('برای حذف به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

    public function product_feature($id)
    {
        $product = Product::whereHas('c1_service_yes')->findOrFail($id);
        $items = ProductFeature::where('product_id',$id)->get();
        $url_back = $this->controller_title('url_back');
        if(auth()->user()->hasRole('supplier') && $product->user_id != auth()->id())
            abort(404);

        return view('admin.product.feature', compact('url_back', 'product', 'items'), ['title' => $this->controller_title('feature').' '.$product->title]);
    }
    public function product_feature_new(Request $request,$id)
    {
        $product = Product::whereHas('c1_service_yes')->findOrFail($id);
        if(auth()->user()->hasRole('supplier') && $product->user_id != auth()->id())
            abort(404);
        try {
            $item=ProductFeature::create([
                'product_id'=>$id,
                'title'=>$request->title,
                'value'=>$request->value,
            ]);
            store_lang($item, $request, ['title', 'value'], 'create');
            return redirect()->back()->with('flash_message', translateText('اطلاعات با موفقیت افزوده شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای افزودن به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
    public function product_feature_update(Request $request,$id)
    {
        $item = ProductFeature::findOrFail($id);
        $product=Product::whereHas('c1_service_yes')->findOrFail($item->product_id);
        if(auth()->user()->hasRole('supplier') && $product->user_id != auth()->id())
            abort(404);
        try {
            ProductFeature::where('id',$id)->update([
                'title'=>$request->title,
                'value'=>$request->value,
            ]);
            store_lang($item, $request, ['title', 'value'], 'edit');
            return redirect()->back()->with('flash_message', translateText('اطلاعات با موفقیت ویرایش شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای ویرایش به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
    public function product_feature_remove(Request $request,$id)
    {
        $item = ProductFeature::findOrFail($id);
        $product=Product::whereHas('c1_service_yes')->findOrFail($item->product_id);
        if(auth()->user()->hasRole('supplier') && $product->user_id != auth()->id())
            abort(404);
        try {
            $item->delete();
            return redirect()->back()->with('flash_message', translateText('اطلاعات با موفقیت حذف شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای حذف به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
}
