<?php

namespace App\Http\Controllers\Admin\Setting;

use App\Models\Meta;
use App\Http\Requests\Setting\MetaRequest;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;

use Spatie\Permission\Models\Permission;
class MetaController extends Controller
{
    public function controller_title($type)
    {
        switch ($type)
        {
            case 'index':
                return translateText('متا',lang_admin());
                break;
            case 'create':
                return translateText('افزودن متا',lang_admin());
                break;
            case 'edit':
                return translateText('ویرایش متا',lang_admin());
                break;
            case 'url_back':
                return route('admin.meta.index');
                break;
            default:
                return '';
                break;
        }
    }
    public function __construct()
    {
        $this->middleware('permission:meta_list', ['only' => ['index','show']]);
        $this->middleware('permission:meta_create', ['only' => ['create','store']]);
        $this->middleware('permission:meta_edit', ['only' => ['edit','update']]);
        $this->middleware('permission:meta_delete', ['only' => ['destroy']]);
        $this->middleware('permission:meta_status', ['only' => ['status']]);
    }

    public function index()
    {
        $items=Meta::orderByDesc('id')->get();
        return view('admin.setting.meta.index', compact('items'), ['title' => $this->controller_title('index')]);
    }
    public function show($id)
    {

    }
    public function create()
    {
        $url_back=$this->controller_title('url_back');
        return view('admin.setting.meta.create',compact('url_back'), ['title' => $this->controller_title('create')]);
    }
    public function store(MetaRequest $request)
    {
        try {
            $item = Meta::create([
                'name_page' => $request->name_page,
                'title_page' => $request->title_page,
                'link' => urldecode($request->link),
                'description' => $request->description,
                'status' => $request->status,
                'schema' => $request->schema,
                'canonical' => urldecode($request->canonical),
                'robots' => $request->robots,
            ]);

            store_lang($item,$request,['name_page','title_page','keyword','description','status'],'create');
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت افزوده شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای افزودن به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
    public function edit($id)
    {
        $url_back=$this->controller_title('url_back');
        $item=Meta::findOrFail($id);
        return view('admin.setting.meta.edit',compact('url_back','item'), ['title' => $this->controller_title('edit')]);
    }
    public function update(MetaRequest $request,$id)
    {
        $item=Meta::findOrFail($id);
        try {
            Meta::where('id',$id)->update([
                'name_page' => $request->name_page,
                'title_page' => $request->title_page,
                'link' => urldecode($request->link),
                'description' => $request->description,
                'status' => $request->status,
                'schema' => $request->schema,
                'canonical' => urldecode($request->canonical),
                'robots' => $request->robots,
            ]);
            store_lang($item,$request,['name_page','title_page','keyword','description','status'],'edit');
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت ویرایش شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای ویرایش به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
    public function destroy($id)
    {
        $item=Meta::findOrFail($id);
        try {
            $item->delete();
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت حذف شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای حذف به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

    public function status($id,$type,$status)
    {
        $item=Meta::findOrFail($id);
        try {
            $item->$type=$status;
            $item->update();
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت تغییر وضعیت شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای تغییر وضعیت به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
}
