<?php

namespace App\Http\Controllers\Admin\Setting;

use App\Models\NotificationBar;
use App\Http\Requests\Setting\NotificationBarRequest;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\File;

use Spatie\Permission\Models\Permission;
class NotificationBarController extends Controller
{
    public function controller_title($type)
    {
        switch ($type)
        {
            case 'edit':
                return translateText('ویرایش نوار اطلاع رسانی',lang_admin());
                break;
            case 'url_back':
                return route('admin.notification-bar.edit',1);
                break;
            default:
                return '';
                break;
        }
    }
    public function __construct()
    {
        $this->middleware('permission:about_list', ['only' => ['index','show']]);
        $this->middleware('permission:about_edit', ['only' => ['edit','update']]);

        $this->middleware('permission:about_option_list', ['only' => ['option_index']]);
        $this->middleware('permission:about_option_create', ['only' => ['option_create','option_store']]);
        $this->middleware('permission:about_option_edit', ['only' => ['option_edit','option_update']]);
        $this->middleware('permission:about_option_delete', ['only' => ['option_destroy']]);
    }

    public function edit($id)
    {
        $url_back=$this->controller_title('url_back');
        $item=NotificationBar::findOrFail($id);

        return view('admin.setting.notification_bar.edit',compact('url_back','item'), ['title' => $this->controller_title('edit')]);
    }
    public function update(NotificationBarRequest $request,$id)
    {
        $item=NotificationBar::findOrFail($id);
        try {
            NotificationBar::where('id',$id)->update([
                'title' => $request->title,
                'link' => $request->link,
                'status' => $request->status,
            ]);

            store_lang($item,$request,['title'],'edit');
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت ویرایش شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای ویرایش به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

}
