<?php

namespace App\Http\Controllers\Admin\Setting;

use App\Models\User;
use App\Models\Select;
use App\Models\UserCertificate;
use App\Models\UserAddress;
use App\Models\Photo;
use App\Models\Industry;
use App\Models\Country;
use App\Models\SettingSale;
use App\Models\Verify;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Carbon\Carbon;

class ProfileController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:profile_list', ['only' => ['index', 'show']]);
        $this->middleware('permission:profile_edit', ['only' => ['edit', 'update']]);
        $this->middleware('permission:profile_verify', ['only' => ['edit_verify', 'update_verify', 'delete_verify_certificate']]);
        $this->middleware('permission:profile_address', ['only' => ['edit_address', 'update_address', 'delete_address']]);
    }

    public function show()
    {
        $item = User::findOrFail(Auth::user()->id);
        $verify=User::whereDate('verify_date','>=',Carbon::now())->find(Auth::user()->id);
        $package=false;
        $days=0;
        if($verify)
        {
            $package=true;
            $start = Carbon::parse($verify->verify_date)->format('Y-m-d 23:59:59');
            $end=Carbon::now()->format('Y-m-d 00:00:00');
            $start = Carbon::parse($start);
            $end=Carbon::parse($end);
            $days = round($end->diffInDays($start,false));
        }
        $role=count(auth()->user()->roles) ? auth()->user()->roles->first()->name : '';
        $packages=SettingSale::where('role',$role)->get();
        return view('admin.setting.profile.show', compact('item','package','days','verify','packages'));
    }

    public function edit()
    {
        $item = User::findOrFail(Auth::user()->id);
        $business_type = Select::where('status', 'active')->where('type', 'business_type')->get();
        $purchasing_frequency = Select::where('status', 'active')->where('type', 'purchasing_frequency')->get();
        $annual_purchase_volume = Select::where('status', 'active')->where('type', 'annual_purchase_volume')->get();
        $selected_business = $item->user_business()->pluck('business_type_id')->toArray();
        $industries = Industry::checkStatus()->where('industry_id', null)
            ->orderBy('created_at')
            ->get();
        $code = auth()->user()->code;
        if (blank($code) && auth()->user()->hasRole('supplier'))
            $code = 90;
        elseif (blank($code) && auth()->user()->hasRole('supplier'))
            $code = 964;

        return view('admin.setting.profile.edit', compact('item', 'industries','code', 'selected_business', 'business_type', 'purchasing_frequency', 'annual_purchase_volume'));
    }

    public function update(Request $request)
    {
        $item = User::findOrFail(Auth::user()->id);
        $this->validate($request, [
            'name' => 'required|max:200',
            'company_name' => $request->input('user_type') == 'legal' && auth()->user()->hasRole('buyer') ? 'required|max:200' : 'nullable|max:200',
            'country_code' => 'required',
            'industry_id' => auth()->user()->hasRole('supplier')  ? 'required' : '',
            'year_of_establishment' => auth()->user()->hasRole('supplier')  ? 'required|date' : 'date',
            'mobile' => 'required',
            'password' => 'nullable|min:6|confirmed',
            'photo' => "nullable|image|mimes:jpeg,jpg,png,webp|max:256",
            'header_profile' => "nullable|image|mimes:jpeg,jpg,webp|max:512",
        ]);
        try {
            $item->user_type = $request->input('user_type');
            $item->name = $request->input('name');
            $item->company_name = $request->input('user_type') == 'legal' ? $request->input('company_name') : null;
            $item->country_code = $request->input('country_code');
            $item->industry_id = $request->input('industry_id');
            $item->year_of_establishment = $request->input('year_of_establishment');
            $item->mobile = $request->input('mobile');
            $item->purchasing_frequency_id = $request->input('purchasing_frequency_id');
            $item->annual_purchase_volume_id = $request->input('annual_purchase_volume_id');
            $item->info = $request->input('info');
            if ($request->input('password') != null and $request->input('password') != '') {
                $item->password = $request->input('password');
            }
            $item->update();
            //نوع کسب وکار
            $item->user_business()->detach();
            $item->user_business()->attach(
                $request->business_type_id
            );
            //edit User photo
            if ($request->hasFile('photo')) {
                if ($item->photo) {
                    if (is_file($item->photo->path)) {
                        File::delete($item->photo->path);
                        delete_directory($item->photo->path);
                    }
                    $item->photo->delete();
                }
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->photo, 'assets/admin/uploads/setting/profile' . '/');
                $item->photo()->save($photo);
            }

            //edit User photo
            if ($request->hasFile('header_profile')) {
                if ($item->header_profile) {
                    if (is_file($item->header_profile->path)) {
                        File::delete($item->header_profile->path);
                        delete_directory($item->header_profile->path);
                    }
                    $item->header_profile->delete();
                }
                $photo = new Photo();
                $photo->type = 'header_profile';
                $photo->path = file_store($request->header_profile, 'assets/admin/uploads/setting/profile/header_profile' . '/');
                $item->header_profile()->save($photo);
            }

            return redirect()->back()->with('flash_message', translateText('اطلاعات با موفقیت ویرایش شد', lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای ویرایش به مشکل خوردیم، مجدد تلاش کنید', lang_admin()));
        }
    }

    public function edit_verify()
    {
        $item = User::findOrFail(Auth::user()->id);
        $certificates = UserCertificate::where('user_id', $item->id)->whereNotIN('type_title', ['passport', 'n_cart'])->get();
        $type_certificate = Select::where('status', 'active')->where('type', 'certificate')->get();
        return view('admin.setting.profile.edit_verify', compact('item', 'type_certificate', 'certificates'));
    }

    public function update_verify(Request $request)
    {
        $this->validate($request, [
            'photo_card.*' => "nullable|image|mimes:jpeg,jpg,png,webp|max:512",
            'photo_license.*' => "nullable|image|mimes:jpeg,jpg,png,webp|max:512",
            'photo.*' => "nullable|image|mimes:jpeg,jpg,png,webp|max:512",
            'n_photo' => "nullable|image|mimes:jpeg,jpg,png,webp|max:512",
            'p_photo' => "nullable|image|mimes:jpeg,jpg,png,webp|max:512",
        ]);
        $item = User::findOrFail(Auth::user()->id);
        $verify_change = false;
        try {
            //edit Business Card
            if ($request->hasFile('photo_card')) {
                $verify_change = true;
                foreach ($request->photo_card as $photo) {
                    $certificate_card = UserCertificate::create([
                        'user_id' => $item->id,
                        'type_id' => 0,
                        'type_title' => 'business_card',
                    ]);
                    $photos = new Photo();
                    $photos->type = 'photo';
                    $photos->path = file_store($photo, 'assets/admin/uploads/setting/profile/business_card' . '/');
                    $certificate_card->photo()->save($photos);
                }
            }
            if ($request->hasFile('photo_license')) {
                $verify_change = true;
                foreach ($request->photo_license as $key => $photo) {
                    $certificate_license = UserCertificate::create([
                        'user_id' => $item->id,
                        'type_id' => 0,
                        'type_title' => 'business_license',
                        'tax_id' => $request->license_number[$key],
                    ]);
                    $photos = new Photo();
                    $photos->type = 'photo';
                    $photos->path = file_store($photo, 'assets/admin/uploads/setting/profile/business_license' . '/');
                    $certificate_license->photo()->save($photos);
                }
            }
            if ($request->hasFile('photo')) {
                $verify_change = true;
                foreach ($request->photo as $key => $photo) {
                    $certificate = UserCertificate::create([
                        'user_id' => $item->id,
                        'type_id' => $request->type_id[$key],
                        'type_title' => $request->type_title[$key],
                        'tax_id' => $request->tax_id[$key],
                    ]);
                    $photos = new Photo();
                    $photos->type = 'photo';
                    $photos->path = file_store($photo, 'assets/admin/uploads/setting/profile/certificate' . '/');
                    $certificate->photo()->save($photos);
                }
            }
            if ($request->hasFile('n_photo') || !blank($request->n_code)) {
                $old = UserCertificate::where('type_title', 'n_cart')->where('user_id', $item->id)->first();
                if ($old) {
                    $verify_change = true;
                    $old->tax_id = $request->n_code;
                    $old->update();
                    if ($request->hasFile('n_photo')) {
                        if ($old->photo) {
                            if (is_file($old->photo->path)) {
                                File::delete($old->photo->path);
                                delete_directory($old->photo->path);
                            }
                            $old->photo->delete();
                        }
                        $photos = new Photo();
                        $photos->type = 'photo';
                        $photos->path = file_store($request->n_photo, 'assets/admin/uploads/setting/profile/n_cart' . '/');
                        $old->photo()->save($photos);
                    }
                } else {
                    if ($request->hasFile('n_photo')) {
                        $verify_change = true;
                        $certificate_license = UserCertificate::create([
                            'user_id' => $item->id,
                            'type_id' => 0,
                            'type_title' => 'n_cart',
                            'tax_id' => $request->n_code,
                        ]);
                        $photos = new Photo();
                        $photos->type = 'photo';
                        $photos->path = file_store($request->n_photo, 'assets/admin/uploads/setting/profile/n_cart' . '/');
                        $certificate_license->photo()->save($photos);
                    }
                }
            }
            if ($request->hasFile('p_photo') || !blank($request->p_code)) {
                $old = UserCertificate::where('type_title', 'passport')->where('user_id', $item->id)->first();
                if ($old) {
                    $verify_change = true;
                    $old->tax_id = $request->p_code;
                    $old->update();
                    if ($request->hasFile('p_photo')) {
                        if ($old->photo) {
                            if (is_file($old->photo->path)) {
                                File::delete($old->photo->path);
                                delete_directory($old->photo->path);
                            }
                            $old->photo->delete();
                        }
                        $photos = new Photo();
                        $photos->type = 'photo';
                        $photos->path = file_store($request->p_photo, 'assets/admin/uploads/setting/profile/passport' . '/');
                        $old->photo()->save($photos);
                    }
                } else {
                    if ($request->hasFile('p_photo')) {
                        $verify_change = true;
                        $certificate_license = UserCertificate::create([
                            'user_id' => $item->id,
                            'type_id' => 0,
                            'type_title' => 'passport',
                            'tax_id' => $request->p_code,
                        ]);

                        $photos = new Photo();
                        $photos->type = 'photo';
                        $photos->path = file_store($request->p_photo, 'assets/admin/uploads/setting/profile/passport' . '/');
                        $certificate_license->photo()->save($photos);

                    }
                }
            }

            if ($verify_change) {
                $item->status_verify = 'pending';
                $item->update();
            }
            return redirect()->back()->with('flash_message', translateText('اطلاعات با موفقیت ثبت شد', lang_admin()));
        } catch
        (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای ثبت به مشکل خوردیم، مجدد تلاش کنید', lang_admin()));
        }
    }

    public
    function delete_verify_certificate($id)
    {
        $item = User::findOrFail(Auth::user()->id);
        $certificate = UserCertificate::where('user_id', $item->id)->findOrFail($id);
        try {
            $certificate->delete();

            $item->status_verify = 'pending';
            $item->update();
            return redirect()->back()->with('flash_message', translateText('اطلاعات با موفقیت حذف شد', lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای حذف به مشکل خوردیم، مجدد تلاش کنید', lang_admin()));
        }
    }

    public
    function edit_address()
    {
        $item = User::findOrFail(Auth::user()->id);
        $addresses = UserAddress::where('user_id', $item->id)->get();
        if (auth()->user()->hasRole('supplier'))
            $countries = Country::where('nicename', 'Turkey')->orderBy('nicename')->get();
        elseif (auth()->user()->hasRole('buyer'))
            $countries = Country::where('nicename', 'Iraq')->orderBy('nicename')->get();
        else
            $countries = Country::orderBy('nicename')->get();
        return view('admin.setting.profile.address', compact('item', 'addresses', 'countries'));
    }

    public
    function edited_address($id)
    {
        $item = User::findOrFail(Auth::user()->id);
        $address = UserAddress::findOrFail($id);
        if (auth()->user()->hasRole('supplier'))
            $countries = Country::where('nicename', 'Turkey')->orderBy('nicename')->get();
        elseif (auth()->user()->hasRole('buyer'))
            $countries = Country::where('nicename', 'Iraq')->orderBy('nicename')->get();
        else
            $countries = Country::orderBy('nicename')->get();

        $url_back = route('admin.profile.edit.address');
        return view('admin.setting.profile.address_edit', compact('item', 'address', 'countries', 'url_back'));
    }

    public
    function update_address(Request $request)
    {
        $this->validate($request, [
            'full_name' => "required|max:200",
            'country_id' => "required",
            'phone' => "required|numeric",
            'mobile' => "nullable|numeric",
            'fax' => "nullable|numeric",
            'email' => "required|email",
            'state' => "required|max:200",
            'city' => "required|max:200",
            'zip_code' => "required|max:200",
            'address' => "required",
        ]);
        $item = User::findOrFail(Auth::user()->id);
        $country = Country::findOrFail($request->country_id);
        try {
            UserAddress::create([
                'user_id' => auth()->id(),
                'full_name' => $request->full_name,
                'country_id' => $request->country_id,
                'code' => $country->phonecode,
                'phone' => $request->phone,
                'mobile' => $request->mobile,
                'fax' => $request->fax,
                'email' => $request->email,
                'state' => $request->state,
                'city' => $request->city,
                'zip_code' => $request->zip_code,
                'latitude' => $request->latitude,
                'longitude' => $request->longitude,
                'address' => $request->address,
            ]);
            return redirect()->back()->with('flash_message', translateText('اطلاعات با موفقیت افزوده شد', lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای افزودن به مشکل خوردیم، مجدد تلاش کنید', lang_admin()));
        }
    }

    public
    function updated_address(Request $request, $id)
    {
        $url_back = route('admin.profile.edit.address');
        $this->validate($request, [
            'full_name' => "required|max:200",
            'country_id' => "required",
            'phone' => "required|numeric",
            'mobile' => "nullable|numeric",
            'fax' => "nullable|numeric",
            'email' => "required|email",
            'state' => "required|max:200",
            'city' => "required|max:200",
            'zip_code' => "required|max:200",
            'address' => "required",
        ]);
        $item = UserAddress::findOrFail($id);
        $country = Country::findOrFail($request->country_id);
        try {
            UserAddress::where('id', $id)->update([
                'full_name' => $request->full_name,
                'country_id' => $request->country_id,
                'code' => $country->phonecode,
                'phone' => $request->phone,
                'mobile' => $request->mobile,
                'fax' => $request->fax,
                'email' => $request->email,
                'state' => $request->state,
                'city' => $request->city,
                'zip_code' => $request->zip_code,
                'latitude' => $request->latitude,
                'longitude' => $request->longitude,
                'address' => $request->address,
            ]);
            return redirect($url_back)->with('flash_message', translateText('اطلاعات با موفقیت ویرایش شد', lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای ویرایش به مشکل خوردیم، مجدد تلاش کنید', lang_admin()));
        }
    }

    public
    function delete_address($id)
    {
        $item = User::findOrFail(Auth::user()->id);
        $address = UserAddress::where('user_id', $item->id)->findOrFail($id);
        try {
            $address->delete();

            return redirect()->back()->with('flash_message', translateText('اطلاعات با موفقیت حذف شد', lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای حذف به مشکل خوردیم، مجدد تلاش کنید', lang_admin()));
        }
    }
    public
    function package_sale($id)
    {
        $item = User::findOrFail(Auth::user()->id);
        $pack = SettingSale::findOrFail($id);
        try {
            $verify=Verify::create([
                'user_id'=>$item->id,
                'p_id'=>$pack->id,
                'p_title'=>$pack->title,
                'price'=>$pack->price,
                'type'=>$pack->type,
                'ex_date'=>Carbon::now()->addMonths($pack->ex_month),
            ]);

            return redirect()->route('nestpay.confirment',$verify->id);
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای پرداخت به مشکل خوردیم، مجدد تلاش کنید', lang_admin()));
        }
    }
}
