<?php

namespace App\Http\Controllers\Admin\Setting;

use App\Models\Select;
use App\Http\Requests\Setting\SelectRequest;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;

use Spatie\Permission\Models\Permission;
class SelectController extends Controller
{
    public function controller_title($type)
    {
        switch ($type)
        {
            case 'index':
                return translateText('گزینه(ثبت نام)',lang_admin());
                break;
            case 'create':
                return translateText('افزودن گزینه',lang_admin());
                break;
            case 'edit':
                return translateText('ویرایش گزینه',lang_admin());
                break;
            case 'url_back':
                return route('admin.select.index');
                break;
            default:
                return '';
                break;
        }
    }
    public function __construct()
    {
        $this->middleware('permission:select_list', ['only' => ['index','show']]);
        $this->middleware('permission:select_create', ['only' => ['create','store']]);
        $this->middleware('permission:select_edit', ['only' => ['edit','update']]);
        $this->middleware('permission:select_delete', ['only' => ['destroy']]);
        $this->middleware('permission:select_status', ['only' => ['status']]);
    }

    public function index(Request $request)
    {
        if(!isset($request->type))
        {
            abort(404);
        }
        $type=$request->type;
        $items=Select::where('type',$type)->orderByDesc('id')->get();
        return view('admin.setting.select.index', compact('items','type'), ['title' => $this->controller_title('index').'('.Select::get_type($type).')']);
    }
    public function show($id)
    {

    }
    public function create(Request $request)
    {
        if(!isset($request->type))
        {
            abort(404);
        }
        $type=$request->type;
        $url_back=$this->controller_title('url_back').'?type='.$type;
        return view('admin.setting.select.create',compact('url_back','type'), ['title' => $this->controller_title('create').'('.Select::get_type($type).')']);
    }
    public function store(SelectRequest $request)
    {
        try {
            $item = Select::create([
                'type' => $request->type,
                'title' => $request->title,
            ]);

            store_lang($item,$request,['title'],'create');
            return redirect($this->controller_title('url_back').'?type='.$item->type)->with('flash_message', translateText('اطلاعات با موفقیت افزوده شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای افزودن به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
    public function edit($id)
    {
        $item=Select::findOrFail($id);
        $url_back=$this->controller_title('url_back').'?type='.$item->type;
        return view('admin.setting.select.edit',compact('url_back','item'), ['title' => $this->controller_title('edit').'('.$item->get_type($item->type).')']);
    }
    public function update(SelectRequest $request,$id)
    {
        $item=Select::findOrFail($id);
        try {
            Select::where('id',$id)->update([
                'title' => $request->title,
            ]);
            store_lang($item,$request,['title'],'edit');
            return redirect($this->controller_title('url_back').'?type='.$item->type)->with('flash_message', translateText('اطلاعات با موفقیت ویرایش شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای ویرایش به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
    public function destroy($id)
    {
        $item=Select::findOrFail($id);
        try {
            if($item->type == 'business_type' && count($item->user_business))
                return redirect()->back()->withInput()->with('err_message', translateText('برای حذف به مشکل خوردیم، به کاربران وصل است',lang_admin()));
            elseif($item->type == 'purchasing_frequency' && count($item->user_purchasing))
                return redirect()->back()->withInput()->with('err_message', translateText('برای حذف به مشکل خوردیم، به کاربران وصل است',lang_admin()));
            elseif($item->type == 'annual_purchase_volume' && count($item->user_volume))
                return redirect()->back()->withInput()->with('err_message', translateText('برای حذف به مشکل خوردیم، به کاربران وصل است',lang_admin()));
            elseif($item->type == 'certificate' && count($item->user_certificate))
                return redirect()->back()->withInput()->with('err_message', translateText('برای حذف به مشکل خوردیم، به کاربران وصل است',lang_admin()));

            $item->delete();
            return redirect()->back()->with('flash_message', translateText('اطلاعات با موفقیت حذف شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای حذف به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

    public function status($id,$type,$status)
    {
        $item=Select::findOrFail($id);
        try {
            $item->$type=$status;
            $item->update();
            return redirect()->back()->with('flash_message', translateText('اطلاعات با موفقیت تغییر وضعیت شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای تغییر وضعیت به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
}
