<?php

namespace App\Http\Controllers\Admin\Setting;

use App\Models\Lang;
use App\Models\SiteWord;
use App\Models\Photo;
use App\Http\Requests\Setting\SiteWordRequest;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;

class SiteWordController extends Controller
{
    public function controller_title($type)
    {
        switch ($type)
        {
            case 'index':
                return translateText('واژه های ثابت',lang_admin());
                break;
            case 'create':
                return translateText('افزودن واژه',lang_admin());
                break;
            case 'edit':
                return translateText('ویرایش واژه',lang_admin());
                break;
            case 'url_back':
                return route('admin.site-word.index');
                break;
            default:
                return '';
                break;
        }
    }
    public function __construct()
    {
        $this->middleware('permission:site_word_list', ['only' => ['index','show']]);
        $this->middleware('permission:site_word_create', ['only' => ['create','store']]);
        $this->middleware('permission:site_word_edit', ['only' => ['edit','update']]);
        $this->middleware('permission:site_word_delete', ['only' => ['destroy']]);
        $this->middleware('permission:site_word_status', ['only' => ['status']]);
    }

    public function index()
    {
        $items=SiteWord::orderBy('slug')->get();
//        $all=0;
//        $trans=0;
//        if(request()->r==125)
//        {
//            foreach ($items as $item)
//            {
//////            if(blank(read_lang_word($item->word,'en')))
//////            {
//////                $new_l = new Lang();
//////                $new_l->col_name = 'word';
//////                $new_l->lang = 'en';
//////                $new_l->text = strtoupper(translateText2('fa','en',$item->word));
//////                $item->langs()->save($new_l);
//////                $trans++;
//////            }
//                if(blank(read_lang($item,'word','tr')))
//                {
//                    $new_l = new Lang();
//                    $new_l->col_name = 'word';
//                    $new_l->lang = 'tr';
//                    $new_l->text = translateText2($item->word,'fa','tr');
//                    $item->langs()->save($new_l);
//
//                }
//                if(blank(read_lang($item,'word','ar')))
//                {
//                    $new_l = new Lang();
//                    $new_l->col_name = 'word';
//                    $new_l->lang = 'ar';
//                    $new_l->text = translateText2($item->word,'fa','ar');
//                    $item->langs()->save($new_l);
//
//                }
//                if(blank(read_lang($item,'word','ckb')))
//                {
//                    $new_l = new Lang();
//                    $new_l->col_name = 'word';
//                    $new_l->lang = 'ckb';
//                    $new_l->text = translateText2($item->word,'fa','ckb');
//                    $item->langs()->save($new_l);
//
//                }
////            $all++;
//            }
//        }
//        dd($all,$trans);
        return view('admin.setting.site_word.index', compact('items'), ['title' => $this->controller_title('index')]);
    }
    public function show($id)
    {

    }
    public function create()
    {
        if(!auth()->user()->hasRole('developer'))
        {
            abort(404);
        }
        $url_back=$this->controller_title('url_back');
        return view('admin.setting.site_word.create',compact('url_back'), ['title' => $this->controller_title('create')]);
    }
    public function store(SiteWordRequest $request)
    {
        try {
            $item = SiteWord::create([
                'slug' => $request->slug,
                'word' => $request->word,
            ]);
            store_lang2($item,$request,['word'],'create');

            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت افزوده شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای افزودن به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
    public function edit($id)
    {
        $url_back=$this->controller_title('url_back');
        $item=SiteWord::findOrFail($id);
        return view('admin.setting.site_word.edit',compact('url_back','item'), ['title' => $this->controller_title('edit')]);
    }
    public function update(SiteWordRequest $request,$id)
    {
        $item=SiteWord::findOrFail($id);
        try {
            SiteWord::where('id',$id)->update([
                'slug' => $request->slug??$item->slug,
                'word' => $request->word,
            ]);
            store_lang2($item,$request,['word'],'edit');

            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت ویرایش شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message',translateText('برای ویرایش به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
    public function destroy($id)
    {
        $item=SiteWord::findOrFail($id);
        try {
            $item->delete();
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت حذف شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای حذف به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

}
