<?php

namespace App\Http\Controllers\Admin\Setting;

use App\Http\Controllers\Controller;
use App\Http\Requests\Setting\UploadRequest;
use App\Models\Upload;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Spatie\Permission\Models\Permission;

class UploadController extends Controller
{
    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return translateText('آپلود فایل',lang_admin());
                break;
            case 'create':
                return translateText('افزودن فایل',lang_admin());
                break;
            case 'edit':
                return translateText('ویرایش فایل',lang_admin());
                break;
            case 'url_back':
                return route('admin.upload.index');
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:upload_list', ['only' => ['index', 'show']]);
        $this->middleware('permission:upload_create', ['only' => ['create', 'store']]);
        $this->middleware('permission:upload_delete', ['only' => ['destroy']]);
    }

    public function index()
    {
        $items = Upload::orderByDesc('id')->get();
        return view('admin.setting.upload.index', compact('items'), ['title' => $this->controller_title('index')]);
    }

    public function show($id)
    {

    }

    public function create()
    {
        $url_back = $this->controller_title('url_back');
        return view('admin.setting.upload.create', compact('url_back'), ['title' => $this->controller_title('create')]);
    }

    public function store(UploadRequest $request)
    {
        try {
            $item = Upload::create([
                'title' => $request->title,
            ]);

            if ($request->hasFile('file')) {
                $item->file = file_store($request->file, 'assets/admin/uploads/setting/upload-file' . '/');
                $item->save();
            }
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت افزوده شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای افزودن به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

    public function edit($id)
    {

    }

    public function update(Request $request, $id)
    {

    }

    public function destroy($id)
    {
        $item = Upload::findOrFail($id);
        try {
            $item->delete();
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت حذف شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای حذف به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
}
