<?php

namespace App\Http\Controllers\Admin\Setting;

use App\Http\Controllers\Controller;
use App\Http\Requests\Setting\UploadRobotRequest;
use App\Models\UploadRobot;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Spatie\Permission\Models\Permission;

class UploadRobotController extends Controller
{
    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return translateText('آپلود Robots',lang_admin());
                break;
            case 'url_back':
                return route('admin.upload-robots.index');
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:upload_robot_list', ['only' => ['index']]);
        $this->middleware('permission:upload_robot_edit', ['only' => ['update']]);
    }

    public function index()
    {
        $item = UploadRobot::firstOrFail();
        return view('admin.setting.upload_robots.index', compact('item'), ['title' => $this->controller_title('index')]);
    }

    public function show($id)
    {
    }

    public function create()
    {
        //
    }

    public function store(UploadRequest $request)
    {
        //
    }

    public function edit($id)
    {
        //
    }

    public function update(UploadRobotRequest $request, $id)
    {
        $item = UploadRobot::findOrFail($id);
        try {
            if ($request->hasFile('file')) {
                $request->file->move('./', 'robots.txt');
                $item->update();
            }
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت ویرایش شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message',translateText('برای ویرایش به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

    public function destroy($id)
    {
        //
    }
}
