<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use App\Models\User;
use App\Models\OfficeInformation;
use Illuminate\Http\Request;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use App\Mail\Mail;
use Illuminate\Support\Str;

class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param array $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        return Validator::make($data, [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password' => ['required', 'string', 'min:8', 'confirmed'],
        ]);
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param array $data
     * @return \App\Models\User
     */
    protected function create(array $data)
    {
        return User::create([
            'name' => $data['name'],
            'email' => $data['email'],
            'password' => Hash::make($data['password']),
        ]);
    }

    /* public function send_mail(Request $request)
     {

         try {
             if (!filter_var($request->email, FILTER_VALIDATE_EMAIL)) {
                 return response()->json([
                     'status' => 'danger',
                     'title' => read_lang_word('unsuccessful'),
                     'msg' => read_lang_word('err-email')
                 ], 422);
             }

             $user = User::where('username', $request->email)->first();
             if ($user) {
                 return redirect()->route('front.loginnew')->with('err_message', read_lang_word('this-email-has-already-been-registered'));
             }

             $verificationCode = rand(1000, 9999);
             session(['rand_code' => $verificationCode]);
             session(['email_register' => $request->email]);

             return response()->json([
                 'status' => 'success',
                 'title' => read_lang_word('verification-code'),
                 'msg' => 'Your verification code is: ' . $verificationCode,
                 'code' => $verificationCode
             ], 200);

         } catch (\Exception $e) {
             \Log::error('send_mail error: ' . $e->getMessage());
             return response()->json([
                 'status' => 'danger',
                 'title' => read_lang_word('unsuccessful'),
                 'msg' => read_lang_word('server-error')
             ], 500);
         }
     }*/
    public function send_mail(Request $request)
    {
        try {
            if (!filter_var($request->email, FILTER_VALIDATE_EMAIL)) {
                return response()->json([
                    'status' => 'danger',
                    'title' => read_lang_word('unsuccessful'),
                    'msg' => read_lang_word('err-email')
                ], 422);
            }

            $user = User::where('username', $request->email)->first();
            if ($user) {
                return response()->json([
                    'status' => 'danger',
                    'title' => read_lang_word('unsuccessful'),
                    'msg' => read_lang_word('err-user')
                ], 422);
            }

            session(['rand_code' => 1234 /*rand(1000, 9999)*/]);
            session(['email_register' => $request->email]);

            /* $text = '<div dir="ltr">';
             $text .= '<h1 style="text-align: center;font-family: cursive">Verification Code:</h1>';
             $text .= '<h1 style="text-align: center;font-size: 50px">';
             $text .= '<strong dir="ltr" style="letter-spacing: 20px;color:#003c70;font-family: cursive">';
             $text .= session('rand_code');
             $text .= '</strong>';
             $text .= '</h1>';
             $text .= '</div>';

             $details = [
                 'subject' => 'Notification Mainexpo',
                 'title' => 'Notification Mainexpo',
                 'body' => $text
             ];

            $x = \Mail::to(session('email_register'))->send(new \App\Mail\Mail($details));*/

            return response()->json([
                'status' => 'success',
                'title' => read_lang_word('successful'),
                'msg' => read_lang_word('success-send-code')
            ], 200);
        } catch (\Exception $e) {
            \Log::error('send_mail error: ' . $e->getMessage());
            return response()->json([
                'status' => 'danger',
                'title' => read_lang_word('unsuccessful'),
                'msg' => read_lang_word('server-error')
            ], 500);
        }
    }

    public function verify_mail(Request $request)
    {
        if (!session()->has('rand_code') || !is_numeric($request->verify) || session('rand_code') != $request->verify)
            return ['status' => 'danger', 'title' => read_lang_word('unsuccessful'), 'msg' => read_lang_word('err-verify')];

        $user = User::query()->where('username', session('email_register'))->first();
        if ($user)
            return ['status' => 'danger', 'title' => read_lang_word('unsuccessful'), 'msg' => read_lang_word('err-user')];

        return ['status' => 'success', 'title' => read_lang_word('successful'), 'msg' => read_lang_word('success-send-code-active')];
    }

    public function clear_mail()
    {
        if (session()->has('rand_code'))
            session()->forget('rand_code');

        if (session()->has('email_register'))
            session()->forget('email_register');

        return ['status' => 'success', 'title' => read_lang_word('successful'), 'msg' => read_lang_word('success-clear-mail')];
    }

    public function register_end(Request $request)
    {

        $rules = [
            'name' => 'required|max:200',
            'password' => 'required|min:6',
            'role_id' => 'required|in:2,3',
            'mobile_number' => 'required|string',
            'country' => 'required|string',
            'products_needed' => 'string|nullable',
            'products_supplier' => 'string|nullable',
            'services_supplier' => 'string|nullable',
        ];
        if ($request->role_id == 2) {
            $rules['company_name1'] = 'nullable';
            $company_name = $request->company_name1;
        } else {
            $rules['company_name2'] = 'required';
            $company_name = $request->company_name2;
        }
        $validator = Validator::make($request->all(), $rules);

        $role = $request->role_id == 2 ? 'buyer' : 'supplier';

        if ($validator->fails()) {
            return [
                'status' => 'error',
                'title' => read_lang_word('unsuccessful'),
                'errors' => $validator->errors(),
            ];
        }

        $user = User::where('username', session('email_register'))->first();
        if ($user) {
            return [
                'status' => 'danger',
                'title' => read_lang_word('unsuccessful'),
                'msg' => read_lang_word('err-user')
            ];
        }

        $user = User::create([
            'dashboard_code' => strtolower(Str::random(12)),
            'username' => session('email_register'),
            'name' => $request->name,
            'password' => $request->password,
            'company_name' => $company_name,
            'mobile' => $request->mobile_number,
            'country_code' => $request->country,
            'products_needed' => $request->products_needed,
            'products_supplier' => $request->products_supplier,
            'services_supplier' => $request->services_supplier,
            'is_private_buyer' => $role === 'buyer' && $request->private_buyer ? true : false,
        ]);

        $user->assignRole($role);

        auth()->login($user);
        if ($role == 'supplier') {
            OfficeInformation::create([
                'user_id' => $user->id,
                'dashboard_code' => $user->dashboard_code,
                'type' => 'head',
            ]);
        }
        return redirect()->route('dashboard')->with('flash_message', read_lang_word('msg-success-form'));
    }
}
