<?php
namespace App\Http\Controllers;


use App\Models\State;
use App\Models\City;

class LocationController extends Controller
{
    public function getStatesByCountry($countryId)
    {
        $states = State::where('country_id', $countryId)->orderBy('name')->get(['id', 'name']);
        return response()->json($states);
    }

    public function getCitiesByState($stateId)
    {
        $cities = City::where('state_id', $stateId)->orderBy('name')->get(['id', 'name']);
        return response()->json($cities);
    }
}