<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use Cubes\Nestpay\MerchantService;
use App\Models\Verify;

class NestpayController extends Controller
{
	public function confirment($id,Request $request)
	{
        $item=Verify::findOrFail($id);
        $paymentData = $this->getPaymentData($id);
        

        return view('nestpay.confirm', [
			'paymentData' => $paymentData,
            'id'=>$id
		],
            ["title" => read_lang_word('meta', 'Nestpay1')]);

    }
    public function confirm(MerchantService $nestpayMerchantService,$id, Request $request)
    {
        $item=Verify::findOrFail($id);
        $paymentData = $this->getPaymentData($id);

        //change the routes for success and fail
        $nestpayMerchantService->getMerchantConfig()->setConfig([
			'okUrl' => route('nestpay.success'),
			'failUrl' => route('nestpay.fail'),
		]);
		
        $formFields = $nestpayMerchantService->paymentMakeRequestParameters($paymentData);
        return response()->json($formFields);
    }
    public function success(MerchantService $nestpayMerchantService, Request $request)
    {
        $payment = null;
        $ex = null;
		
		try {
            $payment = $nestpayMerchantService->paymentProcess3DGateResponse($request->all());
            $item=Verify::findOrFail($payment->INVOICENUMBER);
            $item->TransId=$payment['TransId'];
            $item->status='active';
            $item->update();

            $user=$item->user;
            if($user)
            {
                $user->verify_type=$item->type;
                $user->verify_date=$item->ex_date;
                $user->update();
            }

        } catch (\Cubes\Nestpay\PaymentAlreadyProcessedException $ex) {
            $ex = null;//comment this if you want to show this exception if debug is on
		} catch (\Exception $ex) {
		} finally {
            try {
				$payment = $nestpayMerchantService->getWorkingPayment();
			} catch (\Exception $exTemp) {}
        }

        if ($ex && config('app.debug')) {
            throw $ex;
        }

        return view('nestpay.result', [
            'payment' => $payment,
            'exception' => $ex,
        ],
            ["title" => read_lang_word('meta', 'Nestpay2')]);
    }
    public function fail(MerchantService $nestpayMerchantService, Request $request)
    {
        $payment = null;
        $ex = null;

		try {
			$payment = $nestpayMerchantService->paymentProcess3DGateResponse($request->all());
            $item=Verify::findOrFail($payment->INVOICENUMBER);
            $item->status='failed';
            $item->update();
		} catch (\Cubes\Nestpay\PaymentAlreadyProcessedException $ex) {
            $ex = null;//comment this if you want to show this exception if debug is on

		} catch (\Exception $ex) {
		} finally {
            try {
				$payment = $nestpayMerchantService->getWorkingPayment();
			} catch (\Exception $exTemp) {}
        }

        if ($ex && config('app.debug')) {
            //if debug is enabled throw exception
            throw $ex;
        }

        return view('nestpay.result', [
            'payment' => $payment,
            'exception' => $ex,
            'isFail' => true
        ],
            ["title" => read_lang_word('meta', 'Nestpay3')]);
    }
    protected function getPaymentData($id)
    {
        $verify=Verify::findOrFail($id);
        $user=$verify->user;
        return [
            \Cubes\Nestpay\Payment::PROP_TRANTYPE => \Cubes\Nestpay\Payment::TRAN_TYPE_PREAUTH, //two step processing
            //\Cubes\Nestpay\Payment::PROP_TRANTYPE => \Cubes\Nestpay\Payment::TRAN_TYPE_AUTH, //single step processing

            //Below is required data for payment

//            \Cubes\Nestpay\Payment::PROP_AMOUNT => auth()->check() && auth()->id() == 1 ? 5 :$verify->price,
            \Cubes\Nestpay\Payment::PROP_AMOUNT => $verify->price,
            \Cubes\Nestpay\Payment::PROP_CURRENCY => \Cubes\Nestpay\Payment::CURRENCY_TL,
            //change with the name of your customer (reading from config is just for example)
            \Cubes\Nestpay\Payment::PROP_BILLTONAME => $user->name.'('.$verify->p_title.')',
            //change with email of your customer (reading from config is just for example)
			\Cubes\Nestpay\Payment::PROP_EMAIL => $user->username ? $user->username : 'info@mainexpo.com.tr',

            

            //Below is optional data for payment (here are added for example)
            
            //This is good practice to read language from app locale
			\Cubes\Nestpay\Payment::PROP_LANG => app()->getLocale(),

			\Cubes\Nestpay\Payment::PROP_INVOICENUMBER => $verify->id, //MUST BE NUMERIC!!!
			\Cubes\Nestpay\Payment::PROP_refreshtime => 5, //MUST BE NUMERIC!!!
			\Cubes\Nestpay\Payment::PROP_DESCRIPTION => 'OrderCode= '.$verify->id,
			
			\Cubes\Nestpay\Payment::PROP_BILLTOSTREET1 =>'No Address' ,
			\Cubes\Nestpay\Payment::PROP_BILLTOCITY => 'Istanbul',
			\Cubes\Nestpay\Payment::PROP_BILLTOCOUNTRY => 'Turkey',
			\Cubes\Nestpay\Payment::PROP_TEL => $user->mobile,
        ];
    }
}
