<?php

namespace App\Http\Requests\Access;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class PermissionCatRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'table_name' => 'required|max:250',
                    'access_code' => 'required|max:250',
                ];
            }
            case 'PATCH':
            {
                $id=$this->request->get('id');
                return [
                    'table_name' => 'required|max:250',
                    'access_code' => 'required|max:250',
                ];
            }
            default:
                break;
        }
    }
}
