<?php

namespace App\Http\Requests\Blog;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class BlogCategoryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'title' => 'required|max:240',
                    'slug' => 'required|max:300|unique:blog_categories,slug',
                    'status' => 'required',
                ];
            }
            case 'PATCH':
            {
                $id = $this->request->get('id');

                return [
                    'title' => 'required|max:240',
                    'slug' => 'required|max:300|unique:blog_categories,slug,' . $id,
                    'status' => 'required',
                ];
            }
            default:
                break;
        }
    }
}
