<?php

namespace App\Http\Requests\Company;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class ContactInformationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
            }
            case 'PATCH':
            {
                $id=$this->request->get('id');
                return [
                    'contact_person' => ['required', 'string', 'max:255'],
                    'job_title' => ['required', 'string', 'max:255'],
                    'department' => ['nullable', 'string', 'max:255'],
                    'email_address' => ['required', 'email', 'max:255'],
                    'backup_email' => ['required', 'email', 'max:255'],
                    'phone_number' => ['required', 'string', 'max:20'],
                    'mobile_number' => ['required', 'string', 'max:20'],
                    'fax_number' => ['nullable', 'string', 'max:20'],
                    'social_media' => ['required', 'array', 'max:500'],
                    'supported_languages' => ['required', 'array', 'max:250'],
                    'country_id' => ['required', 'exists:countries,id'],
                    'state_id' => ['required', 'exists:states,id'],
                    'city_id' => ['required', 'exists:cities,id'],
                    'street' => ['required', 'string', 'max:255'],
                    'post_code' => ['required', 'string', 'max:20'],
                    'time_zone' => ['required', 'string', 'max:50'],
                    'profile' => ['nullable', 'image','mimes:jpeg,jpg,png,webp', 'max:2024'],
                ];
            }
            default:
                break;
        }
    }
}
